/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.rpcadapter.websphere.internal.facets;

import com.ibm.etools.webtools.rpcadapter.websphere.internal.facets.Web2FeaturePackFacetUtil;
import com.ibm.ws.ast.st.common.core.AbstractWASFeaturePack;
import com.ibm.ws.ast.st.core.WASRuntimeLocator;
import com.ibm.ws.ast.st.core.WASRuntimeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.server.core.internal.facets.FacetUtil;

public class Web2FeaturePackClasspathInitializer
extends AbstractWASFeaturePack {
    private static final String WEB20_FEATUREPACK_ID = "com.ibm.etools.webtools.rpcadapter.websphere.internal.Web2FeaturePack";

    public List<String> getExternalJars(IProject project) {
        List<String> jarList;
        block5: {
            jarList = new ArrayList<String>();
            String[] fepFacets = null;
            if (project != null) {
                try {
                    IFacetedProject fProj = ProjectFacetsManager.create((IProject)project);
                    if (fProj == null || (fepFacets = this.getFeaturePackFacets(WEB20_FEATUREPACK_ID)) == null || fepFacets.length <= 0) break block5;
                    int i = 0;
                    while (i < fepFacets.length) {
                        IProjectFacet curFacet = ProjectFacetsManager.getProjectFacet((String)fepFacets[i]);
                        if (curFacet != null && fProj.hasProjectFacet(curFacet)) {
                            jarList = this.addWeb20Jars(fProj);
                            break;
                        }
                        ++i;
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
        return jarList;
    }

    protected String getFeaturePackID() {
        return WEB20_FEATUREPACK_ID;
    }

    private List<String> addWeb20Jars(IFacetedProject facetedProj) {
        String[] serverRelativePaths;
        ArrayList<String> jars = new ArrayList<String>();
        IPath serverPath = null;
        serverPath = this.isWeb2FPInstalled(facetedProj) ? Web2FeaturePackFacetUtil.getRuntime(facetedProj.getProject()).getLocation() : WASRuntimeLocator.getRuntimeStubLocation((byte)1);
        String[] stringArray = serverRelativePaths = Web2FeaturePackFacetUtil.searchOptionalLibraries(facetedProj.getProject(), null);
        int n = serverRelativePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            jars.add(serverPath.append("web2fep").append(s).toString());
            ++n2;
        }
        return jars;
    }

    private boolean isWeb2FPInstalled(IFacetedProject facetedProj) {
        Set runtimes = facetedProj.getTargetedRuntimes();
        for (IRuntime runtime : runtimes) {
            String web2fepStubPathString;
            Path web2fepStubpath;
            org.eclipse.wst.server.core.IRuntime wasRuntime = FacetUtil.getRuntime((IRuntime)runtime);
            if (WASRuntimeUtil.isFeaturePackInstalled((org.eclipse.wst.server.core.IRuntime)wasRuntime, (String)"WEB2FEP")) {
                return true;
            }
            if (!wasRuntime.isStub() || !(web2fepStubpath = new Path(web2fepStubPathString = String.valueOf(wasRuntime.getLocation().toOSString()) + '/' + "web2fep")).toFile().exists()) continue;
            return true;
        }
        return false;
    }
}

