/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.rpcadapter.ui.internal.wizard.pages;

import com.ibm.etools.webtools.rpcadapter.core.internal.util.EJBRefUtil;
import com.ibm.etools.webtools.rpcadapter.core.internal.util.EJBReferenceWrapper;
import com.ibm.etools.webtools.rpcadapter.core.internal.util.JavaUtil;
import com.ibm.etools.webtools.rpcadapter.core.internal.util.ServiceUtil;
import com.ibm.etools.webtools.rpcadapter.core.model.Service;
import com.ibm.etools.webtools.rpcadapter.core.model.ServiceMethod;
import com.ibm.etools.webtools.rpcadapter.ui.Activator;
import com.ibm.etools.webtools.rpcadapter.ui.internal.ProjectFacetsUtil;
import com.ibm.etools.webtools.rpcadapter.ui.internal.nls.Messages;
import com.ibm.etools.webtools.rpcadapter.ui.internal.wizard.MethodCheckboxContentProvider;
import com.ibm.etools.webtools.rpcadapter.ui.internal.wizard.MethodCheckboxLabelProvider;
import com.ibm.etools.webtools.rpcadapter.ui.internal.wizard.SupertypeMethodViewerFilter;
import com.ibm.etools.webtools.rpcadapter.ui.internal.wizard.dialog.EJBReferenceSelectionDialog;
import com.ibm.etools.webtools.rpcadapter.ui.internal.wizard.pages.ConfigureMethodsPage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class SelectServiceMethodsPage
extends WizardPage {
    private static final String EJB_FACET_ID = "jst.ejb";
    private static final String HELP_ID = "com.ibm.etools.webtools.rpcadapter.ui.selectservice";
    private static final int METHOD_PICKER_HEIGHT = 240;
    private static final int NUM_COMPOSITE_COLUMNS = 3;
    private Button browseEJBRefButton;
    private Button browsePojoButton;
    private Button ejbRadioButton;
    private Text ejbTextField;
    private Combo ejbVersion;
    private boolean isWizardInitializing;
    private Map<IMethod, ServiceMethod> methodCache;
    private CheckboxTableViewer methodCheckboxTableViewer;
    private SupertypeMethodViewerFilter methodFilter;
    private Service model;
    private Button pojoRadioButton;
    private Text pojoTextField;
    private HashMap<Button, Set<Control>> radioSectionControls;
    private boolean runValidation;
    private Button selectAllButton;
    private Button selectNoneButton;
    private Text serviceNameText;
    private Combo ejbSessionType;
    private Hyperlink showHelpLink;
    private Button showSupertypeMethodsCheckbox;
    private FormToolkit toolkit;
    private Combo webProjectCombo;
    private Map<String, IProject> webProjectsMap;
    private HashMap<String, EJBReferenceWrapper> ejbRefsMap;
    SimpleContentProposalProvider proposalProvider;

    public SelectServiceMethodsPage(String pageName, Service service) {
        super(pageName);
        this.model = service;
        this.isWizardInitializing = true;
        this.runValidation = false;
        this.proposalProvider = new SimpleContentProposalProvider(new String[0]);
        this.proposalProvider.setFiltering(true);
    }

    public void createControl(Composite parent) {
        this.isWizardInitializing = true;
        this.toolkit = new FormToolkit(parent.getDisplay());
        Composite baseComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        baseComposite.setLayout((Layout)layout);
        GridData gData = new GridData(1, 1, true, true);
        baseComposite.setLayoutData((Object)gData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)baseComposite, HELP_ID);
        this.radioSectionControls = new HashMap();
        this.createWebProjectSelectionControls(baseComposite);
        this.createServiceNameControls(baseComposite);
        this.createHorizontalRule(baseComposite, 3);
        this.createPOJOControls(baseComposite);
        this.createEJBControls(baseComposite);
        this.createHorizontalRule(baseComposite, 3);
        this.createMethodSelectionControls(baseComposite);
        this.createHelpLinkControl(baseComposite);
        this.setPageComplete(false);
        this.setControl((Control)baseComposite);
        this.initializePageState();
        this.handleEJBSupportChange();
        this.isWizardInitializing = false;
        this.runValidation = this.model.isExistingService() || this.webProjectsMap.isEmpty() || this.model.getImplementation() != null;
    }

    private void refreshEJBRefs() {
        if (this.model.getProject() != null) {
            List ejbRefs = EJBRefUtil.getEJBRefs((IProject)this.model.getProject());
            this.ejbRefsMap = new HashMap();
            for (EJBReferenceWrapper ref : ejbRefs) {
                this.ejbRefsMap.put(ref.getInterface(), ref);
            }
            this.proposalProvider.setProposals(this.getEJBRefProposals());
        }
    }

    private void createEJBControls(Composite baseComposite) {
        this.ejbRadioButton = new Button(baseComposite, 16);
        this.ejbRadioButton.setText(Messages.SelectServiceMethodsPage_ejbRadio);
        GridData gData = new GridData(1, 1, false, false);
        this.ejbRadioButton.setLayoutData((Object)gData);
        this.ejbRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectServiceMethodsPage.this.handleRadioButtonSelectionChanged();
            }
        });
        HashSet<Object> ejbControls = new HashSet<Object>();
        this.radioSectionControls.put(this.ejbRadioButton, ejbControls);
        this.ejbTextField = new Text(baseComposite, 2048);
        this.ejbTextField.setEnabled(false);
        ContentAssistCommandAdapter contentAssist = new ContentAssistCommandAdapter((Control)this.ejbTextField, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)this.proposalProvider, null, null, true);
        contentAssist.setProposalAcceptanceStyle(2);
        gData = new GridData(768);
        this.ejbTextField.setLayoutData((Object)gData);
        ejbControls.add(this.ejbTextField);
        this.ejbTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectServiceMethodsPage.this.handleEjbTextFieldModification();
            }
        });
        this.browseEJBRefButton = new Button(baseComposite, 8);
        this.browseEJBRefButton.setText(Messages.SelectServiceMethodsPage_browse);
        this.browseEJBRefButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectServiceMethodsPage.this.handleBrowseEJBButtonPressed();
            }
        });
        ejbControls.add(this.browseEJBRefButton);
        new Label(baseComposite, 0);
        Composite beanInfoComposite = new Composite(baseComposite, 0);
        GridLayout layout = new GridLayout(2, false);
        beanInfoComposite.setLayout((Layout)layout);
        Label typeLabel = new Label(beanInfoComposite, 0);
        typeLabel.setText(Messages.SelectServiceMethodsPage_ejbSessionBeanType);
        ejbControls.add(typeLabel);
        this.ejbSessionType = new Combo(beanInfoComposite, 8);
        this.ejbSessionType.add("Stateless");
        this.ejbSessionType.add("Stateful");
        this.ejbSessionType.select(0);
        ejbControls.add(this.ejbSessionType);
        this.ejbSessionType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectServiceMethodsPage.this.handleEJBSessionBeanTypeChanged();
            }
        });
        if (!this.model.isExistingService()) {
            Label versionLabel = new Label(beanInfoComposite, 0);
            versionLabel.setText(Messages.SelectServiceMethodsPage_ejbSessionBeanVersion);
            ejbControls.add(versionLabel);
            this.ejbVersion = new Combo(beanInfoComposite, 8);
            IProjectFacet projectFacet = ProjectFacetsManager.getProjectFacet((String)EJB_FACET_ID);
            Set projectFacetVersions = projectFacet.getVersions();
            ArrayList<String> versions = new ArrayList<String>();
            for (IProjectFacetVersion fv : projectFacetVersions) {
                versions.add(fv.getVersionString());
            }
            Collections.sort(versions);
            int num = versions.size();
            int i = 0;
            while (i < num) {
                this.ejbVersion.add((String)versions.get(num - 1 - i));
                ++i;
            }
            this.ejbVersion.select(0);
            this.ejbVersion.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SelectServiceMethodsPage.this.handleEJBVersionChange();
                }
            });
            ejbControls.add(this.ejbVersion);
        }
        new Label(baseComposite, 0);
        this.refreshEJBRefs();
    }

    private void createHelpLinkControl(Composite baseComposite) {
        GridData gData = new GridData(1, 2, false, false);
        gData.horizontalSpan = 3;
        new Label(baseComposite, 0).setLayoutData((Object)gData);
        this.toolkit.setBackground(baseComposite.getBackground());
        this.showHelpLink = this.toolkit.createHyperlink(baseComposite, Messages.SelectServiceMethodsPage_learn, 0);
        GridData layout = new GridData(128);
        layout.horizontalSpan = 3;
        this.showHelpLink.setLayoutData((Object)layout);
        this.showHelpLink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent event) {
                PlatformUI.getWorkbench().getHelpSystem().displayHelp(SelectServiceMethodsPage.HELP_ID);
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
    }

    private void createHorizontalRule(Composite baseComposite, int horizantalSpan) {
        Label horizontalRuler = new Label(baseComposite, 258);
        GridData gData = new GridData(768);
        gData.horizontalSpan = horizantalSpan;
        horizontalRuler.setLayoutData((Object)gData);
    }

    private void createMethodSelectionControls(Composite baseComposite) {
        Label methodsLabel = new Label(baseComposite, 0);
        methodsLabel.setText(Messages.SelectServiceMethodsPage_methods);
        methodsLabel.setLayoutData((Object)new GridData(2));
        this.methodCheckboxTableViewer = CheckboxTableViewer.newCheckList((Composite)baseComposite, (int)2048);
        GridData gData = new GridData(1808);
        gData.heightHint = 240;
        this.methodCheckboxTableViewer.getControl().setLayoutData((Object)gData);
        this.methodCheckboxTableViewer.setContentProvider((IContentProvider)new MethodCheckboxContentProvider());
        this.methodCheckboxTableViewer.setLabelProvider((IBaseLabelProvider)new MethodCheckboxLabelProvider());
        this.methodFilter = new SupertypeMethodViewerFilter(this.model);
        this.methodFilter.setShowSuperTypeMethods(false);
        this.methodCheckboxTableViewer.addFilter((ViewerFilter)this.methodFilter);
        this.methodCheckboxTableViewer.setSorter(new ViewerSorter());
        this.methodCheckboxTableViewer.setInput((Object)this.model);
        List existingMethods = this.model.getMethodList();
        for (ServiceMethod currentServiceMethod : existingMethods) {
            TableItem[] tableItems;
            TableItem[] tableItemArray = tableItems = this.methodCheckboxTableViewer.getTable().getItems();
            int n = tableItems.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem currentItem = tableItemArray[n2];
                IMethod currentIMethod = (IMethod)currentItem.getData();
                if (currentIMethod.equals(currentServiceMethod.getJavaMethod())) {
                    this.getMethodCache().put(currentIMethod, currentServiceMethod);
                    currentItem.setChecked(true);
                }
                ++n2;
            }
        }
        this.methodCheckboxTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                SelectServiceMethodsPage.this.handleCheckStateChangeEvent();
            }
        });
        new Label(baseComposite, 0);
        new Label(baseComposite, 0);
        Composite selectButtonComposite = new Composite(baseComposite, 0);
        selectButtonComposite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        selectButtonComposite.setLayout((Layout)layout);
        this.showSupertypeMethodsCheckbox = new Button(selectButtonComposite, 32);
        this.showSupertypeMethodsCheckbox.setLayoutData((Object)new GridData(800));
        this.showSupertypeMethodsCheckbox.setText(Messages.SelectServiceMethodsPage_show_supertype_methods);
        this.showSupertypeMethodsCheckbox.setSelection(this.methodFilter.isShowSuperTypeMethods());
        this.showSupertypeMethodsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectServiceMethodsPage.this.handleMethodSelectionEvent(e);
            }
        });
        this.selectAllButton = new Button(selectButtonComposite, 8);
        this.selectAllButton.setText(Messages.SelectServiceMethodsPage_select_all);
        this.selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectServiceMethodsPage.this.handleMethodSelectionEvent(e);
            }
        });
        this.selectNoneButton = new Button(selectButtonComposite, 8);
        this.selectNoneButton.setText(Messages.SelectServiceMethodsPage_select_none);
        this.selectNoneButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectServiceMethodsPage.this.handleMethodSelectionEvent(e);
            }
        });
    }

    private void createPOJOControls(Composite baseComposite) {
        HashSet<Object> pojoControls = new HashSet<Object>();
        this.pojoRadioButton = new Button(baseComposite, 16);
        this.pojoRadioButton.setText(Messages.SelectServiceMethodsPage_class);
        GridData gData = new GridData(1, 1, false, false);
        this.pojoRadioButton.setLayoutData((Object)gData);
        this.pojoRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectServiceMethodsPage.this.handleRadioButtonSelectionChanged();
            }
        });
        this.radioSectionControls.put(this.pojoRadioButton, pojoControls);
        this.pojoTextField = new Text(baseComposite, 2048);
        gData = new GridData(834);
        this.pojoTextField.setLayoutData((Object)gData);
        pojoControls.add(this.pojoTextField);
        this.pojoTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectServiceMethodsPage.this.handlePojoTextFieldModification();
            }
        });
        this.browsePojoButton = new Button(baseComposite, 8);
        this.browsePojoButton.setText(Messages.SelectServiceMethodsPage_browse);
        this.browsePojoButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectServiceMethodsPage.this.handleBrowsePojoButtonPressed();
            }
        });
        pojoControls.add(this.browsePojoButton);
    }

    private void createServiceNameControls(Composite baseComposite) {
        Label serviceNameLabel = new Label(baseComposite, 0);
        serviceNameLabel.setText(Messages.SelectServiceMethodsPage_service_name);
        this.serviceNameText = new Text(baseComposite, 2048);
        GridData gData = new GridData(768);
        this.serviceNameText.setLayoutData((Object)gData);
        new Label(baseComposite, 0);
        this.serviceNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectServiceMethodsPage.this.handleServiceNameTextFieldModification();
            }
        });
        String name = this.model.getName();
        if (name != null) {
            this.serviceNameText.setText(name);
        }
    }

    private void createWebProjectSelectionControls(Composite baseComposite) {
        Label projectLabel = new Label(baseComposite, 0);
        projectLabel.setText(Messages.SelectServiceMethodsPage_web_project);
        this.webProjectCombo = new Combo(baseComposite, 8);
        GridData gData = new GridData(768);
        this.webProjectCombo.setLayoutData((Object)gData);
        new Label(baseComposite, 0);
        this.webProjectCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = SelectServiceMethodsPage.this.webProjectCombo.getSelectionIndex();
                if (index >= 0) {
                    String projectName = SelectServiceMethodsPage.this.webProjectCombo.getItem(index);
                    IProject project = (IProject)SelectServiceMethodsPage.this.webProjectsMap.get(projectName);
                    SelectServiceMethodsPage.this.model.setProject(project);
                    SelectServiceMethodsPage.this.handleEJBSupportChange();
                    if (SelectServiceMethodsPage.this.model.isEJB()) {
                        SelectServiceMethodsPage.this.refreshEJBTypeField();
                    } else {
                        SelectServiceMethodsPage.this.refreshPojoTypeField();
                    }
                    SelectServiceMethodsPage.this.refreshEJBRefs();
                }
            }
        });
        this.populateWebProjectCombo();
    }

    protected void handleEJBSupportChange() {
        if (this.model.isExistingService()) {
            return;
        }
        if (this.isEJBSupported()) {
            this.ejbRadioButton.setEnabled(true);
        } else {
            this.ejbRadioButton.setSelection(false);
            this.pojoRadioButton.setSelection(true);
            this.ejbRadioButton.setEnabled(false);
        }
        this.handleRadioButtonSelectionChanged();
    }

    public Control getControl() {
        if (this.isCurrentPage() && this.runValidation) {
            this.validateModel();
        }
        return super.getControl();
    }

    public String getDescription() {
        return Messages.SelectServiceMethodsPage_wizard_description;
    }

    public Image getImage() {
        return Activator.getDefault().getImage("full/obj16/expose_service_wizard");
    }

    private Map<IMethod, ServiceMethod> getMethodCache() {
        if (this.methodCache == null) {
            this.methodCache = new HashMap<IMethod, ServiceMethod>();
        }
        return this.methodCache;
    }

    private ServiceMethod getServiceMethod(IMethod method) {
        Map<IMethod, ServiceMethod> methodCache = this.getMethodCache();
        if (methodCache.containsKey(method)) {
            return methodCache.get(method);
        }
        ServiceMethod newServiceMethod = new ServiceMethod(method, this.model);
        methodCache.put(method, newServiceMethod);
        return newServiceMethod;
    }

    public String getTitle() {
        return Messages.SelectServiceMethodsPage_expose_service;
    }

    private void handleBrowseEJBButtonPressed() {
        EJBReferenceWrapper wrapper;
        if (this.model.isExistingService() || !this.isEJBSupported()) {
            return;
        }
        EJBReferenceSelectionDialog d = new EJBReferenceSelectionDialog(this.getShell(), this.webProjectsMap.get(this.webProjectCombo.getItem(this.webProjectCombo.getSelectionIndex())));
        d.open();
        Object[] result = d.getResult();
        if (result.length == 1 && d.getReturnCode() == 0 && (wrapper = (EJBReferenceWrapper)result[0]) != null) {
            this.ejbTextField.setText(wrapper.getInterface());
            this.refreshEJBTypeField();
            if (wrapper.getInterfaceType() == Service.EJBInterfaceType.LOCAL) {
                this.model.setEjbInterfaceType(Service.EJBInterfaceType.LOCAL);
            } else {
                this.model.setEjbInterfaceType(Service.EJBInterfaceType.REMOTE);
            }
            this.model.setEjbHomeInterface(wrapper.getEjbHomeInterface());
            this.model.setEjbJndiName(wrapper.getEjbJNDIName());
        }
        this.refreshEJBRefs();
    }

    private void handleBrowsePojoButtonPressed() {
        int result;
        if (this.model.isExistingService()) {
            return;
        }
        SelectionDialog dialog = null;
        try {
            dialog = JavaUI.createTypeDialog((Shell)this.getShell(), null, (IProject)this.model.getProject(), (int)2, (boolean)false);
            dialog.setTitle(Messages.SelectServiceMethodsPage_window_title);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        if (dialog != null && (result = dialog.open()) == 0) {
            IType selectedType = (IType)dialog.getResult()[0];
            this.pojoTextField.setText(selectedType.getFullyQualifiedName());
            this.refreshTypeControls();
        }
    }

    public void handleCheckStateChangeEvent() {
        Object[] checkedMethods = this.methodCheckboxTableViewer.getCheckedElements();
        ArrayList<ServiceMethod> newMethods = new ArrayList<ServiceMethod>();
        this.model.setMethodList(newMethods);
        Object[] objectArray = checkedMethods;
        int n = checkedMethods.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            IMethod method = (IMethod)item;
            newMethods.add(this.getServiceMethod(method));
            ++n2;
        }
        this.validateModel();
    }

    private void handleEJBSessionBeanTypeChanged() {
        if (this.model.isExistingService() || !this.isEJBSupported()) {
            return;
        }
        String currentState = this.ejbSessionType.getText();
        if (currentState != null && currentState.equals("Stateful")) {
            this.model.setEjbSessionType("Stateful");
        } else {
            this.model.setEjbSessionType("Stateless");
        }
    }

    private void handleEjbTextFieldModification() {
        if (this.model.isExistingService()) {
            return;
        }
        this.refreshEJBTypeField();
        String ejbInterface = this.ejbTextField.getText();
        EJBReferenceWrapper wrapper = this.ejbRefsMap.get(ejbInterface);
        if (wrapper != null) {
            this.model.setEjbHomeInterface(wrapper.getEjbHomeInterface());
            this.model.setEjbJndiName(wrapper.getEjbJNDIName());
        }
    }

    private void handleEJBVersionChange() {
        if (this.model.isExistingService() || !this.isEJBSupported()) {
            return;
        }
        String selectedVersion = this.ejbVersion.getText();
        if (selectedVersion != null && selectedVersion.equals("1.1")) {
            this.model.setEjbInterfaceType(Service.EJBInterfaceType.REMOTE);
        }
        this.model.setEjbVersion(selectedVersion);
    }

    public void handleMethodSelectionEvent(SelectionEvent e) {
        Object source = e.getSource();
        if (source == this.selectAllButton) {
            this.methodCheckboxTableViewer.setAllChecked(true);
            this.handleCheckStateChangeEvent();
        } else if (source == this.selectNoneButton) {
            this.methodCheckboxTableViewer.setAllChecked(false);
            this.handleCheckStateChangeEvent();
        } else if (source == this.showSupertypeMethodsCheckbox) {
            this.methodFilter.setShowSuperTypeMethods(this.showSupertypeMethodsCheckbox.getSelection());
            this.methodCheckboxTableViewer.refresh();
            if (!this.methodFilter.isShowSuperTypeMethods()) {
                for (IMethod currentFilteredMethod : this.methodFilter.getFilteredMethods()) {
                    this.model.getMethodList().remove(this.getServiceMethod(currentFilteredMethod));
                }
            }
            this.validateModel();
        }
    }

    private void handlePojoTextFieldModification() {
        if (this.model.isExistingService()) {
            return;
        }
        this.refreshPojoTypeField();
    }

    private void handleRadioButtonSelectionChanged() {
        if (this.model.isExistingService()) {
            return;
        }
        boolean pojoOn = false;
        boolean ejbOn = false;
        if (this.ejbRadioButton.getSelection()) {
            ejbOn = true;
            this.model.setServiceType(Service.ServiceType.EJB);
            this.refreshEJBTypeField();
        } else if (this.pojoRadioButton.getSelection()) {
            pojoOn = true;
            this.model.setServiceType(Service.ServiceType.POJO);
            this.refreshPojoTypeField();
        }
        for (Control c : this.radioSectionControls.get(this.ejbRadioButton)) {
            c.setEnabled(ejbOn);
        }
        for (Control c : this.radioSectionControls.get(this.pojoRadioButton)) {
            c.setEnabled(pojoOn);
        }
    }

    private void handleServiceNameTextFieldModification() {
        if (this.model.isExistingService()) {
            return;
        }
        String newServiceName = this.serviceNameText.getText();
        this.model.setName(newServiceName);
        if (!this.isWizardInitializing) {
            this.runValidation = true;
        }
        this.validateModel();
    }

    private void initializePageState() {
        if (this.model.isExistingService()) {
            IType implementation = this.model.getImplementation();
            this.webProjectCombo.setEnabled(false);
            this.serviceNameText.setEnabled(false);
            this.webProjectCombo.setText(this.model.getProject().getName());
            this.serviceNameText.setText(this.model.getName());
            this.pojoTextField.setEnabled(false);
            this.browsePojoButton.setEnabled(false);
            if (this.isEJBSupported()) {
                this.ejbTextField.setEnabled(false);
                this.browseEJBRefButton.setEnabled(false);
                this.ejbSessionType.setEnabled(false);
                this.ejbRadioButton.setEnabled(false);
                this.pojoRadioButton.setEnabled(false);
            }
            if (this.model.isPOJO()) {
                if (implementation != null) {
                    if (this.isEJBSupported()) {
                        this.pojoRadioButton.setSelection(true);
                    }
                    this.pojoTextField.setText(implementation.getFullyQualifiedName());
                }
            } else if (this.model.isEJB() && this.isEJBSupported() && implementation != null) {
                this.ejbRadioButton.setSelection(true);
                this.ejbTextField.setText(implementation.getFullyQualifiedName());
                this.ejbSessionType.setText(this.model.getEjbSessionType());
            }
        } else {
            IType type = this.model.getImplementation();
            if (this.model.isPOJO() || !this.isEJBSupported()) {
                if (this.isEJBSupported()) {
                    this.pojoRadioButton.setSelection(true);
                }
                if (type != null) {
                    this.pojoTextField.setText(type.getFullyQualifiedName());
                }
                this.pojoTextField.forceFocus();
            } else if (this.model.isEJB() && this.isEJBSupported()) {
                this.ejbRadioButton.setSelection(true);
                if (type != null) {
                    this.ejbTextField.setText(type.getFullyQualifiedName());
                }
                this.ejbTextField.forceFocus();
            }
            this.handleRadioButtonSelectionChanged();
            if (this.isEJBSupported()) {
                this.model.setEjbSessionType(this.ejbSessionType.getText());
                this.model.setEjbVersion(this.ejbVersion.getText());
            }
        }
    }

    private boolean isEJBSupported() {
        return ServiceUtil.isEJBSupported((IProject)this.model.getProject());
    }

    private void populateWebProjectCombo() {
        this.webProjectsMap = new HashMap<String, IProject>();
        List<IProject> projects = Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects());
        for (IProject project : projects) {
            if (!ProjectFacetsUtil.isDynamicWeb(project)) continue;
            this.webProjectsMap.put(project.getName(), project);
        }
        this.refreshWebProjectsCombo();
    }

    private void refreshEJBTypeField() {
        if (this.isEJBSupported() && !this.isWizardInitializing) {
            String className = this.ejbTextField.getText();
            IType selectedType = JavaUtil.getType((IProject)this.model.getProject(), (String)className);
            this.model.setImplementation(selectedType, true);
            this.methodCheckboxTableViewer.refresh();
            this.refreshServiceName();
            if (!this.isWizardInitializing) {
                this.runValidation = true;
            }
            this.validateModel();
        }
    }

    private void refreshPojoTypeField() {
        if (!this.isWizardInitializing) {
            String className = this.pojoTextField.getText();
            IType selectedType = JavaUtil.getType((IProject)this.model.getProject(), (String)className);
            this.model.setImplementation(selectedType, true);
            this.methodCheckboxTableViewer.refresh();
            this.refreshServiceName();
            if (!this.isWizardInitializing) {
                this.runValidation = true;
            }
            this.validateModel();
        }
    }

    private void refreshServiceName() {
        String name = this.model.getName();
        if (name != null) {
            this.serviceNameText.setText(this.model.getName());
        }
    }

    private void refreshTypeControls() {
        IType selectedType = this.model.getImplementation();
        if (selectedType != null) {
            this.pojoTextField.setText(selectedType.getFullyQualifiedName());
        }
        this.methodCheckboxTableViewer.refresh();
    }

    private void refreshWebProjectsCombo() {
        IProject currentProject = this.model.getProject();
        this.webProjectCombo.removeAll();
        ArrayList<String> projectNames = new ArrayList<String>(this.webProjectsMap.keySet());
        int i = 0;
        while (i < projectNames.size()) {
            String projectName = (String)projectNames.get(i);
            this.webProjectCombo.add(projectName);
            if (currentProject != null && projectName.equals(currentProject.getName())) {
                this.webProjectCombo.select(i);
            }
            ++i;
        }
        if (this.webProjectCombo.getItemCount() > 0 && this.webProjectCombo.getSelectionIndex() < 0) {
            this.webProjectCombo.select(0);
            this.model.setProject(this.webProjectsMap.get(this.webProjectCombo.getItem(0)));
        }
    }

    private void validateModel() {
        if (this.webProjectsMap.isEmpty()) {
            this.setMessage(Messages.SelectServiceMethodsPage_no_web_projects, 1);
            this.setPageComplete(false);
        } else if (this.runValidation) {
            IStatus newStatus = this.model.validate();
            if (newStatus.getCode() <= 3) {
                if (newStatus.isOK()) {
                    this.setErrorMessage(null);
                    this.setMessage(null);
                    this.setPageComplete(true);
                } else if (newStatus.getSeverity() == 4) {
                    this.setErrorMessage(newStatus.getMessage());
                    this.setPageComplete(false);
                } else if (this.methodCheckboxTableViewer.getTable().getItemCount() == 0) {
                    this.setErrorMessage(null);
                    this.setMessage(Messages.SelectServiceMethodsPage_toggle_show_supertypes_box, 1);
                    this.setPageComplete(false);
                } else {
                    this.setErrorMessage(null);
                    this.setMessage(newStatus.getMessage(), newStatus.getSeverity());
                    this.setPageComplete(false);
                }
            } else {
                this.setErrorMessage(null);
                this.setMessage(null);
                this.setPageComplete(true);
            }
            boolean isWizardComplete = newStatus.isOK();
            ((ConfigureMethodsPage)this.getNextPage()).setPageComplete(isWizardComplete);
            this.getContainer().updateButtons();
        }
    }

    private String[] getEJBRefProposals() {
        ArrayList<String> proposals = new ArrayList<String>();
        Set<String> ejbRefs = this.ejbRefsMap.keySet();
        for (String interfaceName : ejbRefs) {
            proposals.add(interfaceName);
        }
        return proposals.toArray(new String[proposals.size()]);
    }
}

