/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.rpcadapter.ui.internal.wizard.dialog;

import com.ibm.etools.common.ui.wizards.EJB3ReferenceWizard;
import com.ibm.etools.common.ui.wizards.GenericCommandWizard;
import com.ibm.etools.common.ui.wizards.nls.CommonAppEJBWizardsResourceHandler;
import com.ibm.etools.j2ee.reference.EJB3ReferenceDataModel;
import com.ibm.etools.web.ui.wizards.WebWizardHelper;
import com.ibm.etools.webtools.rpcadapter.core.Activator;
import com.ibm.etools.webtools.rpcadapter.core.internal.util.EJBRefUtil;
import com.ibm.etools.webtools.rpcadapter.core.internal.util.EJBReferenceWrapper;
import com.ibm.etools.webtools.rpcadapter.ui.internal.nls.Messages;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jst.j2ee.common.internal.provider.CommonItemProviderAdapterFactory;
import org.eclipse.jst.j2ee.internal.ejb.provider.EjbItemProviderAdapterFactory;
import org.eclipse.jst.j2ee.internal.provider.J2EEUIEditingDomain;
import org.eclipse.jst.j2ee.internal.web.providers.WebapplicationItemProviderAdapterFactory;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class EJBReferenceSelectionDialog
extends SelectionDialog {
    private Table ejbTable;
    private IProject webProject;
    private EJBReferenceWrapper dialogResult;

    public EJBReferenceSelectionDialog(Shell parentShell, IProject webProject) {
        super(parentShell);
        this.webProject = webProject;
        this.setTitle(Messages.EJBReferenceSelectionDialog_Title);
        EJBReferenceSelectionDialog.setDialogHelpAvailable((boolean)true);
    }

    protected Control createDialogArea(Composite parent) {
        Control baseControl = super.createDialogArea(parent);
        this.setBlockOnOpen(true);
        this.createEJBReferenceTable((Composite)baseControl);
        return baseControl;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getOkButton().setEnabled(false);
    }

    public Object[] getResult() {
        return new EJBReferenceWrapper[]{this.dialogResult};
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        this.setTitle(Messages.EJBReferenceSelectionDialog_Title);
        EJBReferenceSelectionDialog.setDialogHelpAvailable((boolean)false);
    }

    private void createEJBReferenceTable(Composite ejbComposite) {
        this.ejbTable = new Table(ejbComposite, 67588);
        TableLayout tlayout = new TableLayout();
        TableColumn col1 = new TableColumn(this.ejbTable, 16384);
        col1.setText(Messages.EJBReferenceSelectionDialog_ReferenceColumnHeader);
        col1.setWidth(100);
        TableColumn col2 = new TableColumn(this.ejbTable, 16384);
        col2.setText(Messages.EJBReferenceSelectionDialog_InterfaceColumnHeader);
        col2.setWidth(400);
        ColumnWeightData clayout = new ColumnWeightData(1, 100, true);
        tlayout.addColumnData((ColumnLayoutData)clayout);
        clayout = new ColumnWeightData(3, 300, true);
        tlayout.addColumnData((ColumnLayoutData)clayout);
        this.ejbTable.setHeaderVisible(true);
        this.ejbTable.setLayout((Layout)tlayout);
        GridData gData = new GridData(64, 32, true, true);
        gData.minimumWidth = 500;
        gData.minimumHeight = 200;
        this.ejbTable.setLayoutData((Object)gData);
        this.ejbTable.addControlListener((ControlListener)new EJBTableResizeListener());
        this.ejbTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EJBReferenceSelectionDialog.this.handleReferenceSelectionChanged(e);
            }
        });
        Button addEJBReference = new Button(ejbComposite, 8);
        addEJBReference.setText(Messages.EJBReferenceSelectionDialog_AddReferenceButton);
        addEJBReference.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EJBReferenceSelectionDialog.this.handleAddEJBReference();
            }
        });
        this.refreshEJBRefTable();
    }

    private void handleReferenceSelectionChanged(SelectionEvent e) {
        int selectedRow = this.ejbTable.getSelectionIndex();
        TableItem selected = this.ejbTable.getItem(selectedRow);
        Object data = selected.getData();
        if (data instanceof EJBReferenceWrapper) {
            this.dialogResult = (EJBReferenceWrapper)data;
        }
        this.getOkButton().setEnabled(this.dialogResult != null);
    }

    private void refreshEJBRefTable() {
        this.ejbTable.removeAll();
        List refs = EJBRefUtil.getEJBRefs((IProject)this.webProject);
        Collections.sort(refs);
        for (EJBReferenceWrapper wrapper : refs) {
            TableItem tableItem = new TableItem(this.ejbTable, 0);
            tableItem.setData((Object)wrapper);
            tableItem.setText(0, wrapper.getEjbJNDIName());
            tableItem.setText(1, wrapper.getInterface());
        }
    }

    private AdapterFactory getAdapterFactory() {
        ComposedAdapterFactory combinedAdapterFactory;
        ComposedAdapterFactory fAdapterFactory = null;
        EjbItemProviderAdapterFactory ejbFactory = new EjbItemProviderAdapterFactory();
        WebapplicationItemProviderAdapterFactory webFactory = new WebapplicationItemProviderAdapterFactory();
        CommonItemProviderAdapterFactory commonFactory = new CommonItemProviderAdapterFactory();
        fAdapterFactory = combinedAdapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{ejbFactory, webFactory, commonFactory});
        return fAdapterFactory;
    }

    private void handleAddEJBReference() {
        block16: {
            Object webAppObj = EJBRefUtil.getWebApp((IProject)this.webProject);
            if (webAppObj != null) {
                if (webAppObj instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
                    WebArtifactEdit artifactEdit = WebArtifactEdit.getWebArtifactEditForWrite((IProject)this.webProject);
                    try {
                        try {
                            J2EEUIEditingDomain domain = new J2EEUIEditingDomain(this.getAdapterFactory(), artifactEdit.getCommandStack());
                            GenericCommandWizard wizard = (GenericCommandWizard)WebWizardHelper.createReferencesWizard((EditingDomain)domain, (ArtifactEdit)artifactEdit);
                            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
                            dialog.create();
                            dialog.setTitle(CommonAppEJBWizardsResourceHandler.Add_EJB_Reference_UI_);
                            IWizardPage page = dialog.getCurrentPage();
                            if (page != null && (page = page.getNextPage()) != null) {
                                dialog.showPage(page);
                                page.setPreviousPage(null);
                                dialog.updateButtons();
                            }
                            dialog.open();
                            artifactEdit.save(null);
                        }
                        catch (Exception e) {
                            Activator.getDefault().write((Object)e.getMessage());
                            if (artifactEdit != null) {
                                artifactEdit.dispose();
                            }
                            break block16;
                        }
                    }
                    catch (Throwable throwable) {
                        if (artifactEdit != null) {
                            artifactEdit.dispose();
                        }
                        throw throwable;
                    }
                    if (artifactEdit != null) {
                        artifactEdit.dispose();
                    }
                } else if (webAppObj instanceof WebApp) {
                    IJavaProject jp = JavaCore.create((IProject)this.webProject);
                    IRegion region = JavaCore.newRegion();
                    region.add((IJavaElement)jp);
                    try {
                        boolean exists;
                        IType stateless = jp.findType("javax.ejb.Stateless");
                        if (stateless != null && (exists = stateless.exists())) {
                            EJB3ReferenceDataModel dataModel = new EJB3ReferenceDataModel();
                            dataModel.setProperty("ReferenceDataModel.OWNER", (Object)((WebApp)webAppObj));
                            IVirtualComponent ownerComponent = ComponentCore.createComponent((IProject)this.webProject);
                            dataModel.setProperty("EJBReferenceDataModel.TARGET_COMPONENT", (Object)ownerComponent);
                            dataModel.setProperty("ArtifactEditOperationDataModel.PROJECT_NAME", (Object)this.webProject.getName());
                            EJB3ReferenceWizard wiz = new EJB3ReferenceWizard(dataModel);
                            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wiz);
                            dialog.create();
                            dialog.open();
                        }
                    }
                    catch (JavaModelException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.refreshEJBRefTable();
    }

    private class EJBTableResizeListener
    extends ControlAdapter {
        protected int fX = -1;
        protected int fY = -1;
        protected Runnable fResizer = new Runnable(){

            @Override
            public void run() {
                if (EJBReferenceSelectionDialog.this.ejbTable != null && !EJBReferenceSelectionDialog.this.ejbTable.isDisposed()) {
                    Point size = EJBReferenceSelectionDialog.this.ejbTable.getSize();
                    if (size.x != EJBTableResizeListener.this.fX && size.x > 6 || size.y != EJBTableResizeListener.this.fY && size.y > 6) {
                        EJBTableResizeListener.this.fX = size.x;
                        EJBTableResizeListener.this.fY = size.y;
                        TableColumn column = EJBReferenceSelectionDialog.this.ejbTable.getColumn(0);
                        if (column != null && !column.isDisposed()) {
                            column.setWidth(size.x * 38 / 100);
                        }
                        if ((column = EJBReferenceSelectionDialog.this.ejbTable.getColumn(1)) != null && !column.isDisposed()) {
                            ScrollBar vBar = EJBReferenceSelectionDialog.this.ejbTable.getVerticalBar();
                            int scrollWidth = vBar.getMaximum() == vBar.getThumb() ? 0 : vBar.getSize().x + 2;
                            column.setWidth(size.x * 62 / 100 - scrollWidth - 4);
                        }
                    }
                }
            }
        };

        private EJBTableResizeListener() {
        }

        public void controlResized(ControlEvent e) {
            Display.getDefault().asyncExec(this.fResizer);
        }
    }
}

