/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.rpcadapter.ui.internal.finder;

import com.ibm.ccl.ws.finder.core.FinderCore;
import com.ibm.ccl.ws.finder.core.IWebServiceRegistry;
import com.ibm.ccl.ws.finder.core.IWebServiceRegistryCallback;
import com.ibm.ccl.ws.finder.core.WSInfo;
import com.ibm.ccl.ws.finder.core.observer.IResourceChangeObserver;
import com.ibm.etools.webtools.rpcadapter.core.IServiceCollectorListener;
import com.ibm.etools.webtools.rpcadapter.core.ServiceCollector;
import com.ibm.etools.webtools.rpcadapter.core.ServiceCollectorEvent;
import com.ibm.etools.webtools.rpcadapter.core.model.Service;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;

public class ServiceFinder
implements IResourceChangeObserver,
IServiceCollectorListener {
    private IWebServiceRegistryCallback callback;
    private boolean listeningToServiceCollector = false;

    public void resourceChanged(IResource arg0, int arg1) {
        if (!this.listeningToServiceCollector) {
            this.reloadServices(arg0.getProject());
            ServiceCollector.getInstance().addServiceCollectorListener((IServiceCollectorListener)this);
            this.listeningToServiceCollector = true;
        }
        ServiceCollector.getInstance().refreshServices(arg0.getProject());
        this.reloadServices(arg0.getProject());
    }

    private void reloadServices(IProject proj) {
        this.clearExistingServices(proj);
        this.addServicesFromCollector(proj);
    }

    private void addServicesFromCollector(IProject proj) {
        List services = ServiceCollector.getInstance().getServices(proj);
        for (Service service : services) {
            HashMap<String, String> propertyMap = new HashMap<String, String>();
            propertyMap.put("rpcadapter.finder.prop.service.name", service.getName());
            propertyMap.put("_wsinfo_label_", String.valueOf(service.getName()) + " (" + service.getImplementation().getFullyQualifiedName() + ")");
            WSInfo newInfo = new WSInfo("rpcadapter.service", this.getClass().getName(), String.valueOf(proj.getName()) + "." + service.getName(), proj, propertyMap, (Object)service);
            this.callback.add(newInfo);
        }
    }

    private void clearExistingServices(IProject proj) {
        IWebServiceRegistry registry = FinderCore.getWebServiceRegistry();
        List rpcAdapterServices = registry.getWebServices("rpcadapter.service");
        for (WSInfo service : rpcAdapterServices) {
            if (!service.getProject().equals((Object)proj)) continue;
            this.callback.remove(service);
        }
    }

    public void beginSave() {
    }

    public void endSave() {
    }

    public boolean exists(WSInfo arg0, boolean arg1) {
        return true;
    }

    public void fillProperties(Object serviceObject, Map<String, String> properties) {
        properties.put("_wsinfo_icon_plugin_id_", "com.ibm.etools.webtools.rpcadapter.ui");
        if (serviceObject instanceof Service) {
            Service service = (Service)serviceObject;
            if (service.isPOJO()) {
                properties.put("_wsinfo_icon_", "icons/full/obj16/service.gif");
                properties.put("_wsinfo_icon_started_", "icons/full/obj16/service.gif");
            } else if (service.isEJB()) {
                properties.put("_wsinfo_icon_", "icons/full/obj16/ejb_service.gif");
                properties.put("_wsinfo_icon_started_", "icons/full/obj16/ejb_service.gif");
            }
        }
    }

    public Object getWebServiceObject(WSInfo info, IProgressMonitor monitor) {
        IProject project = info.getProject();
        String serviceName = info.getProperty("rpcadapter.finder.prop.service.name");
        if (project != null) {
            Service service = ServiceCollector.getInstance().getService(project, serviceName);
            return service;
        }
        return null;
    }

    public void setCallback(IWebServiceRegistryCallback callback) {
        this.callback = callback;
    }

    public void serviceChanged(ServiceCollectorEvent event) {
        this.reloadServices(event.getProject());
    }
}

