/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.rpcadapter.ui.internal;

import com.ibm.etools.webtools.rpcadapter.ui.internal.nls.Messages;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.internal.facets.FacetUtil;

public class ProjectFacetsUtil {
    public static boolean projectHasFacet(IProject project, String facetID, String facetVersion) throws CoreException {
        IProjectFacet requiredFacet;
        IFacetedProject facetedProject;
        boolean hasFacet = false;
        if (ProjectFacetsManager.isProjectFacetDefined((String)facetID) && (facetedProject = ProjectFacetsManager.create((IProject)project)) != null && (requiredFacet = ProjectFacetsManager.getProjectFacet((String)facetID)) != null) {
            if (facetVersion != null) {
                IProjectFacetVersion requiredFacetVersion = requiredFacet.getVersion(facetVersion);
                if (requiredFacetVersion != null) {
                    hasFacet = facetedProject.hasProjectFacet(requiredFacetVersion);
                }
            } else {
                hasFacet = facetedProject.hasProjectFacet(requiredFacet);
            }
        }
        return hasFacet;
    }

    public static boolean projectHasRuntime(IProject project, String runtimeID) throws CoreException {
        boolean hasRuntime = false;
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime requiredRuntime = RuntimeManager.getRuntime((String)runtimeID);
        if (requiredRuntime != null) {
            org.eclipse.wst.common.project.facet.core.runtime.IRuntime actualRuntime = facetedProject.getPrimaryRuntime();
            hasRuntime = requiredRuntime.equals(actualRuntime);
        }
        return hasRuntime;
    }

    public static boolean isWebProject(IProject project) {
        boolean isWebProject = false;
        boolean isStaticWeb = false;
        boolean isDynamicWeb = false;
        isStaticWeb = ProjectFacetsUtil.isStaticWeb(project);
        isDynamicWeb = ProjectFacetsUtil.isDynamicWeb(project);
        isWebProject = isStaticWeb || isDynamicWeb;
        return isWebProject;
    }

    public static boolean isStaticWeb(IProject project) {
        boolean isStaticWeb = false;
        try {
            isStaticWeb = ProjectFacetsUtil.projectHasFacet(project, "wst.web", null);
        }
        catch (CoreException coreException) {}
        return isStaticWeb;
    }

    public static boolean isDynamicWeb(IProject project) {
        boolean isDynamicWeb = false;
        try {
            isDynamicWeb = ProjectFacetsUtil.projectHasFacet(project, "jst.web", null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return isDynamicWeb;
    }

    public static boolean isWithinWebRoot(IContainer container) {
        IProject project;
        boolean isWebContainer = false;
        if (container != null && container.isAccessible() && ProjectFacetsUtil.isWebProject(project = container.getProject())) {
            IPath selectedPath = container.getFullPath();
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            IPath webContainerPath = component.getRootFolder().getWorkspaceRelativePath();
            isWebContainer = webContainerPath.isPrefixOf(selectedPath);
        }
        return isWebContainer;
    }

    public static IPath getRootRelativePath(IPath file, IProject project) {
        Path relativePath = new Path(file.toString());
        if (ProjectFacetsUtil.isWebProject(project)) {
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            IPath rootPath = component.getRootFolder().getWorkspaceRelativePath();
            relativePath = file.removeFirstSegments(file.matchingFirstSegments(rootPath));
        }
        return relativePath.makeAbsolute();
    }

    public static IPath getContextRelativePath(IPath file, IProject project) {
        IPath relativePath = ProjectFacetsUtil.getRootRelativePath(file, project);
        WebArtifactEdit readOnlyEditModel = WebArtifactEdit.getWebArtifactEditForRead((IProject)project);
        if (readOnlyEditModel != null) {
            String context = readOnlyEditModel.getServerContextRoot();
            Path contextPath = new Path(context);
            relativePath = contextPath.append(relativePath);
            relativePath = relativePath.makeAbsolute();
            readOnlyEditModel.dispose();
        }
        return relativePath;
    }

    public static void installWeb2FeaturePackFacet(IProject project) {
        ProjectFacetsUtil.installFacet(project, "web2featurepack", ProjectFacetsUtil.determineFacetVersion(project), (IProgressMonitor)new NullProgressMonitor());
    }

    private static boolean installFacet(IProject project, String facetName, String version, IProgressMonitor monitor) {
        boolean isDefined = ProjectFacetsManager.isProjectFacetDefined((String)facetName);
        if (isDefined) {
            try {
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project, (boolean)true, (IProgressMonitor)monitor);
                IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)facetName);
                if (facetedProject == null || facet == null) {
                    isDefined = false;
                } else {
                    isDefined = facet.hasVersion(version);
                    IProjectFacetVersion javafacetversion = facet.getVersion(version);
                    HashSet<IFacetedProject.Action> actions = new HashSet<IFacetedProject.Action>();
                    actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, javafacetversion, null));
                    facetedProject.modify(actions, monitor);
                }
            }
            catch (CoreException e) {
                Display display = Display.getCurrent();
                if (display == null) {
                    display = Display.getDefault();
                }
                MessageDialog.openError((Shell)display.getActiveShell(), (String)Messages.ProjectFacetsUtil_facet_error, (String)Messages.ProjectsFacetUtil_facet_error_desc);
                e.printStackTrace();
                isDefined = false;
            }
        }
        return isDefined;
    }

    private static String determineFacetVersion(IProject project) {
        IRuntime wasRuntime;
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime targetedRuntime;
        String featurePackVersion = "1.0.0.1";
        String facetVersion = "1.0.0.1";
        IFacetedProject facetedProject = null;
        try {
            facetedProject = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
        if (facetedProject != null && (targetedRuntime = facetedProject.getPrimaryRuntime()) != null && (wasRuntime = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)targetedRuntime)) != null) {
            featurePackVersion = com.ibm.etools.webtools.rpcadapter.core.internal.util.FacetUtil.determineVersionOfFeaturePackFromRuntime((IRuntime)wasRuntime);
        }
        facetVersion = featurePackVersion.equals("1.0.0.0") ? "1.0" : "1.0.0.1";
        return facetVersion;
    }
}

