/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.util;

import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedataview.PageDataViewPlugin;
import com.ibm.etools.webtools.pagedataview.ui.nls.ResourceHandler;
import com.ibm.etools.webtools.pagedataview.util.CommonXML;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PersistenceManager {
    public static final String PERSISTENCE_FILE_NAME = ".jspPersistence";
    private static final String PERSISTENCE_ELEMENT_NAME = "persistence";
    protected static final String JSP_SCRIPTING_ELEMENT_NAME = "jsp-scripting";
    protected static final String REQUEST_ELEMENT_NAME = "request";
    protected static final String SESSION_ELEMENT_NAME = "session";
    protected static final String PARAM_ELEMENT_NAME = "param";
    protected static final String APPLICATION_ELEMENT_NAME = "application";
    protected static final String VARIABLE_ELEMENT_NAME = "variable";
    public static final String ID_ATTRIBUTE_NAME = "id";
    public static final String NAME_ATTRIBUTE_NAME = "name";
    public static final String TYPE_ATTRIBUTE_NAME = "type";
    protected static final String BEAN_CATEGORY_ELEMENT_NAME = "beanData";
    protected static final String BEAN_ELEMENT_NAME = "bean";
    protected static final String COLLECTION_PROPERTY_ELEMENT_NAME = "collectionProperty";
    protected static final String CONTAINS_ELEMENT_NAME = "contains";
    public static final int PERSIST_ADD = 1;
    public static final int PERSIST_REMOVE = 2;
    public static final int PERSIST_GET_CONTAINED_TYPE = 3;
    public static final int PERSIST_CHANGE = 4;
    private List toNotify;
    protected static PersistenceManager fPersistenceManager = null;

    public PersistenceManager() {
        this.toNotify = new ArrayList();
    }

    public PersistenceManager(List toNotifyList) {
        if (toNotifyList != null) {
            this.toNotify = toNotifyList;
        }
    }

    public static PersistenceManager getInstance() {
        if (fPersistenceManager == null) {
            fPersistenceManager = new PersistenceManager();
        }
        return fPersistenceManager;
    }

    public static Document getPersistenceDocument(IProject project, boolean createOnDemand) {
        IFile file = project.getFile(PERSISTENCE_FILE_NAME);
        if (!file.exists()) {
            if (createOnDemand) {
                PersistenceManager.createPersistenceFile(file);
            } else {
                return null;
            }
        }
        Document document = null;
        try {
            DocumentBuilder builder = CommonXML.getDocumentBuilder();
            if (builder != null) {
                FileInputStream fis = new FileInputStream(file.getRawLocation().toFile());
                document = builder.parse(new InputSource(fis));
            } else {
                PageDataViewPlugin.getDefault().write("Couldn't obtain a DocumentBuilder");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            document = null;
        }
        catch (IOException e) {
            PageDataViewPlugin.getDefault().write("Could not load document");
            PageDataViewPlugin.getDefault().write(e);
        }
        catch (SAXException e) {
            PageDataViewPlugin.getDefault().write("Could not load document");
            PageDataViewPlugin.getDefault().write(e);
        }
        return document;
    }

    public static void createPersistenceFile(IFile file) {
        StringBuffer inital_contents = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        inital_contents = inital_contents.append("<").append(PERSISTENCE_ELEMENT_NAME).append(">\n");
        inital_contents = inital_contents.append("<").append(JSP_SCRIPTING_ELEMENT_NAME).append("/>\n");
        inital_contents = inital_contents.append("<").append(BEAN_CATEGORY_ELEMENT_NAME).append("/>\n");
        inital_contents = inital_contents.append("</").append(PERSISTENCE_ELEMENT_NAME).append(">");
        try {
            file.create((InputStream)new ByteArrayInputStream(inital_contents.toString().getBytes()), false, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    /*
     * Exception decompiling
     */
    public static void writePersistenceDocument(IProject project, Document document) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected static Element getRootElement(Document doc) {
        NodeList roots = doc.getElementsByTagName(PERSISTENCE_ELEMENT_NAME);
        Element root = (Element)roots.item(0);
        return root;
    }

    protected static Element getElement(Document doc, String parentElement, String elementName) throws DOMException {
        Element element = null;
        if (doc != null) {
            NodeList nodes;
            Element root = PersistenceManager.getRootElement(doc);
            if (parentElement != null) {
                nodes = root.getElementsByTagName(parentElement);
                root = (Element)nodes.item(0);
            }
            if (root != null && (element = (Element)(nodes = root.getElementsByTagName(elementName)).item(0)) == null) {
                element = doc.createElement(elementName);
                root.appendChild(element);
            }
        }
        return element;
    }

    protected static List getVariables(Element parentElement, String elementName) {
        ArrayList<Element> list = new ArrayList<Element>();
        NodeList nodes = parentElement.getElementsByTagName(elementName);
        int i = 0;
        while (i < nodes.getLength()) {
            Element newVariableElement = (Element)nodes.item(i);
            list.add(newVariableElement);
            ++i;
        }
        return list;
    }

    protected static Element findChildElement(Element parentElement, String childElementName, String attributeName, String attributeValue) {
        NodeList nodes = parentElement.getElementsByTagName(childElementName);
        Element ret = null;
        int i = 0;
        while (i < nodes.getLength()) {
            if (((Element)nodes.item(i)).getAttribute(attributeName).equals(attributeValue)) {
                ret = (Element)nodes.item(i);
                break;
            }
            ++i;
        }
        return ret;
    }

    public List getToNotify() {
        return this.toNotify;
    }

    public String processPersistenceInfo(IPageDataNode cPdn, String param1, int action) {
        return null;
    }

    public static void addContainsNodesToPropertyElement(Element propertyElement, String containsType) {
        if (propertyElement != null && containsType != null) {
            Document doc = propertyElement.getOwnerDocument();
            Element containsElement = doc.createElement(CONTAINS_ELEMENT_NAME);
            containsElement.setAttribute(TYPE_ATTRIBUTE_NAME, containsType);
            Element deepestElement = propertyElement;
            NodeList children = deepestElement.getElementsByTagName(CONTAINS_ELEMENT_NAME);
            while (children != null && children.getLength() > 0) {
                deepestElement = (Element)children.item(0);
                children = deepestElement.getElementsByTagName(CONTAINS_ELEMENT_NAME);
            }
            deepestElement.appendChild(containsElement);
        }
    }

    public static Element getContainsElement(Element collectionPropertyElement, int index) {
        if (collectionPropertyElement != null) {
            Element indexedElement = collectionPropertyElement;
            while (index > 0) {
                if (indexedElement.hasChildNodes()) {
                    Element child;
                    indexedElement = child = (Element)indexedElement.getElementsByTagName(CONTAINS_ELEMENT_NAME).item(0);
                    --index;
                    continue;
                }
                return null;
            }
            return indexedElement;
        }
        return null;
    }

    protected String getContainedType(Element parentElem, String propertyName, int depth) {
        Element collectionProperty;
        Element containsElement;
        String ret = null;
        if (parentElem != null && (containsElement = PersistenceManager.getContainsElement(collectionProperty = PersistenceManager.findChildElement(parentElem, COLLECTION_PROPERTY_ELEMENT_NAME, NAME_ATTRIBUTE_NAME, propertyName), depth)) != null) {
            ret = containsElement.getAttribute(TYPE_ATTRIBUTE_NAME);
        }
        return ret;
    }

    protected static void removeNodeContainedType(IProject project, Element parentElem, String propertyName, int depth) {
        Element containsElement;
        Element collectionProperty;
        if (parentElem != null && (collectionProperty = PersistenceManager.findChildElement(parentElem, COLLECTION_PROPERTY_ELEMENT_NAME, NAME_ATTRIBUTE_NAME, propertyName)) != null && (containsElement = PersistenceManager.getContainsElement(collectionProperty, depth)) != null) {
            containsElement.getParentNode().removeChild(containsElement);
            PersistenceManager.writePersistenceDocument(project, collectionProperty.getOwnerDocument());
        }
    }

    public static boolean validateEditOfPersistenceFile(IProject project, Shell shell) {
        IFile workbenchFile = project.getFile(PERSISTENCE_FILE_NAME);
        IStatus validateEditStatus = PageDataViewPlugin.getWorkspace().validateEdit(new IFile[]{workbenchFile}, (Object)shell);
        if (validateEditStatus.matches(4) && validateEditStatus.getSeverity() != 8) {
            final String errorMessage = String.valueOf(ResourceHandler.Failed_Validate_Edit) + " - " + PERSISTENCE_FILE_NAME;
            if (shell != null) {
                final Shell nestedShell = shell;
                shell.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)nestedShell, (String)ResourceHandler.Error, (String)errorMessage);
                    }
                });
            }
        }
        return validateEditStatus.isOK();
    }
}

