/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.util;

import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.common.utils.ActionUtil;
import com.ibm.etools.webedit.editor.HTMLEditor;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.IBindingAttribute;
import com.ibm.etools.webtools.pagedatamodel.sse.api.ISSEPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.util.PageDataModelUtil;
import com.ibm.etools.webtools.pagedataview.PageDataViewPlugin;
import com.ibm.etools.webtools.pagedataview.PageDataViewRegistryReader;
import com.ibm.etools.webtools.pagedataview.nls.ResourceHandler;
import com.ibm.etools.webtools.pagedataview.ui.ConfigureDialogFactory;
import com.ibm.etools.webtools.pagedataview.ui.HTMLEditDomainNotFoundException;
import com.ibm.etools.webtools.pagedataview.ui.IPageDataViewPage;
import com.ibm.etools.webtools.pagedataview.ui.internal.SingleObjectStructuredSelection;
import com.ibm.etools.webtools.server.internal.JsfPageUtil;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;

public class ModelUtil {
    public static final String PAGETYPE_JSP = "JSP";
    public static final String PAGETYPE_JSF = "JSF";

    public static int configurePageData(IPageDataNode nodeSelected) {
        List factories;
        String pageType = PAGETYPE_JSP;
        IDOMNode domNode = null;
        if (nodeSelected instanceof ISSEPageDataNode) {
            domNode = ((ISSEPageDataNode)nodeSelected).getDOMNode();
        }
        Document doc = null;
        if (domNode != null) {
            doc = domNode.getNodeType() == 9 ? (Document)domNode : domNode.getOwnerDocument();
        }
        if (domNode != null && JsfPageUtil.isJsfPage(doc)) {
            pageType = PAGETYPE_JSF;
        }
        if ((factories = PageDataViewRegistryReader.getConfigureDialogFactoryFor(nodeSelected, pageType)) != null) {
            ConfigureDialogFactory factory = null;
            int i = 0;
            while (i < factories.size()) {
                if (((ConfigureDialogFactory)factories.get(i)).isFactoryFor(nodeSelected)) {
                    factory = (ConfigureDialogFactory)factories.get(i);
                    break;
                }
                ++i;
            }
            if (factory != null) {
                Dialog dialog = factory.createConfigureDialog(PageDataViewPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), nodeSelected);
                return dialog.open();
            }
        }
        return -1;
    }

    public static void findAndSelectNodeByName(String pageDataNodeName) {
        try {
            IPageDataNode target = ModelUtil.findByName(pageDataNodeName);
            IEditorPart editor = ActionUtil.getActiveEditorPart();
            if (editor instanceof HTMLEditor) {
                IPageDataViewPage page = (IPageDataViewPage)editor.getAdapter(IPageDataViewPage.class);
                page.setSelection((ISelection)new SingleObjectStructuredSelection(target));
            }
        }
        catch (HTMLEditDomainNotFoundException hTMLEditDomainNotFoundException) {}
    }

    public static IPageDataNode findByName(String pageDataNodeName) throws HTMLEditDomainNotFoundException {
        HTMLEditDomain edit = ActionUtil.getActiveHTMLEditDomain();
        if (edit == null) {
            throw new HTMLEditDomainNotFoundException(ResourceHandler._EXC_NoHTMLEditDM);
        }
        IDOMModel model = edit.getActiveModel();
        IPageDataModel pdModel = PageDataModelUtil.getPageDataModel((IDOMNode)model.getDocument());
        EList components = pdModel.getRoot().getChildren();
        int i = 0;
        while (components != null && i < components.size()) {
            IPageDataNode one = (IPageDataNode)components.get(i);
            IBindingAttribute binding = (IBindingAttribute)one.getAdapter(IBindingAttribute.ADAPTER_KEY);
            if (binding != null && pageDataNodeName.equals(binding.getName(one))) {
                return one;
            }
            ++i;
        }
        return null;
    }

    public static IVirtualComponent getComponent(IProject project, IDOMNode node) {
        return ComponentUtilities.findComponent((IResource)PageDataModelUtil.getOwningResource((IDOMNode)node));
    }
}

