/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.util;

import com.ibm.etools.webedit.common.commands.EditRangeCommand;
import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webedit.common.commands.factories.NodeFactory;
import java.util.ArrayList;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ranges.DocumentRange;
import org.w3c.dom.ranges.Range;

public class InsertAsSiblingCommand
extends EditRangeCommand {
    public static final short PREVIOUS_SIBLING = 1;
    public static final short NEXT_SIBLING = 2;
    private NodeFactory factory;
    private Node targetNode;
    private boolean resetFocus = false;
    private short type;

    public InsertAsSiblingCommand(NodeFactory factory, short siblingType) {
        super("tag insert");
        this.factory = factory;
        this.type = siblingType;
    }

    public InsertAsSiblingCommand(NodeFactory factory, Node targetNode, short siblingType) {
        super("tag insert");
        this.factory = factory;
        this.targetNode = targetNode;
        this.type = siblingType;
    }

    public InsertAsSiblingCommand(NodeFactory factory, Node targetNode, short siblingType, boolean resetFocus) {
        super("tag insert");
        this.factory = factory;
        this.targetNode = targetNode;
        this.type = siblingType;
        this.resetFocus = resetFocus;
    }

    protected void doExecute() {
        Range textTargetRange;
        Document document;
        Node newNode;
        if (this.targetNode == null) {
            Range range = this.getRange();
            if (range != null) {
                this.targetNode = range.getEndContainer();
            }
            if (this.targetNode == null) {
                return;
            }
        }
        if ((newNode = this.factory.createNode(document = this.getDocument(), textTargetRange = ((DocumentRange)((Object)document)).createRange())) == null) {
            return;
        }
        if (this.type == 1) {
            this.targetNode.getParentNode().insertBefore(newNode, this.targetNode);
        } else if (this.type == 2) {
            this.targetNode.getParentNode().insertBefore(newNode, this.targetNode.getNextSibling());
        }
        this.cleanupNodeAttributes(newNode);
        if (!this.resetFocus) {
            Range newRange = ((DocumentRange)((Object)document)).createRange();
            newRange.setStart(newNode, 0);
            newRange.setEnd(newNode, 0);
            this.setRange(newRange);
        }
    }

    public HTMLCommand.Condition getFreeLayoutSupport() {
        return FLM_ADD_CELL;
    }

    public void cleanupNodeAttributes(Node node) {
        Element newEl = (Element)node;
        NamedNodeMap attrsMap = newEl.getAttributes();
        ArrayList<Node> attrsList = new ArrayList<Node>();
        int i = 0;
        while (i < attrsMap.getLength()) {
            attrsList.add(attrsMap.item(i));
            ++i;
        }
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)node.getOwnerDocument());
        if (modelQuery == null) {
            return;
        }
        CMElementDeclaration decl = modelQuery.getCMElementDeclaration(newEl);
        if (decl == null) {
            return;
        }
        CMNamedNodeMap declAttrs = decl.getAttributes();
        if (declAttrs == null) {
            return;
        }
        int i2 = 0;
        while (i2 < attrsList.size()) {
            String attrName = ((Node)attrsList.get(i2)).getNodeName();
            if (declAttrs.getNamedItem(attrName) == null) {
                newEl.removeAttribute(attrName);
            }
            ++i2;
        }
    }
}

