/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.ui.internal;

import com.ibm.etools.palette.model.PaletteItemDataImpl;
import com.ibm.etools.webedit.common.utils.ActionUtil;
import com.ibm.etools.webedit.editor.HTMLEditor;
import com.ibm.etools.webedit.transfers.LocalTransfer;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataChangeListener;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModelLifeCycleListener;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.impl.PageActionNode;
import com.ibm.etools.webtools.pagedatamodel.impl.PageDataNodeProvidersRegistryReader;
import com.ibm.etools.webtools.pagedatamodel.util.PageDataModelListenersDispatcher;
import com.ibm.etools.webtools.pagedatamodel.util.PageDataModelUtil;
import com.ibm.etools.webtools.pagedataview.PageDataViewRegistryReader;
import com.ibm.etools.webtools.pagedataview.ui.CategoryChangeNotifier;
import com.ibm.etools.webtools.pagedataview.ui.IPageDataNodeUIAttribute;
import com.ibm.etools.webtools.pagedataview.ui.IPageDataViewPage;
import com.ibm.etools.webtools.pagedataview.ui.categories.internal.CategoryDefinition;
import com.ibm.etools.webtools.pagedataview.ui.categories.internal.CategoryRegistryReader;
import com.ibm.etools.webtools.pagedataview.ui.internal.CategoryNodeList;
import com.ibm.etools.webtools.pagedataview.ui.internal.IActionDelegateAdapter;
import com.ibm.etools.webtools.pagedataview.ui.internal.ICategoryChangeListener;
import com.ibm.etools.webtools.pagedataview.ui.internal.MainActionGroup;
import com.ibm.etools.webtools.pagedataview.ui.internal.PageDataView;
import com.ibm.etools.webtools.pagedataview.ui.internal.PageDataViewContentProvider;
import com.ibm.etools.webtools.pagedataview.ui.internal.PageDataViewEmptyCategoriesFilter;
import com.ibm.etools.webtools.pagedataview.ui.internal.PageDataViewLabelProvider;
import com.ibm.etools.webtools.pagedataview.ui.internal.PageDataViewSorter;
import com.ibm.etools.webtools.pagedataview.ui.internal.PageTypeHelper;
import com.ibm.etools.webtools.pagedataview.ui.internal.SingleObjectStructuredSelection;
import com.ibm.etools.webtools.pagedataview.util.ModelUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.wst.sse.ui.internal.IDropAction;
import org.eclipse.wst.sse.ui.internal.TransferBuilder;

public class PageDataViewPage
extends ContentOutlinePage
implements IPageDataViewPage,
IDoubleClickListener,
IPageDataModelLifeCycleListener,
ICategoryChangeListener {
    private IPageDataModel pageDataModel;
    private DragSource dragSource;
    private PageDataViewContentProvider provider;
    TransferBuilder transferBuilder;
    IEditorPart editor;
    protected ActionGroup mainActionGroup;
    private PageDataViewEmptyCategoriesFilter emptyCatFilter = new PageDataViewEmptyCategoriesFilter();
    private boolean hideEmptyCatsFilterApplied;

    public PageDataViewPage(IPageDataModel model) {
        this.pageDataModel = model;
        this.registerListener(this);
        PageDataModelListenersDispatcher.addPageDataModelListener((IPageDataModelLifeCycleListener)this);
        this.mainActionGroup = new MainActionGroup(new PageTypeHelper(this.pageDataModel));
        this.transferBuilder = new TransferBuilder();
        IEditorPart temp = ActionUtil.getActiveEditorPart();
        if (temp instanceof IEditorPart) {
            this.editor = temp;
        }
    }

    @Override
    public IPageDataModel getPageDataModel() {
        return this.pageDataModel;
    }

    public void setPageDataModel(IPageDataModel model) {
        TreeViewer viewer;
        IEditorPart temp;
        this.unregisterListener(this);
        this.pageDataModel = model;
        if (this.mainActionGroup == null) {
            this.mainActionGroup = new MainActionGroup(new PageTypeHelper(this.pageDataModel));
        }
        if (this.editor == null && (temp = ActionUtil.getActiveEditorPart()) instanceof IEditorPart) {
            this.editor = temp;
        }
        if ((viewer = this.getTreeViewer()) != null) {
            viewer.setInput((Object)this.pageDataModel);
            viewer.refresh();
        }
        this.registerListener(this);
    }

    private void registerListener(IPageDataChangeListener listener) {
        this.pageDataModel.getPageDataNotifier().addPageDataChangedListener(listener);
        CategoryChangeNotifier.getSingleton().addCategoryChangedListener(this);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        if (this.pageDataModel != null) {
            TreeViewer viewer = this.getTreeViewer();
            this.provider = new PageDataViewContentProvider();
            viewer.setContentProvider((IContentProvider)this.provider);
            viewer.setLabelProvider((IBaseLabelProvider)new PageDataViewLabelProvider());
            viewer.setInput((Object)this.pageDataModel);
            viewer.setSorter((ViewerSorter)new PageDataViewSorter());
            this.hookListeners(viewer);
            if (PageDataView.isHideEmptyCategoriesFilterApplied()) {
                viewer.addFilter((ViewerFilter)this.emptyCatFilter);
                this.hideEmptyCatsFilterApplied = true;
            }
            this.createDragSource(viewer);
            this.createDropTarget(viewer);
            this.createContextMenu();
            this.makeActions();
        }
    }

    private void createDragSource(final TreeViewer viewer) {
        DragSourceListener dragSourceListener = new DragSourceListener(){

            public void dragSetData(DragSourceEvent event) {
                List nodes = this.getSelectedObjects(viewer);
                if (!nodes.isEmpty()) {
                    event.data = nodes.toArray(new IPageDataNode[nodes.size()]);
                }
            }

            private List getSelectedObjects(TreeViewer viewer2) {
                StructuredSelection selection = (StructuredSelection)viewer2.getSelection();
                ArrayList nodes = new ArrayList();
                if (!selection.isEmpty()) {
                    Iterator itr = selection.iterator();
                    while (itr.hasNext()) {
                        nodes.add(itr.next());
                    }
                }
                return nodes;
            }

            public void dragStart(DragSourceEvent event) {
                List nodes = this.getSelectedObjects(viewer);
                if (!nodes.isEmpty()) {
                    List transfers = PageDataViewPage.this.getTransfersFromSelection((StructuredSelection)viewer.getSelection());
                    if (Platform.getOS().equals("linux")) {
                        PageDataViewPage.this.dragSource.setTransfer(transfers.toArray(new Transfer[transfers.size()]));
                    }
                    int i = 0;
                    while (i < transfers.size()) {
                        ((LocalTransfer)transfers.get(i)).setLocalObject((Object)nodes.toArray(new IPageDataNode[nodes.size()]));
                        ++i;
                    }
                }
            }

            public void dragFinished(DragSourceEvent event) {
                List transfers = PageDataViewPage.this.getTransfersFromSelection((StructuredSelection)viewer.getSelection());
                int i = 0;
                while (i < transfers.size()) {
                    ((LocalTransfer)transfers.get(i)).setLocalObject(null);
                    ++i;
                }
            }
        };
        this.dragSource = new DragSource(viewer.getControl(), 1);
        this.dragSource.setDragSourceEffect(null);
        this.dragSource.addDragListener(dragSourceListener);
    }

    private void createDropTarget(TreeViewer viewer) {
        DropTarget target = new DropTarget(viewer.getControl(), 7);
        DropTargetListener listener = new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                PaletteItemDataImpl template = (PaletteItemDataImpl)TemplateTransfer.getInstance().nativeToJava(event.currentDataType);
                if (!PageDataNodeProvidersRegistryReader.isPaletteCategoryRegistered((String)template.getCategory().getId()) && !PageDataNodeProvidersRegistryReader.isPaletteIdRegistered((String)template.getId())) {
                    event.detail = 0;
                }
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
            }

            public void dragOver(DropTargetEvent event) {
            }

            public void dropAccept(DropTargetEvent event) {
            }

            public void drop(DropTargetEvent event) {
                if (event.detail == 0) {
                    return;
                }
                if (event.data == null) {
                    event.detail = 0;
                    return;
                }
                if (TemplateTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    IDropAction[] actions = PageDataViewPage.this.transferBuilder.getDropActions(HTMLEditor.class.getName(), TemplateTransfer.class.getName());
                    int i = 0;
                    while (i < actions.length) {
                        if (actions[i].run(event, PageDataViewPage.this.editor)) break;
                        ++i;
                    }
                }
            }
        };
        target.setTransfer(new Transfer[]{TemplateTransfer.getInstance()});
        target.addDropListener(listener);
    }

    protected void hookListeners(final TreeViewer viewer) {
        viewer.addDoubleClickListener((IDoubleClickListener)this);
        viewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                ((MainActionGroup)PageDataViewPage.this.mainActionGroup).handleKeyEvent(event, viewer.getSelection());
            }
        });
    }

    private void makeActions() {
        this.mainActionGroup.fillActionBars(this.getSite().getActionBars());
    }

    public void nodeAdded(final IPageDataNode parent, final IPageDataNode addedChild) {
        if (!this.isVisibleNode(addedChild)) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TreeViewer viewer = PageDataViewPage.this.getTreeViewer();
                if (PageDataViewPage.this.isViewerReady(viewer)) {
                    if (parent == null) {
                        viewer.refresh();
                    } else if (PageDataModelUtil.isComponentNode((IPageDataNode)addedChild)) {
                        PageDataViewContentProvider provider;
                        String categoryID = addedChild.getCategory();
                        CategoryDefinition cd = CategoryRegistryReader.getSingleton().getCategory(categoryID);
                        if (cd == null) {
                            categoryID = "Other";
                            cd = CategoryRegistryReader.getSingleton().getCategory(categoryID);
                        }
                        if ((provider = (PageDataViewContentProvider)viewer.getContentProvider()).getVisibleCategories().get(categoryID) != null) {
                            viewer.add((Object)cd, (Object)addedChild);
                        } else {
                            provider.addVisibleCategory(cd);
                            String parentID = cd.getParentID();
                            if (parentID != null) {
                                CategoryDefinition parent2 = CategoryRegistryReader.getSingleton().getCategory(cd.getParentID());
                                viewer.add((Object)addedChild.getPageDataModel(), (Object)parent2);
                                viewer.add((Object)parent2, (Object)cd);
                            } else {
                                viewer.add((Object)addedChild.getPageDataModel(), (Object)cd);
                            }
                            viewer.add((Object)cd, (Object)addedChild);
                        }
                        if (PageDataViewPage.this.isExpandedTo(cd, viewer)) {
                            viewer.setSelection((ISelection)new SingleObjectStructuredSelection(addedChild));
                        } else {
                            viewer.expandToLevel((Object)cd, 1);
                            viewer.setSelection((ISelection)new SingleObjectStructuredSelection(addedChild));
                        }
                    } else {
                        viewer.add((Object)addedChild.getParent(), (Object)addedChild);
                    }
                }
            }
        };
        this.getSite().getShell().getDisplay().asyncExec(runnable);
    }

    private boolean isExpandedTo(Object obj, TreeViewer viewer) {
        boolean isExpandedTo = false;
        Object[] expandedElements = viewer.getExpandedElements();
        int i = 0;
        while (i < expandedElements.length) {
            if (obj.equals(expandedElements[i])) {
                isExpandedTo = true;
                break;
            }
            ++i;
        }
        return isExpandedTo;
    }

    private boolean isViewerReady(TreeViewer viewer) {
        return viewer != null && viewer.getControl() != null && !viewer.getControl().isDisposed() && !viewer.isBusy();
    }

    public void nodeChanged(IPageDataNode originalNode, final IPageDataNode changedNode) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TreeViewer viewer = PageDataViewPage.this.getTreeViewer();
                if (PageDataViewPage.this.isViewerReady(viewer)) {
                    viewer.refresh((Object)changedNode);
                }
            }
        };
        this.getSite().getShell().getDisplay().asyncExec(runnable);
    }

    public void nodeRemoved(final IPageDataNode parent, final IPageDataNode removedChild) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TreeViewer viewer = PageDataViewPage.this.getTreeViewer();
                if (PageDataViewPage.this.isViewerReady(viewer)) {
                    if (parent == null) {
                        viewer.refresh();
                    } else if (removedChild != null) {
                        if (PageDataModelUtil.isComponentNode((IPageDataNode)removedChild) && removedChild.getCategory() != null) {
                            String categoryID = removedChild.getCategory();
                            CategoryDefinition category = CategoryRegistryReader.getSingleton().getCategory(categoryID);
                            if (category == null) {
                                categoryID = "Other";
                                category = CategoryRegistryReader.getSingleton().getCategory(categoryID);
                            }
                            PageDataViewContentProvider provider = (PageDataViewContentProvider)viewer.getContentProvider();
                            boolean isEmpty = provider.isCategoryEmpty(categoryID);
                            if (!category.isShowWhenEmpty() && isEmpty || isEmpty && PageDataView.isHideEmptyCategoriesFilterApplied()) {
                                viewer.remove((Object)category);
                                provider.removeVisibleCategory(category);
                            }
                        }
                        viewer.remove((Object)removedChild);
                    }
                }
            }
        };
        this.getSite().getShell().getDisplay().asyncExec(runnable);
    }

    @Override
    public void categoryChanged(String categoryID, boolean expandCategory) {
        this.refreshCategory(categoryID, expandCategory);
    }

    private void refreshCategory(final String categoryID, final boolean expandCategory) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TreeViewer viewer = PageDataViewPage.this.getTreeViewer();
                if (PageDataViewPage.this.isViewerReady(viewer)) {
                    PageDataViewContentProvider provider = (PageDataViewContentProvider)viewer.getContentProvider();
                    CategoryDefinition category = null;
                    CategoryNodeList catList = provider.getVisibleCategories();
                    if (catList != null) {
                        category = catList.get(categoryID);
                        if (category != null) {
                            boolean isEmpty = provider.isCategoryEmpty(categoryID);
                            if (isEmpty && !category.isShowWhenEmpty() || isEmpty && PageDataView.isHideEmptyCategoriesFilterApplied()) {
                                viewer.remove((Object)category);
                                provider.removeVisibleCategory(category);
                            } else {
                                viewer.refresh((Object)category);
                            }
                        } else if (!provider.isCategoryEmpty(categoryID)) {
                            category = CategoryRegistryReader.getSingleton().getCategory(categoryID);
                            provider.addVisibleCategory(category);
                            viewer.add(viewer.getInput(), (Object)category);
                        }
                        if (expandCategory) {
                            viewer.expandToLevel((Object)category, 1);
                        }
                    }
                }
            }
        };
        this.getSite().getShell().getDisplay().asyncExec(runnable);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        StructuredSelection selections = (StructuredSelection)event.getSelection();
        if (!selections.isEmpty()) {
            List transfers = this.getTransfersFromSelection(selections);
            this.dragSource.setTransfer(transfers.toArray(new Transfer[transfers.size()]));
        }
    }

    private List getTransfersFromSelection(StructuredSelection selections) {
        Iterator itr = selections.iterator();
        ArrayList<Transfer> transfers = new ArrayList<Transfer>();
        while (itr.hasNext()) {
            IPageDataNodeUIAttribute viewProp;
            String transferID;
            Transfer transferClass;
            Object item = itr.next();
            if (!(item instanceof IPageDataNode) || (transferClass = (Transfer)PageDataViewRegistryReader.getDragTransferTypeClass(transferID = (viewProp = (IPageDataNodeUIAttribute)((IPageDataNode)item).getAdapter(IPageDataNodeUIAttribute.class)).getDNDTransferID())) == null || transfers.contains(transferClass)) continue;
            transfers.add(transferClass);
        }
        return transfers;
    }

    private void createContextMenu() {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                PageDataViewPage.this.fillContextMenu(manager);
            }
        });
        Menu menu = manager.createContextMenu(this.getTreeViewer().getControl());
        this.getTreeViewer().getControl().setMenu(menu);
        this.getSite().registerContextMenu("com.ibm.etools.webtools.pagedataview.contextMenu", manager, (ISelectionProvider)this.getTreeViewer());
    }

    void fillContextMenu(IMenuManager manager) {
        IStructuredSelection selection = (IStructuredSelection)this.getTreeViewer().getSelection();
        this.mainActionGroup.setContext(new ActionContext((ISelection)selection));
        this.mainActionGroup.fillContextMenu(manager);
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator(ActionFactory.PROPERTIES.getId()));
    }

    public void doubleClick(DoubleClickEvent event) {
        ISelection sel = event.getSelection();
        if (!sel.isEmpty()) {
            try {
                IStructuredSelection selection = (IStructuredSelection)sel;
                IPageDataNode nodeSelected = (IPageDataNode)selection.getFirstElement();
                boolean executed = false;
                IActionDelegateAdapter adapter = (IActionDelegateAdapter)nodeSelected.getAdapter(IActionDelegateAdapter.ADAPTER_KEY);
                if (adapter != null && adapter.canHandleAction(nodeSelected, 1)) {
                    executed = adapter.handleAction(nodeSelected, 1);
                }
                if (!executed && PageDataModelUtil.isComponentNode((IPageDataNode)nodeSelected)) {
                    ModelUtil.configurePageData(nodeSelected);
                }
            }
            catch (ClassCastException classCastException) {}
        }
    }

    public void dispose() {
        if (this.mainActionGroup != null) {
            this.mainActionGroup.dispose();
        }
        super.dispose();
    }

    protected void refreshPDVNode(Object pageDataNode) {
        if (this.isViewerReady(this.getTreeViewer())) {
            this.getTreeViewer().refresh(pageDataNode);
        }
    }

    protected void refreshPDVTree() {
        if (this.isViewerReady(this.getTreeViewer())) {
            this.getTreeViewer().refresh();
        }
    }

    protected void updateNode(Object pageDataNode) {
        if (this.isViewerReady(this.getTreeViewer())) {
            this.getTreeViewer().update(pageDataNode, null);
        }
    }

    public void pageDataModelToBeReleased(IPageDataModel model) {
        if (model == this.pageDataModel) {
            this.unregisterListener(this);
            this.editor = null;
            this.mainActionGroup = null;
            this.pageDataModel = null;
            PageDataModelListenersDispatcher.removePageDataModelListener((IPageDataModelLifeCycleListener)this);
        }
    }

    protected boolean isVisibleNode(IPageDataNode node) {
        if (node instanceof PageActionNode) {
            return ((PageActionNode)node).isSolitary();
        }
        return node.getAdapter(IPageDataNodeUIAttribute.ADAPTER_KEY) != null && !"Client Side".equals(node.getDataCategory());
    }

    public void pageDataModelInitialized(IPageDataModel model) {
    }

    public void pageDataModelReleased() {
    }

    public void pageDataModelToBeInitialized(IPageDataModel model) {
    }

    private void unregisterListener(IPageDataChangeListener listener) {
        if (this.pageDataModel != null) {
            this.pageDataModel.getPageDataNotifier().removePageDataChangedListener(listener);
        }
        CategoryChangeNotifier.getSingleton().removePageDataChangedListener(this);
    }

    public void editorDisposed() {
        this.unregisterListener(this);
        PageDataModelListenersDispatcher.removePageDataModelListener((IPageDataModelLifeCycleListener)this);
        this.editor = null;
        this.mainActionGroup = null;
        this.pageDataModel = null;
    }

    public void addFilter(ViewerFilter filter) {
        TreeViewer treeViewer = this.getTreeViewer();
        if (this.isViewerReady(treeViewer)) {
            treeViewer.addFilter(filter);
        }
    }

    public void removeFilter(ViewerFilter filter) {
        TreeViewer treeViewer = this.getTreeViewer();
        if (this.isViewerReady(treeViewer)) {
            treeViewer.removeFilter(filter);
        }
    }

    public ViewerFilter[] getFilters() {
        TreeViewer treeViewer = this.getTreeViewer();
        if (this.isViewerReady(treeViewer)) {
            return treeViewer.getFilters();
        }
        return null;
    }

    protected void setHideEmptyCategoriesFilterEnabled(boolean enabled) {
        TreeViewer treeViewer = this.getTreeViewer();
        if (enabled) {
            if (this.isViewerReady(treeViewer) && !this.hideEmptyCatsFilterApplied) {
                treeViewer.addFilter((ViewerFilter)this.emptyCatFilter);
                this.hideEmptyCatsFilterApplied = true;
            }
        } else if (this.isViewerReady(treeViewer) && this.hideEmptyCatsFilterApplied) {
            treeViewer.removeFilter((ViewerFilter)this.emptyCatFilter);
            this.hideEmptyCatsFilterApplied = false;
        }
    }

    protected void collapseAll() {
        TreeViewer viewer = this.getTreeViewer();
        if (this.isViewerReady(viewer)) {
            viewer.collapseAll();
        }
    }
}

