/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.ui.internal;

import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.impl.PageDataNode;
import com.ibm.etools.webtools.pagedataview.ui.categories.internal.CategoryDefinition;
import com.ibm.etools.webtools.pagedataview.ui.internal.CategoryNodeList;
import com.ibm.etools.webtools.pagedataview.ui.internal.PageDataViewContentProvider;
import com.ibm.etools.webtools.pagedataview.ui.internal.PageDataViewDeferredNodeFetcher;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.WorkbenchJob;

public class PageDataViewDeferredContentProvider
implements ITreeContentProvider {
    private PageDataViewContentProvider provider = new PageDataViewContentProvider();
    private MyDeferredTreeContentManager contentManager;
    private IPageDataNode nodeToSelect = null;

    public PageDataViewDeferredContentProvider(AbstractTreeViewer viewer) {
        this.contentManager = new MyDeferredTreeContentManager(this.provider, viewer);
    }

    public CategoryNodeList getVisibleCategories() {
        return this.provider.getVisibleCategories();
    }

    public void addVisibleCategory(CategoryDefinition category) {
        this.provider.addVisibleCategory(category);
    }

    public void removeVisibleCategory(CategoryDefinition category) {
        this.provider.removeVisibleCategory(category);
    }

    public boolean isCategoryEmpty(String categoryID) {
        return this.provider.isCategoryEmpty(categoryID);
    }

    public Object getParent(Object element) {
        return this.provider.getParent(element);
    }

    public boolean hasChildren(Object element) {
        return this.contentManager.mayHaveChildren(element);
    }

    public Object[] getElements(Object inputElement) {
        return this.provider.getElements(inputElement);
    }

    public void dispose() {
        this.provider.dispose();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.provider.inputChanged(viewer, oldInput, newInput);
    }

    public Object[] getChildren(Object parentElement) {
        return this.contentManager.getChildren(parentElement);
    }

    public void setNodeToSelect(IPageDataNode nodeToSelect) {
        this.nodeToSelect = nodeToSelect;
    }

    private class MyDeferredTreeContentManager
    extends DeferredTreeContentManager {
        private ITreeContentProvider provider;
        private AbstractTreeViewer pdvTreeViewer;

        protected void addChildren(final Object parent, final Object[] children, IProgressMonitor monitor) {
            WorkbenchJob updateJob = new WorkbenchJob("Adding Page Data Children"){

                public IStatus runInUIThread(IProgressMonitor updateMonitor) {
                    if (MyDeferredTreeContentManager.this.pdvTreeViewer.getControl().isDisposed() || updateMonitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    MyDeferredTreeContentManager.this.pdvTreeViewer.add(parent, children);
                    if (PageDataViewDeferredContentProvider.this.nodeToSelect != null) {
                        PageDataViewDeferredContentProvider.this.nodeToSelect = null;
                    }
                    return Status.OK_STATUS;
                }
            };
            updateJob.setSystem(true);
            updateJob.schedule();
        }

        public MyDeferredTreeContentManager(ITreeContentProvider provider, AbstractTreeViewer viewer) {
            super(provider, viewer);
            this.provider = provider;
            this.pdvTreeViewer = viewer;
        }

        protected IDeferredWorkbenchAdapter getAdapter(Object element) {
            if (element instanceof IDeferredWorkbenchAdapter) {
                return (IDeferredWorkbenchAdapter)element;
            }
            if (element instanceof PageDataNode || element instanceof CategoryDefinition) {
                PageDataViewDeferredNodeFetcher adapter = new PageDataViewDeferredNodeFetcher(element, this.provider);
                return adapter;
            }
            return null;
        }

        public boolean mayHaveChildren(Object element) {
            if (element instanceof IWorkbenchAdapter) {
                return false;
            }
            return super.mayHaveChildren(element);
        }
    }
}

