/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.ui.internal;

import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.impl.PageActionNode;
import com.ibm.etools.webtools.pagedatamodel.util.PageDataModelUtil;
import com.ibm.etools.webtools.pagedataview.ui.IPageDataNodeUIAttribute;
import com.ibm.etools.webtools.pagedataview.ui.categories.internal.CategoryDefinition;
import com.ibm.etools.webtools.pagedataview.ui.categories.internal.CategoryRegistryReader;
import com.ibm.etools.webtools.pagedataview.ui.internal.CategoryNodeList;
import com.ibm.etools.webtools.pagedataview.ui.internal.NonUINodeFilter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class PageDataViewContentProvider
implements ITreeContentProvider {
    private IPageDataModel pageDataModel;
    private CategoryNodeList visibleCategoriesList;

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IPageDataModel) {
            this.pageDataModel = (IPageDataModel)inputElement;
            this.visibleCategoriesList = CategoryRegistryReader.getSingleton().getVisibleCategories(this.pageDataModel);
            return this.visibleCategoriesList.toArray();
        }
        return new Object[0];
    }

    public Object[] getChildren(Object parentElement) {
        Object[] childrenArray = new Object[]{};
        if (parentElement instanceof IPageDataNode) {
            IPageDataNode pageDataNode = (IPageDataNode)parentElement;
            EList children = pageDataNode.getChildren();
            if (children != null && children.size() > 0) {
                childrenArray = new NonUINodeFilter().filter(children.toArray(new IPageDataNode[0]));
            }
        } else if (parentElement instanceof CategoryDefinition) {
            ArrayList<IPageDataNode> childrenOfCategory = new ArrayList<IPageDataNode>();
            EList allChildren = this.pageDataModel.getRoot().getChildren();
            String categoryID = ((CategoryDefinition)parentElement).getCategoryID();
            int i = 0;
            while (i < allChildren.size()) {
                IPageDataNode child = (IPageDataNode)allChildren.get(i);
                if (this.isVisibleNode(child)) {
                    String childCategoryID = child.getCategory();
                    if (childCategoryID == null || CategoryRegistryReader.getSingleton().getCategory(childCategoryID) == null) {
                        childCategoryID = "Other";
                    }
                    if (categoryID.equals(childCategoryID)) {
                        childrenOfCategory.add(child);
                    }
                }
                ++i;
            }
            childrenArray = childrenOfCategory.toArray(new IPageDataNode[childrenOfCategory.size()]);
            if (((CategoryDefinition)parentElement).getChildren() != null) {
                List<CategoryDefinition> childCategories = ((CategoryDefinition)parentElement).getChildren();
                ArrayList<CategoryDefinition> childCategoriesFiltered = new ArrayList<CategoryDefinition>();
                for (CategoryDefinition cd : childCategories) {
                    if (!CategoryRegistryReader.getSingleton().isCategoryVisible(cd, this.pageDataModel)) continue;
                    childCategoriesFiltered.add(cd);
                }
                CategoryDefinition[] childCategoriesArray = childCategoriesFiltered.toArray(new CategoryDefinition[childCategoriesFiltered.size()]);
                Object[] mergedArray = new Object[childrenArray.length + childCategoriesArray.length];
                System.arraycopy(childrenArray, 0, mergedArray, 0, childrenArray.length);
                System.arraycopy(childCategoriesArray, 0, mergedArray, childrenArray.length, childCategoriesArray.length);
                childrenArray = mergedArray;
            }
        }
        return childrenArray;
    }

    public void dispose() {
        this.pageDataModel = null;
        this.visibleCategoriesList = null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IPageDataNode) {
            return ((IPageDataNode)element).hasChildren();
        }
        return element instanceof CategoryDefinition;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput != null) {
            this.pageDataModel = null;
        }
    }

    public Object getParent(Object element) {
        String parentID;
        if (element instanceof IPageDataNode) {
            IPageDataNode node = (IPageDataNode)element;
            String categoryId = node.getCategory();
            if (categoryId != null && PageDataModelUtil.isComponentNode((IPageDataNode)node)) {
                return CategoryRegistryReader.getSingleton().getCategory(categoryId);
            }
            return node.getParent();
        }
        if (element instanceof CategoryDefinition && (parentID = ((CategoryDefinition)element).getParentID()) != null) {
            return CategoryRegistryReader.getSingleton().getCategory(parentID);
        }
        return null;
    }

    public CategoryNodeList getVisibleCategories() {
        return this.visibleCategoriesList;
    }

    public void addVisibleCategory(CategoryDefinition category) {
        this.visibleCategoriesList.add(category);
    }

    public void removeVisibleCategory(CategoryDefinition category) {
        this.visibleCategoriesList.remove(category);
    }

    public boolean isCategoryEmpty(String categoryID) {
        boolean isEmpty = true;
        CategoryDefinition cd = CategoryRegistryReader.getSingleton().getCategory(categoryID);
        if (cd.getChildren() == null) {
            isEmpty = this.calculateCategoryIsEmpty(categoryID);
        } else {
            ArrayList<String> subCategoryIDs = new ArrayList<String>();
            subCategoryIDs.addAll(this.getAllSubCategoryIDs(categoryID));
            for (String subCategoryID : subCategoryIDs) {
                if (this.calculateCategoryIsEmpty(subCategoryID)) continue;
                isEmpty = false;
                break;
            }
        }
        return isEmpty;
    }

    private boolean calculateCategoryIsEmpty(String categoryID) {
        boolean isEmpty = true;
        EList children = this.pageDataModel.getRoot().getChildren();
        int i = 0;
        while (i < children.size()) {
            IPageDataNode child = (IPageDataNode)children.get(i);
            String category = child.getCategory();
            if (categoryID == null) {
                categoryID = "Other";
            }
            if (categoryID.equals(category) && this.isVisibleNode(child)) {
                isEmpty = false;
                break;
            }
            ++i;
        }
        return isEmpty;
    }

    private List<String> getAllSubCategoryIDs(String categoryID) {
        ArrayList<String> subCategoryIDs = new ArrayList<String>();
        subCategoryIDs.add(categoryID);
        CategoryDefinition cd = CategoryRegistryReader.getSingleton().getCategory(categoryID);
        List<CategoryDefinition> children = cd.getChildren();
        if (children != null) {
            for (CategoryDefinition child : children) {
                subCategoryIDs.addAll(this.getAllSubCategoryIDs(child.getCategoryID()));
            }
        }
        return subCategoryIDs;
    }

    protected boolean isVisibleNode(IPageDataNode node) {
        if (node instanceof PageActionNode) {
            return ((PageActionNode)node).isSolitary();
        }
        return node.getAdapter(IPageDataNodeUIAttribute.ADAPTER_KEY) != null && !"Client Side".equals(node.getDataCategory());
    }
}

