/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.ui.internal;

import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedataview.PageDataViewPlugin;
import com.ibm.etools.webtools.pagedataview.nls.ResourceHandler;
import com.ibm.etools.webtools.pagedataview.ui.IPageDataViewPage;
import com.ibm.etools.webtools.pagedataview.ui.internal.ActionBarContributorRegistryReader;
import com.ibm.etools.webtools.pagedataview.ui.internal.HideEmptyCategoriesAction;
import com.ibm.etools.webtools.pagedataview.ui.internal.IPageDataViewActionBarContributor;
import com.ibm.etools.webtools.pagedataview.ui.internal.PageDataViewPage;
import com.ibm.etools.webtools.pagedataview.util.ModelUtil;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.MessagePage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;
import org.eclipse.ui.part.PageSite;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class PageDataView
extends ContentOutline {
    public static final String PAGEDATAVIEW_ID = "com.ibm.etools.webtools.pagedataview.PageDataView";
    private String defaultText = ResourceHandler.NoPageData;
    protected static PageDataViewPage currentPage = null;
    private Action hideEmptyCategoriesAction;
    private static boolean emptyCatFilterApplied = false;
    private static String EMPTY_CAT_FILTER_APPLIED = "emptyCatFilterApplied";

    public static PageDataView getViewInstance() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && window.getActivePage() != null) {
            IViewPart eventViewPart;
            IViewReference[] viewRefs = window.getActivePage().getViewReferences();
            IViewReference eventViewRef = null;
            int i = 0;
            while (i < viewRefs.length) {
                if (viewRefs[i].getId().equals(PAGEDATAVIEW_ID)) {
                    eventViewRef = viewRefs[i];
                }
                ++i;
            }
            if (eventViewRef != null && (eventViewPart = eventViewRef.getView(true)) != null && eventViewPart instanceof PageDataView) {
                return (PageDataView)eventViewPart;
            }
        }
        return null;
    }

    public static PageDataViewPage getCurrentPageDataViewPage() {
        return currentPage;
    }

    public static void bringToTop(String toSelect) {
        IWorkbenchPage page;
        IViewPart pageDataView;
        IWorkbenchWindow activeWindow;
        String contentViewID = PAGEDATAVIEW_ID;
        if (PlatformUI.isWorkbenchRunning() && (activeWindow = PageDataViewPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow()) != null && (pageDataView = (page = activeWindow.getActivePage()).findView(contentViewID)) != null) {
            page.bringToTop((IWorkbenchPart)pageDataView);
            if (toSelect != null) {
                ModelUtil.findAndSelectNodeByName(toSelect);
            }
        }
    }

    public static void refreshPDV(Object pageDataNode) {
        if (currentPage != null) {
            currentPage.refreshPDVNode(pageDataNode);
        }
    }

    public static void refreshPDV() {
        if (currentPage != null) {
            currentPage.refreshPDVTree();
        }
    }

    public static void updatePDV(Object pageDataNode) {
        if (currentPage != null) {
            currentPage.updateNode(pageDataNode);
        }
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        if (!this.isImportant(part)) {
            return null;
        }
        Object obj = this.getPageDataViewPageAdapter(part);
        if (obj instanceof IPageDataViewPage) {
            IPageDataViewPage page = (IPageDataViewPage)obj;
            if (page instanceof IPageBookViewPage) {
                this.initPage((IPageBookViewPage)page);
            }
            page.createControl((Composite)this.getPageBook());
            currentPage = (PageDataViewPage)page;
            this.updateToolbar(currentPage.getPageDataModel());
            return new PageBookView.PageRec(part, (IPage)page);
        }
        return null;
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec rec) {
        IPageDataViewPage page = (IPageDataViewPage)rec.page;
        page.dispose();
        rec.dispose();
    }

    public Object getAdapter(Class key) {
        if (key == IContributedContentsView.class) {
            return new IContributedContentsView(){

                public IWorkbenchPart getContributingPart() {
                    return PageDataView.this.getContributingEditor();
                }
            };
        }
        return null;
    }

    IWorkbenchPart getContributingEditor() {
        return this.getCurrentContributingPart();
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part instanceof IEditorPart;
    }

    protected void showPageRec(PageBookView.PageRec pageRec) {
        PageSite pageSite = this.getPageSite(pageRec.page);
        ISelectionProvider provider = pageSite.getSelectionProvider();
        if (provider == null && pageRec.page instanceof IContentOutlinePage && pageRec.page instanceof IPageDataViewPage) {
            pageSite.setSelectionProvider((ISelectionProvider)((IPageDataViewPage)pageRec.page));
        }
        super.showPageRec(pageRec);
    }

    public void setFocus() {
        this.getCurrentPage().getControl().setFocus();
    }

    protected IPage createDefaultPage(PageBook book) {
        MessagePage defaultPage = (MessagePage)super.createDefaultPage(book);
        defaultPage.setMessage(this.defaultText);
        return defaultPage;
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        super.partBroughtToTop(part);
    }

    public void partActivated(IWorkbenchPart part) {
        IPageDataViewPage page;
        super.partActivated(part);
        if (!this.isImportant(part)) {
            return;
        }
        Object obj = this.getPageDataViewPageAdapter(part);
        if (obj != null && obj instanceof IPageDataViewPage && (page = (IPageDataViewPage)obj) != currentPage) {
            currentPage = (PageDataViewPage)page;
            currentPage.setHideEmptyCategoriesFilterEnabled(emptyCatFilterApplied);
            this.updateToolbar(currentPage.getPageDataModel());
        }
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getPageBook(), "com.ibm.etools.webtools.pagedataview.infopop");
    }

    protected void updateToolbar(IPageDataModel model) {
        IMenuManager mgr = this.getViewSite().getActionBars().getMenuManager();
        mgr.removeAll();
        if (this.hideEmptyCategoriesAction == null) {
            this.hideEmptyCategoriesAction = new HideEmptyCategoriesAction();
        }
        mgr.add((IAction)this.hideEmptyCategoriesAction);
        this.hideEmptyCategoriesAction.setChecked(emptyCatFilterApplied);
        List contributors = ActionBarContributorRegistryReader.getSingleton().getContributors(model);
        try {
            if (contributors != null) {
                int i = 0;
                while (i < contributors.size()) {
                    IPageDataViewActionBarContributor contributor = (IPageDataViewActionBarContributor)contributors.get(i);
                    contributor.contributeTo(mgr, model);
                    ++i;
                }
            }
            mgr.update();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setCurrentPage(PageDataViewPage page) {
        if (page != null && page != currentPage) {
            currentPage = page;
            currentPage.setHideEmptyCategoriesFilterEnabled(emptyCatFilterApplied);
            this.updateToolbar(page.getPageDataModel());
        }
    }

    protected static void toggleHideCategoriesWhenEmptyFilter() {
        emptyCatFilterApplied = !emptyCatFilterApplied;
        PageDataViewPage currentPage = PageDataView.getCurrentPageDataViewPage();
        if (currentPage != null) {
            currentPage.setHideEmptyCategoriesFilterEnabled(emptyCatFilterApplied);
        }
    }

    protected static void collapseAll() {
        if (currentPage != null) {
            currentPage.collapseAll();
        }
    }

    protected static boolean isHideEmptyCategoriesFilterApplied() {
        return emptyCatFilterApplied;
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        if (memento != null) {
            memento.putString(EMPTY_CAT_FILTER_APPLIED, Boolean.toString(emptyCatFilterApplied));
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        String trueOrFalse;
        super.init(site, memento);
        if (memento != null && (trueOrFalse = memento.getString(EMPTY_CAT_FILTER_APPLIED)) != null) {
            emptyCatFilterApplied = Boolean.valueOf(trueOrFalse);
        }
    }

    protected Object getPageDataViewPageAdapter(IWorkbenchPart part) {
        return part.getAdapter(IPageDataViewPage.class);
    }
}

