/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.ui.internal;

import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedataview.PageDataViewPlugin;
import com.ibm.etools.webtools.pagedataview.ui.NewPageDataDialog;
import com.ibm.etools.webtools.pagedataview.ui.categories.internal.CategoryDefinition;
import com.ibm.etools.webtools.pagedataview.ui.categories.internal.CategoryRegistryReader;
import com.ibm.etools.webtools.pagedataview.ui.internal.CategoryNodeList;
import com.ibm.etools.webtools.pagedataview.ui.internal.NewActionsRegistryReader;
import com.ibm.etools.webtools.pagedataview.ui.internal.NewActionsVisiblityRulesRegistryReader;
import com.ibm.etools.webtools.pagedataview.ui.internal.PageTypeHelper;
import com.ibm.etools.webtools.pagedataview.ui.internal.ProxyAction;
import com.ibm.etools.webtools.pagedataview.ui.nls.ResourceHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Shell;

public class NewPageDataAction
extends Action {
    private PageTypeHelper helper;
    private IPageDataNode selectionHint;

    public NewPageDataAction(PageTypeHelper pageType) {
        this.setImageDescriptor(PageDataViewPlugin.getDefault().getImageDescriptor("full/obj16/new"));
        this.setDescription(ResourceHandler.UI_Dlg_NewData);
        this.setToolTipText(ResourceHandler.UI_TT_NewData);
        this.helper = pageType;
    }

    public void run() {
        ArrayList<IConfigurationElement> visibleActions = new ArrayList<IConfigurationElement>();
        CategoryNodeList visibleCategories = CategoryRegistryReader.getSingleton().getPotentiallyVisibleCategories(this.helper.getPageDataModel());
        String[] pageTypes = this.helper.getPageTypes((short)0);
        Collection actionsForPageTypes = NewActionsRegistryReader.getNewActions(pageTypes).values();
        ArrayList actionsForPageTypesList = new ArrayList();
        for (List actionList : actionsForPageTypes) {
            actionsForPageTypesList.addAll(actionList);
        }
        int i = 0;
        while (i < visibleCategories.size()) {
            String categoryID = ((CategoryDefinition)visibleCategories.get(i)).getCategoryID();
            List actionsForCategory = NewActionsRegistryReader.getActionsForCategory(categoryID);
            if (actionsForCategory != null) {
                for (IConfigurationElement actionElement : actionsForCategory) {
                    String isInNewMenu;
                    if (!NewActionsVisiblityRulesRegistryReader.getSingleton().isActionVisible(actionElement, actionsForPageTypesList, this.helper.getPageDataModel()) || (isInNewMenu = actionElement.getAttribute("newMenu")) != null && !Boolean.valueOf(isInNewMenu).booleanValue()) continue;
                    visibleActions.add(actionElement);
                }
            }
            ++i;
        }
        Shell shell = PageDataViewPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        NewPageDataDialog dialog = new NewPageDataDialog(shell, visibleActions);
        dialog.setSelectionHint(this.selectionHint);
        if (dialog.open() == 0) {
            IConfigurationElement actionElement = (IConfigurationElement)dialog.getResult()[0];
            ProxyAction action = new ProxyAction(actionElement);
            action.run();
        }
    }

    public void setSelectionHint(IPageDataNode selectionHint) {
        this.selectionHint = selectionHint;
    }
}

