/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.ui.internal;

import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedataview.PageDataViewPlugin;
import com.ibm.etools.webtools.pagedataview.ui.internal.VisibilityRule;
import com.ibm.etools.webtools.pagedataview.ui.internal.VisibilityRulesUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class NewActionsVisiblityRulesRegistryReader {
    private static NewActionsVisiblityRulesRegistryReader singleton;
    private boolean parsed = false;
    private static final String VIS_RULES_EXTENSION_PT_ID = "visibilityRules";
    private static final String NEW_ACTION_EXTENSION_PT_ID = "newAction";
    private static final String ELEM_RULES = "rules";
    private static final String ELEM_FACET = "facet";
    private static final String ATT_FACET_EXISTS = "exists";
    private static final String ATT_FACET_VERSION = "version";
    private static final String ELEM_OR = "or";
    private Map rulesMap = new HashMap();

    public static NewActionsVisiblityRulesRegistryReader getSingleton() {
        if (singleton == null) {
            singleton = new NewActionsVisiblityRulesRegistryReader();
        }
        return singleton;
    }

    public boolean isActionVisible(IConfigurationElement actionElement, List actionsForPageTypesList, IPageDataModel model) {
        if (!this.parsed) {
            NewActionsVisiblityRulesRegistryReader.getSingleton().parseVisibilityRules();
        }
        if (!actionsForPageTypesList.contains(actionElement)) {
            return false;
        }
        String actionID = actionElement.getAttribute("id");
        if (actionID == null || this.rulesMap.get(actionID) == null) {
            return true;
        }
        boolean isVisible = true;
        IProject proj = model.getResource().getProject();
        List visiblityRulesList = (List)this.rulesMap.get(actionID);
        for (Object next : visiblityRulesList) {
            List orList;
            boolean orListSatisfied;
            if (next instanceof VisibilityRule) {
                VisibilityRule rule = (VisibilityRule)next;
                boolean shouldExist = rule.isShouldExist();
                String facetID = rule.getFacetID();
                String facetVersion = rule.getFacetVersion();
                if (facetVersion == "") {
                    facetVersion = null;
                }
                if (VisibilityRulesUtil.projectHasFacet(proj, facetID, facetVersion) == shouldExist) continue;
                isVisible = false;
                break;
            }
            if (!(next instanceof List) || (orListSatisfied = VisibilityRulesUtil.processOrList(orList = (List)next, proj))) continue;
            isVisible = false;
            break;
        }
        return isVisible;
    }

    private void parseVisibilityRules() {
        String pluginId = PageDataViewPlugin.getDefault().getBundle().getSymbolicName();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(pluginId, VIS_RULES_EXTENSION_PT_ID);
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            String newActionID = null;
            int j = 0;
            while (j < configElements.length) {
                IConfigurationElement element = configElements[j];
                if (NEW_ACTION_EXTENSION_PT_ID.equals(element.getName())) {
                    List<VisibilityRule> visibilityRulesList;
                    newActionID = element.getAttribute("id");
                    if (this.rulesMap.containsKey(newActionID)) {
                        visibilityRulesList = (List)this.rulesMap.get(newActionID);
                    } else {
                        visibilityRulesList = new ArrayList();
                        this.rulesMap.put(newActionID, visibilityRulesList);
                    }
                    IConfigurationElement rulesElement = element.getChildren(ELEM_RULES)[0];
                    IConfigurationElement[] facets = rulesElement.getChildren(ELEM_FACET);
                    int k = 0;
                    while (k < facets.length) {
                        VisibilityRule rule = new VisibilityRule();
                        rule.setFacetID(facets[k].getAttribute("id"));
                        rule.setFacetVersion(facets[k].getAttribute(ATT_FACET_VERSION));
                        if (facets[k].getAttribute(ATT_FACET_EXISTS) == null) {
                            rule.setShouldExist(true);
                        } else {
                            rule.setShouldExist(Boolean.valueOf(facets[k].getAttribute(ATT_FACET_EXISTS)));
                        }
                        visibilityRulesList.add(rule);
                        ++k;
                    }
                    IConfigurationElement[] orGroups = rulesElement.getChildren(ELEM_OR);
                    if (orGroups != null && orGroups.length > 0) {
                        VisibilityRulesUtil.addOrGroups(visibilityRulesList, orGroups);
                    }
                }
                ++j;
            }
            ++i;
        }
        this.parsed = true;
    }
}

