/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.ui.internal;

import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.util.PageDataModelUtil;
import com.ibm.etools.webtools.pagedataview.ui.categories.internal.CategoryDefinition;
import com.ibm.etools.webtools.pagedataview.ui.internal.NewActionsRegistryReader;
import com.ibm.etools.webtools.pagedataview.ui.internal.NewActionsVisiblityRulesRegistryReader;
import com.ibm.etools.webtools.pagedataview.ui.internal.NewPageDataAction;
import com.ibm.etools.webtools.pagedataview.ui.internal.PageTypeHelper;
import com.ibm.etools.webtools.pagedataview.ui.internal.ProxyAction;
import com.ibm.etools.webtools.pagedataview.ui.nls.ResourceHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.actions.ActionGroup;

public class NewActionGroup
extends ActionGroup {
    private PageTypeHelper helper;
    private NewPageDataAction otherAction;
    public static final String NEW_MENU = "newMenu";

    public NewActionGroup(PageTypeHelper helper) {
        this.helper = helper;
        this.otherAction = new OtherAction(helper);
    }

    public void fillContextMenu(IMenuManager menu) {
        MenuManager newMenuManager = new MenuManager(ResourceHandler.UI_New);
        menu.add((IContributionItem)newMenuManager);
        menu.add((IContributionItem)new Separator("additions"));
        List selection = ((StructuredSelection)this.getContext().getSelection()).toList();
        if (selection.size() == 1 && this.isContextSensitiveSubnode(selection.get(0))) {
            IPageDataNode selectedNode = (IPageDataNode)selection.get(0);
            String className = selectedNode.getClass().getName();
            List contextActions = NewActionsRegistryReader.getSingleton().getActionsForNode(className);
            int i = 0;
            while (i < contextActions.size()) {
                newMenuManager.add((IAction)new ProxyAction((IConfigurationElement)contextActions.get(i)));
                ++i;
            }
        } else {
            ArrayList<String> categoryIDs = new ArrayList<String>();
            int i = 0;
            while (i < selection.size()) {
                Object selectedObject = selection.get(i);
                if (selectedObject instanceof CategoryDefinition) {
                    String categoryID = ((CategoryDefinition)selectedObject).getCategoryID();
                    if (!categoryIDs.contains(categoryID)) {
                        categoryIDs.add(categoryID);
                    }
                } else if (selectedObject instanceof IPageDataNode) {
                    IPageDataNode node = (IPageDataNode)selectedObject;
                    while (!PageDataModelUtil.isComponentNode((IPageDataNode)node)) {
                        node = node.getParent();
                    }
                    String categoryID = node.getCategory();
                    if (categoryID != null && !categoryID.equals("") && !categoryIDs.contains(categoryID)) {
                        categoryIDs.add(categoryID);
                    }
                }
                ++i;
            }
            i = 0;
            while (i < categoryIDs.size()) {
                List actionsForCategory = NewActionsRegistryReader.getActionsForCategory((String)categoryIDs.get(i));
                List visibleActions = this.determineVisibleActions(actionsForCategory);
                if (!visibleActions.isEmpty()) {
                    int j = 0;
                    while (j < visibleActions.size()) {
                        IConfigurationElement visibleAction = (IConfigurationElement)visibleActions.get(j);
                        String isOnNewMenu = visibleAction.getAttribute(NEW_MENU);
                        if (isOnNewMenu != null && !Boolean.valueOf(isOnNewMenu).booleanValue()) {
                            if (selection.size() == 1 && selection.get(0) instanceof CategoryDefinition) {
                                menu.add((IAction)new ProxyAction(visibleAction));
                            }
                        } else {
                            newMenuManager.add((IAction)new ProxyAction(visibleAction));
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        newMenuManager.add((IContributionItem)new Separator("additions"));
        newMenuManager.add((IAction)this.otherAction);
    }

    private boolean isContextSensitiveSubnode(Object selectedNode) {
        if (selectedNode instanceof IPageDataNode) {
            String className = selectedNode.getClass().getName();
            return NewActionsRegistryReader.getSingleton().isContextSensitive(className);
        }
        return false;
    }

    private List determineVisibleActions(Collection actionsForCategory) {
        ArrayList<IConfigurationElement> visibleActions = new ArrayList<IConfigurationElement>();
        String[] pageTypes = this.helper.getPageTypes((short)0);
        Collection actionsForPageTypes = NewActionsRegistryReader.getNewActions(pageTypes).values();
        ArrayList actionsForPageTypesList = new ArrayList();
        for (List actionList : actionsForPageTypes) {
            actionsForPageTypesList.addAll(actionList);
        }
        if (actionsForCategory != null) {
            for (IConfigurationElement actionElement : actionsForCategory) {
                if (!NewActionsVisiblityRulesRegistryReader.getSingleton().isActionVisible(actionElement, actionsForPageTypesList, this.helper.getPageDataModel())) continue;
                visibleActions.add(actionElement);
            }
        }
        return visibleActions;
    }

    public void dispose() {
        super.dispose();
        this.otherAction = null;
        this.helper = null;
    }

    private class OtherAction
    extends NewPageDataAction {
        public OtherAction(PageTypeHelper helper) {
            super(helper);
            this.setText(ResourceHandler.UI_Other);
        }
    }
}

