/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.ui.internal;

import com.ibm.etools.webedit.common.utils.ActionUtil;
import com.ibm.etools.webedit.extension.DropTargetObject;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModelLifeCycleListener;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.IBindingAttribute;
import com.ibm.etools.webtools.pagedatamodel.util.PageDataModelListenersDispatcher;
import com.ibm.etools.webtools.pagedataview.PageDataViewPlugin;
import com.ibm.etools.webtools.pagedataview.PageDataViewRegistryReader;
import com.ibm.etools.webtools.pagedataview.ui.IPageDataNodeUIAttribute;
import com.ibm.etools.webtools.pagedataview.ui.dnd.InsertHelper;
import com.ibm.etools.webtools.pagedataview.ui.dnd.internal.WorkUnit;
import com.ibm.etools.webtools.pagedataview.ui.nls.ResourceHandler;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;

public class InsertActionDelegate
implements IActionDelegate,
IPageDataModelLifeCycleListener {
    private IPageDataNode[] selectedObjects;
    private InsertHelper insertHelper;

    private InsertHelper getInsertHelper() {
        if (this.insertHelper == null) {
            this.insertHelper = new InsertHelper();
        }
        return this.insertHelper;
    }

    public void run(IAction action) {
        IEditorPart editor = ActionUtil.getActiveEditorPart();
        this.getInsertHelper().performInsert(this.selectedObjects, editor);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            List pdNodes = ((IStructuredSelection)selection).toList();
            this.selectedObjects = pdNodes.toArray(new IPageDataNode[0]);
            PageDataModelListenersDispatcher.addPageDataModelListener((IPageDataModelLifeCycleListener)this);
            Map transferTypes = PageDataViewRegistryReader.getDragTransferTypes();
            int i = 0;
            while (i < this.selectedObjects.length) {
                IPageDataNodeUIAttribute uiAtt = (IPageDataNodeUIAttribute)this.selectedObjects[i].getAdapter(IPageDataNodeUIAttribute.class);
                Object bindingAttributeAdapter = this.selectedObjects[i].getAdapter(IBindingAttribute.ADAPTER_KEY);
                if (!transferTypes.containsKey(uiAtt.getDNDTransferID()) || bindingAttributeAdapter == null) {
                    action.setText(ResourceHandler.UI_Insert);
                    action.setEnabled(false);
                    return;
                }
                ++i;
            }
            this.getInsertHelper().getDropTargetObject(this.selectedObjects, ActionUtil.getActiveEditorPart());
            List workUnits = PageDataViewPlugin.getDefault().getWorkUnits();
            int op = 0;
            WorkUnit firstUnit = null;
            if (workUnits != null && workUnits.size() > 0 && (firstUnit = (WorkUnit)workUnits.get(0)).getConfig() != null) {
                op = firstUnit.getConfig().dropOperation;
            }
            if (op == 1) {
                action.setEnabled(true);
                String ctrlName = null;
                ctrlName = this.selectedObjects.length > 1 ? ResourceHandler.UI_Selected_Objects : "\"" + this.insertHelper.getDropObjectName(this.selectedObjects[0]) + "\"";
                action.setText(String.valueOf(ResourceHandler.UI_Insert_New_Ctrls) + " " + ctrlName);
            } else if (op == 2) {
                if (this.selectedObjects.length > 1) {
                    action.setEnabled(false);
                    action.setText(ResourceHandler.UI_Insert);
                } else {
                    action.setEnabled(true);
                    ElementImpl xmlNode = null;
                    DropTargetObject dropTarget = firstUnit.getConfig().dropTarget;
                    if (dropTarget.getNodeList() != null) {
                        xmlNode = (ElementImpl)dropTarget.getNodeList().item(0);
                    } else if (dropTarget.getRange() != null) {
                        xmlNode = (ElementImpl)dropTarget.getRange().getEndContainer();
                    }
                    if (xmlNode != null) {
                        String controlID = xmlNode.getAttribute("id");
                        controlID = controlID == null ? ResourceHandler.UI_Ctrl : "'" + controlID + "'";
                        action.setText(String.valueOf(ResourceHandler.UI_BindTo) + " " + controlID);
                    } else {
                        action.setEnabled(false);
                        action.setText(ResourceHandler.UI_Insert);
                    }
                }
            } else {
                action.setEnabled(false);
                action.setText(ResourceHandler.UI_Insert);
            }
        } else {
            this.selectedObjects = null;
            this.insertHelper = null;
            PageDataModelListenersDispatcher.removePageDataModelListener((IPageDataModelLifeCycleListener)this);
        }
    }

    public void pageDataModelToBeInitialized(IPageDataModel model) {
    }

    public void pageDataModelToBeReleased(IPageDataModel model) {
        if (this.selectedObjects != null && this.selectedObjects[0].getPageDataModel() == model) {
            this.selectedObjects = null;
            this.insertHelper = null;
            PageDataModelListenersDispatcher.removePageDataModelListener((IPageDataModelLifeCycleListener)this);
        }
    }

    public void pageDataModelInitialized(IPageDataModel model) {
    }

    public void pageDataModelReleased() {
    }
}

