/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.ui.internal;

import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModelLifeCycleListener;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.util.PageDataModelListenersDispatcher;
import com.ibm.etools.webtools.pagedatamodel.util.PageDataModelUtil;
import com.ibm.etools.webtools.pagedataview.ui.internal.IActionDelegateAdapter;
import com.ibm.etools.webtools.pagedataview.util.ModelUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate;

public class ConfigureActionDelegate
implements IActionDelegate,
IPageDataModelLifeCycleListener {
    private IPageDataNode selectedObject;

    public void run(IAction action) {
        if (this.selectedObject != null) {
            boolean executed = false;
            IActionDelegateAdapter adapter = (IActionDelegateAdapter)this.selectedObject.getAdapter(IActionDelegateAdapter.ADAPTER_KEY);
            if (adapter != null) {
                executed = adapter.handleAction(this.selectedObject, 1);
            }
            if (!executed) {
                ModelUtil.configurePageData(this.selectedObject);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            if (((IStructuredSelection)selection).size() > 1) {
                action.setEnabled(false);
            } else {
                Object object = ((IStructuredSelection)selection).getFirstElement();
                if (object instanceof IPageDataNode) {
                    this.selectedObject = (IPageDataNode)object;
                    PageDataModelListenersDispatcher.addPageDataModelListener((IPageDataModelLifeCycleListener)this);
                    IActionDelegateAdapter adapter = (IActionDelegateAdapter)this.selectedObject.getAdapter(IActionDelegateAdapter.ADAPTER_KEY);
                    if (adapter != null) {
                        boolean canHandle = false;
                        canHandle = adapter.canHandleAction(this.selectedObject, 1);
                        action.setEnabled(canHandle);
                    } else if (PageDataModelUtil.isComponentNode((IPageDataNode)this.selectedObject)) {
                        action.setEnabled(true);
                    } else {
                        action.setEnabled(false);
                    }
                } else {
                    this.selectedObject = null;
                    PageDataModelListenersDispatcher.removePageDataModelListener((IPageDataModelLifeCycleListener)this);
                }
            }
        }
    }

    public void pageDataModelInitialized(IPageDataModel model) {
    }

    public void pageDataModelReleased() {
    }

    public void pageDataModelToBeInitialized(IPageDataModel model) {
    }

    public void pageDataModelToBeReleased(IPageDataModel model) {
        if (this.selectedObject != null && this.selectedObject.getPageDataModel() == model) {
            this.selectedObject = null;
            PageDataModelListenersDispatcher.removePageDataModelListener((IPageDataModelLifeCycleListener)this);
        }
    }
}

