/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.ui.internal;

import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.impl.PageDataNode;
import com.ibm.etools.webtools.pagedatamodel.impl.PageDataNodeProvidersRegistryReader;
import com.ibm.etools.webtools.pagedataview.PageDataViewPlugin;
import com.ibm.etools.webtools.pagedataview.ui.IPageDataNodeUIAttribute;
import com.ibm.etools.webtools.pagedataview.ui.internal.CategoryNodeInitializer;
import java.util.Map;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class CategoryNode
extends PageDataNode {
    String categoryDescription;
    String categoryLabel;
    Image icon;
    private IPageDataNodeUIAttribute uiAttr;

    private CategoryNode(IPageDataModel model, IPageDataNode parent) {
        super(model, parent);
    }

    public static CategoryNode create(IPageDataModel model, String categoryId) {
        CategoryNode newCategory = new CategoryNode(model, null);
        newCategory.setCategory(categoryId);
        Map categories = PageDataNodeProvidersRegistryReader.getCategories();
        PageDataNodeProvidersRegistryReader.Category cat = (PageDataNodeProvidersRegistryReader.Category)categories.get(categoryId);
        if (cat != null) {
            newCategory.setCategoryLabel(((PageDataNodeProvidersRegistryReader.Category)categories.get((Object)categoryId)).label);
            Image icon = PageDataViewPlugin.getDefault().getImage(((PageDataNodeProvidersRegistryReader.Category)categories.get((Object)categoryId)).urlToIcon);
            newCategory.setCategoryIcon(icon);
        } else {
            CategoryNodeInitializer.initialize(newCategory);
        }
        return newCategory;
    }

    public boolean refresh(IDOMNode associatedNode, Object changedFeature, Object oldValue, Object newValue) {
        return false;
    }

    public Object getAdapter(Class key) {
        if (key == IPageDataNodeUIAttribute.ADAPTER_KEY) {
            if (this.uiAttr == null) {
                this.uiAttr = new CategoryNodeUIAttribute();
            }
            return this.uiAttr;
        }
        return super.getAdapter(key);
    }

    public void setCategoryLabel(String string) {
        this.categoryLabel = string;
    }

    public void removeChildWithoutNotification(IPageDataNode child) {
        this.getChildren().remove((Object)child);
    }

    public void setCategoryIcon(Image image) {
        this.icon = image;
    }

    public IPageDataNode copy() {
        return null;
    }

    public class CategoryNodeUIAttribute
    implements IPageDataNodeUIAttribute {
        @Override
        public boolean expandOnAdd(IPageDataNode node) {
            return true;
        }

        @Override
        public String getDescription(IPageDataNode node) {
            return CategoryNode.this.categoryDescription;
        }

        @Override
        public String getDNDTransferID() {
            return null;
        }

        @Override
        public Image getIcon(IPageDataNode node) {
            return CategoryNode.this.icon;
        }

        @Override
        public String getLabel(IPageDataNode node) {
            return CategoryNode.this.categoryLabel;
        }
    }
}

