/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.ui.internal;

import com.ibm.etools.webtools.pagedatamodel.api.IPageDataChangeListener;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.impl.internal.RootPageDataNode;
import com.ibm.etools.webtools.pagedataview.ui.IPageDataNodeUIAttribute;
import com.ibm.etools.webtools.pagedataview.ui.categories.internal.CategoryDefinition;
import com.ibm.etools.webtools.pagedataview.ui.categories.internal.CategoryRegistryReader;
import com.ibm.etools.webtools.pagedataview.ui.internal.DataCategoryFilter;
import com.ibm.etools.webtools.pagedataview.ui.internal.NonUINodeFilter;
import com.ibm.etools.webtools.pagedataview.ui.internal.PageDataViewSorter;
import com.ibm.etools.webtools.pagedataview.ui.nls.ResourceHandler;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class BeanPropertySelection
implements IPageDataChangeListener {
    Composite base;
    IPageDataModel model;
    TreeViewer wtBeanPropViewer;
    Tree beanPropTree;
    String[] dataCategories;

    public BeanPropertySelection(Composite base, IPageDataModel model) {
        this.base = base;
        this.model = model;
        this.createTreeViewer();
    }

    public BeanPropertySelection(Composite base, IPageDataModel model, String[] categories) {
        this.base = base;
        this.model = model;
        this.dataCategories = categories;
        this.createTreeViewer();
    }

    protected void createTreeViewer() {
        this.beanPropTree = new Tree(this.base, 2052);
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.minimumHeight = 300;
        data.minimumWidth = 450;
        this.beanPropTree.setLayoutData((Object)data);
        this.wtBeanPropViewer = new TreeViewer(this.beanPropTree);
        this.wtBeanPropViewer.setContentProvider((IContentProvider)new PageDataBeanPropertyProvider());
        this.wtBeanPropViewer.setLabelProvider((IBaseLabelProvider)new PageDataBeanPropertyLabelProvider());
        this.wtBeanPropViewer.setInput((Object)this.model);
        this.wtBeanPropViewer.setSorter((ViewerSorter)new PageDataViewSorter());
    }

    public Tree getTree() {
        return this.beanPropTree;
    }

    public TreeViewer getTreeViewer() {
        return this.wtBeanPropViewer;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.wtBeanPropViewer.addSelectionChangedListener(listener);
    }

    public void addDoubleClickListener(IDoubleClickListener listener) {
        this.wtBeanPropViewer.addDoubleClickListener(listener);
    }

    public void nodeChanged(IPageDataNode originalNode, IPageDataNode changedNode) {
        if (this.isViewerReady(this.wtBeanPropViewer)) {
            final IPageDataNode nodeToRefresh = changedNode;
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    BeanPropertySelection.this.wtBeanPropViewer.refresh((Object)nodeToRefresh);
                }
            });
        }
    }

    public void refreshTree() {
        if (this.isViewerReady(this.wtBeanPropViewer)) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TreeItem[] ti;
                    BeanPropertySelection.this.wtBeanPropViewer.refresh();
                    TreeItem[] treeItems = BeanPropertySelection.this.getTree().getItems();
                    if (treeItems.length > 0 && (ti = new TreeItem[]{treeItems[0]})[0] != null && BeanPropertySelection.this.getTree() != null) {
                        BeanPropertySelection.this.wtBeanPropViewer.setSelection((ISelection)new StructuredSelection(BeanPropertySelection.this.getTree().getItem(0).getData()));
                    }
                }
            });
        }
    }

    public void nodeAdded(IPageDataNode parent, IPageDataNode addedChild) {
        final IPageDataNode changedNode = parent;
        if (this.isViewerReady(this.wtBeanPropViewer)) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (changedNode instanceof RootPageDataNode) {
                        BeanPropertySelection.this.wtBeanPropViewer.refresh();
                    } else {
                        BeanPropertySelection.this.wtBeanPropViewer.refresh((Object)changedNode);
                    }
                }
            });
        }
    }

    public void nodeRemoved(IPageDataNode parent, IPageDataNode removedChild) {
    }

    private boolean isViewerReady(TreeViewer viewer) {
        return viewer != null && viewer.getControl() != null && !viewer.getControl().isDisposed();
    }

    public void setDataCategories(String[] strings) {
        this.dataCategories = strings;
    }

    private final class PageDataBeanPropertyLabelProvider
    implements ILabelProvider {
        private PageDataBeanPropertyLabelProvider() {
        }

        public Image getImage(Object element) {
            IPageDataNode node;
            IPageDataNodeUIAttribute uiNode;
            if (element instanceof IPageDataNode && (uiNode = (IPageDataNodeUIAttribute)(node = (IPageDataNode)element).getAdapter(IPageDataNodeUIAttribute.ADAPTER_KEY)) != null) {
                return uiNode.getIcon(node);
            }
            return null;
        }

        public String getText(Object element) {
            IPageDataNode node;
            IPageDataNodeUIAttribute uiNode;
            if (element instanceof IPageDataNode && (uiNode = (IPageDataNodeUIAttribute)(node = (IPageDataNode)element).getAdapter(IPageDataNodeUIAttribute.ADAPTER_KEY)) != null) {
                return uiNode.getLabel(node);
            }
            return ResourceHandler.UI_Null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private final class PageDataBeanPropertyProvider
    implements ITreeContentProvider {
        private PageDataBeanPropertyProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            IPageDataNode node;
            EList list;
            if (parentElement instanceof IPageDataNode && (list = (node = (IPageDataNode)parentElement).getChildren()) != null) {
                IPageDataNode[] ret = list.toArray(new IPageDataNode[list.size()]);
                return new NonUINodeFilter().filter(ret);
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IPageDataNode) {
                return ((IPageDataNode)element).hasChildren();
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            IPageDataModel model;
            Object list;
            if (inputElement instanceof IPageDataModel && (list = (model = (IPageDataModel)inputElement).getRoot().getChildren()) != null) {
                list = this.removeNonVisibleCategoryNodes((List)list);
                Object[] ret = list.toArray(new IPageDataNode[list.size()]);
                ret = new NonUINodeFilter().filter((IPageDataNode[])ret);
                if (BeanPropertySelection.this.dataCategories != null) {
                    ret = new DataCategoryFilter(BeanPropertySelection.this.dataCategories).filter((IPageDataNode[])ret);
                }
                return ret;
            }
            return new Object[0];
        }

        private List removeNonVisibleCategoryNodes(List list) {
            ArrayList<IPageDataNode> visibleNodes = new ArrayList<IPageDataNode>();
            int i = 0;
            while (i < list.size()) {
                IPageDataNode node = (IPageDataNode)list.get(i);
                String category = node.getCategory();
                if (category == null) {
                    visibleNodes.add(node);
                } else {
                    CategoryDefinition categoryDef = CategoryRegistryReader.getSingleton().getCategory(category);
                    if (categoryDef != null && CategoryRegistryReader.getSingleton().isCategoryVisible(categoryDef, node.getPageDataModel())) {
                        visibleNodes.add(node);
                    }
                }
                ++i;
            }
            return visibleNodes;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

