/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.ui.dnd.internal;

import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedataview.ui.dnd.DropTargetConfig;
import com.ibm.etools.webtools.pagedataview.ui.dnd.IDropActionMediator;
import java.util.ArrayList;
import java.util.List;

public class WorkUnit {
    private IPageDataNode parentNode;
    private List subUnits;
    private IDropActionMediator mediator;
    private DropTargetConfig config;

    public WorkUnit(IPageDataNode parent) {
        this.parentNode = parent;
    }

    public WorkUnit(IPageDataNode parent, IPageDataNode subUnit) {
        this.parentNode = parent;
        this.addSubUnit(subUnit);
    }

    public WorkUnit(IPageDataNode[] subUnits) {
        if (subUnits != null && subUnits.length > 0) {
            int i = 0;
            int size = subUnits.length;
            while (i < size) {
                this.addSubUnit(subUnits[i]);
                ++i;
            }
        }
    }

    public boolean isSameParent(IPageDataNode parent) {
        return this.parentNode == parent;
    }

    public void addSubUnit(IPageDataNode subUnit) {
        if (subUnit != null) {
            if (this.subUnits == null) {
                this.subUnits = new ArrayList(1);
            }
            this.subUnits.add(subUnit);
        }
    }

    public boolean isConfigured() {
        return this.mediator != null && this.config != null;
    }

    public IPageDataNode[] getSubUnits() {
        return this.subUnits.toArray(new IPageDataNode[0]);
    }

    public IDropActionMediator getMediator() {
        return this.mediator;
    }

    public DropTargetConfig getConfig() {
        return this.config;
    }

    public void setMediator(IDropActionMediator mediator) {
        this.mediator = mediator;
    }

    public void setConfig(DropTargetConfig config) {
        this.config = config;
    }
}

