/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.ui.dnd;

import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webedit.common.commands.utils.EditModelQuery;
import com.ibm.etools.webedit.common.commands.utils.EditQueryUtil;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.common.utils.ActionUtil;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.sse.api.ISSEPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.util.PageDataModelUtil;
import com.ibm.etools.webtools.pagedataview.ui.dnd.DropActionConfig;
import com.ibm.etools.webtools.pagedataview.ui.dnd.internal.WorkUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.gef.commands.Command;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;
import org.w3c.dom.ranges.Range;

public class DropActionHelper {
    public static final int INIT_OP = -999;
    public static final short USE_SMART_GROUPING = 1;
    public static final short USE_NO_SMART_GROUPING = 2;
    public static final short IGNORE_SMART_GROUPING = 0;

    protected static void executeCommand(DropActionConfig config, String key) {
        HTMLCommand command;
        Map props;
        if (config != null && (props = config.getCustomProperties()) != null && !props.isEmpty() && (command = (HTMLCommand)props.get(key)) != null) {
            HTMLEditDomain domain = ActionUtil.getActiveHTMLEditDomain();
            domain.execCommand((Command)command);
        }
    }

    protected static boolean findBody(Range range) {
        Node start = range.getStartContainer();
        EditModelQuery query = EditQueryUtil.getEditQuery((Node)start);
        Node rootNode = query.getRenderRootNode(start, false);
        return rootNode != null;
    }

    protected static Collection splitDataComponents(IPageDataNode[] dropObjects) {
        HashMap<IPageDataNode, WorkUnit> workUnits = new HashMap<IPageDataNode, WorkUnit>(1);
        int i = 0;
        while (i < dropObjects.length) {
            IPageDataNode comp = dropObjects[i];
            while (!PageDataModelUtil.isComponentNode((IPageDataNode)comp)) {
                comp = comp.getParent();
            }
            if (workUnits.containsKey(comp)) {
                ((WorkUnit)workUnits.get(comp)).addSubUnit(dropObjects[i]);
            } else {
                workUnits.put(comp, new WorkUnit(dropObjects[i].getParent(), dropObjects[i]));
            }
            ++i;
        }
        return workUnits.values();
    }

    protected static List organizeForSmartGrouping(IPageDataNode[] dropObjects) {
        ArrayList<WorkUnit> workUnits = new ArrayList<WorkUnit>(1);
        ArrayList<IPageDataNode> parentNodes = new ArrayList<IPageDataNode>(1);
        int i = 0;
        int length = dropObjects.length;
        while (i < length) {
            IPageDataNode object = dropObjects[i];
            if (PageDataModelUtil.isComponentNode((IPageDataNode)object)) {
                workUnits.add(new WorkUnit(object.getParent(), object));
                parentNodes.add(object);
            } else {
                boolean match = false;
                int j = 0;
                int size = parentNodes.size();
                while (j < size) {
                    IPageDataNode existingParent = (IPageDataNode)parentNodes.get(j);
                    if (existingParent != null) {
                        IPageDataNode parent = object.getParent();
                        while (parent != null) {
                            if (parent == existingParent) {
                                match = true;
                                break;
                            }
                            parent = parent.getParent();
                        }
                        if (match) break;
                    }
                    ++j;
                }
                if (!match) {
                    boolean existing = false;
                    int j2 = 0;
                    int size2 = workUnits.size();
                    while (j2 < size2) {
                        WorkUnit workUnit = (WorkUnit)workUnits.get(j2);
                        if (workUnit.isSameParent(object.getParent())) {
                            workUnit.addSubUnit(object);
                            existing = true;
                        }
                        ++j2;
                    }
                    if (!existing) {
                        workUnits.add(new WorkUnit(object.getParent(), object));
                        parentNodes.add(object);
                    }
                }
            }
            ++i;
        }
        Comparator comp = new Comparator(){

            public int compare(Object o1, Object o2) {
                WorkUnit unit1 = (WorkUnit)o1;
                WorkUnit unit2 = (WorkUnit)o2;
                IDOMNode xml1 = null;
                if (unit1.getSubUnits()[0] instanceof ISSEPageDataNode) {
                    xml1 = ((ISSEPageDataNode)unit1.getSubUnits()[0]).getDOMNode();
                }
                IDOMNode xml2 = null;
                if (unit2.getSubUnits()[0] instanceof ISSEPageDataNode) {
                    xml2 = ((ISSEPageDataNode)unit2.getSubUnits()[0]).getDOMNode();
                }
                if (xml1 == null && xml2 == null) {
                    return 0;
                }
                if (xml1 == null) {
                    return -1;
                }
                if (xml2 == null) {
                    return 1;
                }
                return xml1.getStartOffset() - xml2.getStartOffset();
            }
        };
        Collections.sort(workUnits, comp);
        return workUnits;
    }

    protected static boolean validateWorkUnits(List workUnits) {
        boolean valid = true;
        short currentOp = -999;
        int i = 0;
        while (i < workUnits.size()) {
            WorkUnit oneUnit = (WorkUnit)workUnits.get(i);
            if (oneUnit != null && oneUnit.isConfigured()) {
                short op = oneUnit.getConfig().dropOperation;
                if (currentOp == -999 && op != 0) {
                    currentOp = op;
                } else if (currentOp != op && op != 0) {
                    valid = false;
                }
            }
            ++i;
        }
        return valid;
    }

    protected static boolean containsProhibitWorkUnit(List workUnits) {
        int i = 0;
        while (i < workUnits.size()) {
            short op;
            WorkUnit oneUnit = (WorkUnit)workUnits.get(i);
            if (oneUnit != null && oneUnit.isConfigured() && (op = oneUnit.getConfig().dropOperation) == 3) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

