/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.ui.categories.internal;

import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.impl.PageActionNode;
import com.ibm.etools.webtools.pagedataview.PageDataViewPlugin;
import com.ibm.etools.webtools.pagedataview.ui.IPageDataNodeUIAttribute;
import com.ibm.etools.webtools.pagedataview.ui.categories.internal.CategoryDefinition;
import com.ibm.etools.webtools.pagedataview.ui.internal.CategoryNodeList;
import com.ibm.etools.webtools.pagedataview.ui.internal.PageTypeHelper;
import com.ibm.etools.webtools.pagedataview.ui.internal.VisibilityRule;
import com.ibm.etools.webtools.pagedataview.ui.internal.VisibilityRulesUtil;
import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;

public class CategoryRegistryReader {
    private static CategoryRegistryReader singleton;
    private boolean parsed = false;
    private Map<String, CategoryDefinition> categoriesMap;
    private static final String CAT_EXTENSION_PT_ID = "category";
    private static final String VIS_RULES_EXTENSION_PT_ID = "visibilityRules";
    private static final String ELEM_DESC = "description";
    private static final String ATT_ICON = "icon";
    private static final String ATT_SHOW_WHEN_EMPTY = "showWhenEmpty";
    private static final String ELEM_RULES = "rules";
    private static final String ELEM_FACET = "facet";
    private static final String ATT_NAME = "name";
    private static final String ATT_SORT_ORDER = "sortOrder";
    private static final String ATTR_PT = "pageType";
    private static final String ELEM_OR = "or";
    private static final String ATTR_PARENT = "parent";

    public static CategoryRegistryReader getSingleton() {
        if (singleton == null) {
            singleton = new CategoryRegistryReader();
        }
        return singleton;
    }

    public CategoryNodeList getVisibleCategories(IPageDataModel pageDataModel) {
        if (!this.parsed) {
            CategoryRegistryReader.getSingleton().parseCategories();
        }
        return this.determineVisibleCategories(pageDataModel.getResource().getProject(), pageDataModel, true);
    }

    public boolean isCategoryVisible(CategoryDefinition category, IPageDataModel pageDataModel) {
        PageTypeHelper helper = new PageTypeHelper(pageDataModel);
        IProject proj = pageDataModel.getResource().getProject();
        String[] availablePageTypes = helper.getPageTypes((short)0);
        boolean isCategoryVisible = true;
        if (category.getVisiblityRules() != null) {
            for (Object next : category.getVisiblityRules()) {
                List orList;
                boolean orListSatisfied;
                if (next instanceof VisibilityRule) {
                    VisibilityRule rule = (VisibilityRule)next;
                    boolean shouldExist = rule.isShouldExist();
                    String facetID = rule.getFacetID();
                    String facetVersion = rule.getFacetVersion();
                    if (facetVersion == "") {
                        facetVersion = null;
                    }
                    if (VisibilityRulesUtil.projectHasFacet(proj, facetID, facetVersion) == shouldExist) continue;
                    isCategoryVisible = false;
                    break;
                }
                if (!(next instanceof List) || (orListSatisfied = VisibilityRulesUtil.processOrList(orList = (List)next, proj))) continue;
                isCategoryVisible = false;
                break;
            }
        }
        if (isCategoryVisible && category.getPageTypes() != null) {
            isCategoryVisible = false;
            List visiblePageTypes = category.getPageTypes();
            int i = 0;
            while (i < visiblePageTypes.size()) {
                String visiblePageType = (String)visiblePageTypes.get(i);
                int j = 0;
                while (j < availablePageTypes.length) {
                    if (visiblePageType.equals(availablePageTypes[j])) {
                        isCategoryVisible = true;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return isCategoryVisible;
    }

    public CategoryNodeList getPotentiallyVisibleCategories(IPageDataModel pageDataModel) {
        if (!this.parsed) {
            CategoryRegistryReader.getSingleton().parseCategories();
        }
        return this.determineVisibleCategories(pageDataModel.getResource().getProject(), pageDataModel, false);
    }

    public CategoryDefinition getCategory(String categoryID) {
        CategoryDefinition category;
        if (!this.parsed) {
            CategoryRegistryReader.getSingleton().parseCategories();
        }
        if ((category = this.categoriesMap.get(categoryID)) == null) {
            category = this.searchCategories(categoryID, this.categoriesMap.values());
        }
        return category;
    }

    private CategoryDefinition searchCategories(String categoryID, Collection<CategoryDefinition> categories) {
        CategoryDefinition category = null;
        Iterator<CategoryDefinition> iter = categories.iterator();
        while (iter.hasNext() && category == null) {
            CategoryDefinition cd = iter.next();
            if (cd.getCategoryID().equals(categoryID)) {
                category = cd;
                continue;
            }
            if (cd.getChildren() == null) continue;
            category = this.searchCategories(categoryID, cd.getChildren());
        }
        return category;
    }

    private void parseCategories() {
        String pluginId = PageDataViewPlugin.getDefault().getBundle().getSymbolicName();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(pluginId, CAT_EXTENSION_PT_ID);
        IExtension[] extensions = point.getExtensions();
        this.categoriesMap = new HashMap<String, CategoryDefinition>();
        ArrayList<CategoryDefinition> subCategories = null;
        int i = 0;
        while (i < extensions.length) {
            CategoryDefinition cd = new CategoryDefinition();
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                IConfigurationElement element = configElements[j];
                if (ELEM_DESC.equals(element.getName())) {
                    String parent;
                    cd.setCategoryID(element.getAttribute("id"));
                    cd.setExtendingPluginID(extensions[i].getContributor().getName());
                    cd.setIconFilePath(element.getAttribute(ATT_ICON));
                    cd.setShowWhenEmpty(Boolean.valueOf(element.getAttribute(ATT_SHOW_WHEN_EMPTY)));
                    cd.setName(element.getAttribute(ATT_NAME));
                    String sortOrder = element.getAttribute(ATT_SORT_ORDER);
                    if (sortOrder == null) {
                        cd.setSortOrder(-1);
                    } else {
                        cd.setSortOrder(Integer.parseInt(sortOrder));
                    }
                    String pageTypesString = element.getAttribute(ATTR_PT);
                    if (pageTypesString != null) {
                        ArrayList<String> pageTypes = new ArrayList<String>();
                        StringTokenizer tkzr = new StringTokenizer(pageTypesString, ",");
                        while (tkzr != null && tkzr.hasMoreTokens()) {
                            String oneType = tkzr.nextToken().trim();
                            if (oneType == null) continue;
                            pageTypes.add(oneType);
                        }
                        cd.setPageTypes(pageTypes);
                    }
                    if ((parent = element.getAttribute(ATTR_PARENT)) != null) {
                        if (subCategories == null) {
                            subCategories = new ArrayList<CategoryDefinition>();
                        }
                        subCategories.add(cd);
                        cd.setParentID(parent);
                    }
                }
                ++j;
            }
            this.categoriesMap.put(cd.getCategoryID(), cd);
            ++i;
        }
        if (subCategories != null) {
            this.placeSubCategories(subCategories);
        }
        this.parseVisibilityRules();
        this.parsed = true;
    }

    private void placeSubCategories(List<CategoryDefinition> subCategories) {
        ArrayList<CategoryDefinition> orphans = null;
        ArrayList<String> subCategoryIDs = new ArrayList<String>();
        for (CategoryDefinition cd : subCategories) {
            String parentID = cd.getParentID();
            CategoryDefinition parent = this.categoriesMap.get(parentID);
            if (parent != null) {
                parent.addChild(cd);
                subCategoryIDs.add(cd.getCategoryID());
                continue;
            }
            if (orphans == null) {
                orphans = new ArrayList<CategoryDefinition>();
            }
            orphans.add(cd);
        }
        if (orphans != null) {
            for (CategoryDefinition orphan : orphans) {
                this.categoriesMap.remove(orphan.getCategoryID());
                PageDataViewPlugin.getDefault().write("Could not add Page Data View Category: " + orphan.getCategoryID() + ". Could not find parent " + orphan.getParentID());
            }
        }
        int i = 0;
        while (i < subCategoryIDs.size()) {
            this.categoriesMap.remove(subCategoryIDs.get(i));
            ++i;
        }
    }

    private void parseVisibilityRules() {
        String pluginId = PageDataViewPlugin.getDefault().getBundle().getSymbolicName();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(pluginId, VIS_RULES_EXTENSION_PT_ID);
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            String categoryID = null;
            ArrayList<VisibilityRule> visibilityRules = null;
            int j = 0;
            while (j < configElements.length) {
                IConfigurationElement element = configElements[j];
                if (CAT_EXTENSION_PT_ID.equals(element.getName())) {
                    categoryID = element.getAttribute("id");
                    CategoryDefinition cd = this.categoriesMap.get(categoryID);
                    if (cd == null) {
                        PageDataViewPlugin.getDefault().write("Category not found while parsing visibilityRules: " + categoryID);
                    } else {
                        if (cd.getVisiblityRules() == null) {
                            visibilityRules = new ArrayList<VisibilityRule>();
                            cd.setVisiblityRules(visibilityRules);
                        } else {
                            visibilityRules = cd.getVisiblityRules();
                        }
                        IConfigurationElement rulesElement = element.getChildren(ELEM_RULES)[0];
                        IConfigurationElement[] facets = rulesElement.getChildren(ELEM_FACET);
                        int k = 0;
                        while (k < facets.length) {
                            VisibilityRule rule = VisibilityRulesUtil.createVisibilityRule(facets[k]);
                            visibilityRules.add(rule);
                            ++k;
                        }
                        IConfigurationElement[] orGroups = rulesElement.getChildren(ELEM_OR);
                        if (orGroups != null && orGroups.length > 0) {
                            VisibilityRulesUtil.addOrGroups(visibilityRules, orGroups);
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private CategoryNodeList determineVisibleCategories(IProject proj, IPageDataModel pageDataModel, boolean considerShowWhenEmpty) {
        Iterator<CategoryDefinition> allCategories = this.categoriesMap.values().iterator();
        CategoryNodeList visibleCategories = new CategoryNodeList(0);
        while (allCategories.hasNext()) {
            CategoryDefinition category = allCategories.next();
            boolean isCategoryVisible = this.isCategoryVisible(category, pageDataModel);
            if (!isCategoryVisible) continue;
            if (!category.isShowWhenEmpty() && considerShowWhenEmpty) {
                if (category.getCategoryID().equals("Other") && this.shouldShowOtherCategory(pageDataModel)) {
                    visibleCategories.add(category);
                    continue;
                }
                if (!this.modelContainsNodeOfCategory(pageDataModel, category)) continue;
                visibleCategories.add(category);
                continue;
            }
            visibleCategories.add(category);
        }
        return visibleCategories;
    }

    private boolean modelContainsNodeOfCategory(IPageDataModel model, CategoryDefinition category) {
        String categoryID = category.getCategoryID();
        EList nodes = model.getRoot().getChildren();
        boolean found = false;
        int i = 0;
        while (i < nodes.size()) {
            IPageDataNode node = (IPageDataNode)nodes.get(i);
            if (categoryID.equals(node.getCategory())) {
                found = true;
                break;
            }
            ++i;
        }
        return found;
    }

    private boolean shouldShowOtherCategory(IPageDataModel model) {
        boolean showOther = false;
        EList nodes = model.getRoot().getChildren();
        int i = 0;
        while (i < nodes.size()) {
            IPageDataNode node = (IPageDataNode)nodes.get(i);
            if ((node.getCategory() == null || CategoryRegistryReader.getSingleton().getCategory(node.getCategory()) == null) && this.isVisibleNode(node)) {
                showOther = true;
                break;
            }
            ++i;
        }
        return showOther;
    }

    private boolean isVisibleNode(IPageDataNode node) {
        if (node instanceof PageActionNode) {
            return ((PageActionNode)node).isSolitary();
        }
        return node.getAdapter(IPageDataNodeUIAttribute.ADAPTER_KEY) != null && !"Client Side".equals(node.getDataCategory());
    }
}

