/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.ui;

import com.ibm.etools.webtools.pagedataview.ui.AddEditResourceDialog;
import com.ibm.etools.webtools.pagedataview.ui.AlphabeticalSort;
import com.ibm.etools.webtools.pagedataview.ui.PropertiesFileReader;
import com.ibm.etools.webtools.pagedataview.ui.SelectOrCreatePropsFileDlg;
import com.ibm.etools.webtools.pagedataview.ui.nls.ResourceHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class StringResourceControl {
    private Composite composite = null;
    private Composite buttonBarComposite = null;
    private Composite manageParent = null;
    private TableColumn idColumn = null;
    private TableColumn valueColumn = null;
    private String selectedId = null;
    private Table table = null;
    private Button search = null;
    private Button edit = null;
    private Button remove = null;
    private Button addPropertiesFile = null;
    private Text searchField = null;
    private PropertiesFileReader propsReader = null;
    private final int SORTBYID = 0;
    private final int SORTBYVAL = 1;
    private int sortOrder = 0;
    private Combo languageDropDown = null;
    private String currentlySelectedFileName = null;
    private Button okButton = null;
    private HashMap fullNameFileNamePairs = new HashMap();
    private static final String OPEN_BRACKET = " (";
    private static final String CLOSE_BRACKET = ")";

    public StringResourceControl(Composite parent) {
        this.propsReader = this.createPropertiesFileReader();
        this.createContents(parent);
    }

    private void createContents(Composite parent) {
        this.setupComposite(parent);
        Label l1 = new Label(this.composite, 0);
        l1.setText(ResourceHandler.StringResourceControl_2);
        this.manageParent = new Composite(this.composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 3;
        GridData manageParentData = new GridData();
        manageParentData.horizontalAlignment = 3;
        manageParentData.grabExcessHorizontalSpace = true;
        this.manageParent.setLayout((Layout)layout);
        this.manageParent.setLayoutData((Object)manageParentData);
        Label l2 = new Label(this.manageParent, 0);
        l2.setText(ResourceHandler.StringResourceControl_23);
        if (this.propsReader == null) {
            this.propsReader = this.createPropertiesFileReader();
        }
        HashMap map = this.propsReader.getPropertiesFiles(true);
        this.languageDropDown = new Combo(this.manageParent, 12);
        this.createLanguageDropDown(map);
        this.languageDropDown.select(0);
        this.languageDropDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                StringResourceControl.this.changePropertiesFile(((Combo)event.widget).getText());
            }
        });
        this.table = new Table(this.composite, 67584);
        GridData tableGridData = new GridData(770);
        tableGridData.heightHint = 225;
        tableGridData.horizontalSpan = 2;
        this.table.setLayoutData((Object)tableGridData);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.idColumn = new TableColumn(this.table, 0x800000);
        this.idColumn.setText(ResourceHandler.StringResourceControl_5);
        this.idColumn.setWidth(120);
        this.idColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent even) {
                StringResourceControl.this.sortOrder = 0;
                StringResourceControl.this.sortGridById(StringResourceControl.this.table);
            }
        });
        this.valueColumn = new TableColumn(this.table, 0x800000);
        this.valueColumn.setText(ResourceHandler.StringResourceControl_6);
        this.valueColumn.setWidth(455);
        this.valueColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                StringResourceControl.this.sortOrder = 1;
                StringResourceControl.this.sortGridByVal(StringResourceControl.this.table);
            }
        });
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringResourceControl.this.setSelectedId();
            }
        });
        if (map != null) {
            this.sortGridById(this.table);
        }
        Composite searchParent = new Composite(this.composite, 0);
        GridLayout searchParentLayout = new GridLayout();
        searchParentLayout.horizontalSpacing = 3;
        searchParentLayout.numColumns = 2;
        searchParent.setLayout((Layout)searchParentLayout);
        GridData searchParentData = new GridData();
        searchParentData.horizontalSpan = 2;
        searchParentData.horizontalAlignment = 3;
        searchParent.setLayoutData((Object)searchParentData);
        Label l3 = new Label(searchParent, 0);
        l3.setText(ResourceHandler.StringResourceControl_7);
        this.searchField = new Text(searchParent, 2048);
        this.searchField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                StringResourceControl.this.performSearch();
            }
        });
        GridData searchGrid = new GridData();
        searchGrid.grabExcessHorizontalSpace = true;
        searchGrid.widthHint = 200;
        this.searchField.setLayoutData((Object)searchGrid);
        this.composite.layout();
    }

    private void createLanguageDropDown(Map map) {
        String[] items = null;
        if (map == null) {
            items = new String[]{ResourceHandler.StringResourceControl_4};
        } else {
            items = new String[map.size()];
            Iterator itr = map.keySet().iterator();
            int i = 0;
            boolean first = true;
            while (itr.hasNext()) {
                items[i] = (String)itr.next();
                if (first) {
                    this.currentlySelectedFileName = items[i];
                    first = false;
                }
                String itemString = this.createLanguageDropDownItem(items[i], map);
                this.fullNameFileNamePairs.put(itemString, items[i]);
                items[i] = itemString;
                ++i;
            }
        }
        this.languageDropDown.setItems(items);
        this.languageDropDown.setVisibleItemCount(items.length);
    }

    private String createLanguageDropDownItem(String item, Map map) {
        return String.valueOf(item) + OPEN_BRACKET + (String)map.get(item) + CLOSE_BRACKET;
    }

    private void setupComposite(Composite parent) {
        this.composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 10;
        layout.marginHeight = 15;
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.composite.setLayout((Layout)layout);
        this.composite.setLayoutData((Object)data);
    }

    private void performSearch() {
        String searchText = this.searchField.getText();
        String string = searchText = searchText != null && searchText.length() > 0 ? searchText : null;
        if (this.sortOrder == 0) {
            this.sortGridById(this.table, searchText);
        } else {
            this.sortGridByVal(this.table, searchText);
        }
    }

    private void changePropertiesFile(String newFileName) {
        if ((String)this.fullNameFileNamePairs.get(newFileName) != null) {
            this.currentlySelectedFileName = (String)this.fullNameFileNamePairs.get(newFileName);
        }
        if (this.sortOrder == 0) {
            this.sortGridById(this.table);
        } else {
            this.sortGridByVal(this.table);
        }
        this.searchField.setText("");
        this.setSelectedId();
    }

    public void createButtonBar(Composite parent) {
        Button add = new Button(parent, 0);
        add.setText(ResourceHandler.StringResourceControl_10);
        add.setLayoutData((Object)new GridData(768));
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringResourceControl.this.addResource();
            }
        });
        this.edit = new Button(parent, 0);
        this.edit.setText(ResourceHandler.StringResourceControl_11);
        this.edit.setLayoutData((Object)new GridData(768));
        this.edit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringResourceControl.this.editResource();
            }
        });
        this.edit.setEnabled(false);
        this.remove = new Button(parent, 0);
        this.remove.setText(ResourceHandler.StringResourceControl_12);
        this.remove.setLayoutData((Object)new GridData(768));
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                StringResourceControl.this.deleteResource();
            }
        });
        this.remove.setEnabled(false);
        this.addPropertiesFile = new Button(parent, 0);
        this.addPropertiesFile.setText(ResourceHandler.StringResourceControl_24);
        this.addPropertiesFile.setLayoutData((Object)new GridData(768));
        this.addPropertiesFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                StringResourceControl.this.createTagAndFile();
            }
        });
    }

    public Composite getComposite() {
        return this.composite;
    }

    private void addResource() {
        AddEditResourceDialog addDlg;
        if (this.propsReader == null) {
            this.propsReader = this.createPropertiesFileReader();
        }
        String newId = null;
        String newValue = null;
        if (this.propsReader.getPropertiesFiles() == null || this.propsReader.getPropertiesFiles().size() < 1) {
            MessageBox box = new MessageBox(this.getComposite().getShell(), 196);
            box.setText(ResourceHandler.StringResourceControl_14);
            box.setMessage(ResourceHandler.StringResourceControl_13);
            if (box.open() == 64) {
                this.createTagAndFile();
            }
        }
        if ((addDlg = new AddEditResourceDialog(this.getComposite().getShell())).open() == 0) {
            newId = addDlg.getId().trim();
            newValue = addDlg.getValue().trim();
            this.propsReader.writeToPropertiesFile(this.currentlySelectedFileName, newId, newValue);
        }
        if (this.sortOrder == 0) {
            this.sortGridById(this.table);
        } else {
            this.sortGridByVal(this.table);
        }
        int index = this.findTableItem(newId, newValue);
        if (index != -1) {
            this.table.select(this.findTableItem(newId, newValue));
        }
        this.setSelectedId();
    }

    private void editResource() {
        AddEditResourceDialog editDlg;
        String selectedId = null;
        String selectedVal = null;
        try {
            selectedId = this.table.getSelection()[0].getText(0);
        }
        catch (Exception exception) {
            System.out.println("error editing the resource");
        }
        try {
            selectedVal = this.table.getSelection()[0].getText(1);
        }
        catch (Exception exception) {}
        if (selectedId != null && selectedId.length() > 0 && (editDlg = new AddEditResourceDialog(this.getComposite().getShell(), false, selectedId, selectedVal)).open() == 0) {
            String newId = editDlg.getId().trim();
            String newVal = editDlg.getValue().trim();
            if (newId != null && newId.equals(selectedId) && newVal != null && newVal.equals(selectedVal)) {
                return;
            }
            if (this.propsReader == null) {
                this.propsReader = this.createPropertiesFileReader();
            }
            this.propsReader.deleteFromPropsFile(this.currentlySelectedFileName, selectedId);
            this.propsReader.writeToPropertiesFile(this.currentlySelectedFileName, newId, newVal);
            if (this.sortOrder == 0) {
                this.sortGridById(this.table);
            } else {
                this.sortGridByVal(this.table);
            }
            int index = this.findTableItem(newId, newVal);
            if (index != -1) {
                this.table.select(this.findTableItem(newId, newVal));
            }
            this.setSelectedId();
        }
    }

    private void deleteResource() {
        if (this.table.getSelection()[0].getText() != null) {
            String id = this.table.getSelection()[0].getText();
            String value = this.table.getSelection()[0].getText(1);
            int tableIndex = this.findTableItem(id, value);
            MessageBox box = new MessageBox(this.getComposite().getShell(), 200);
            box.setText(ResourceHandler.StringResourceControl_18);
            box.setMessage(ResourceHandler.StringResourceControl_19);
            if (box.open() == 64) {
                if (this.propsReader == null) {
                    this.propsReader = this.createPropertiesFileReader();
                }
                this.propsReader.deleteFromPropsFile(this.currentlySelectedFileName, id);
                if (this.sortOrder == 0) {
                    this.sortGridById(this.table);
                } else {
                    this.sortGridByVal(this.table);
                }
                if (this.table.getItemCount() != 0) {
                    if (this.table.getItemCount() == tableIndex) {
                        this.table.setSelection(tableIndex - 1);
                    } else {
                        this.table.setSelection(tableIndex);
                    }
                }
                this.setSelectedId();
            }
        }
    }

    private void sortGridById(Table table) {
        this.sortGridById(table, null);
    }

    private void sortGridById(Table table, String searchValue) {
        if (this.propsReader == null) {
            this.propsReader = this.createPropertiesFileReader();
        }
        if (this.propsReader.getPropertiesFiles() == null || this.propsReader.getPropertiesFiles().size() < 1) {
            return;
        }
        table.removeAll();
        HashMap idValuePairs = null;
        idValuePairs = searchValue != null && searchValue.length() > 0 ? this.propsReader.searchPropertiesFile(this.currentlySelectedFileName, searchValue) : this.propsReader.readPropertiesFile(this.currentlySelectedFileName);
        TableItem item = null;
        if (idValuePairs != null && idValuePairs.size() > 0) {
            Iterator itr = idValuePairs.keySet().iterator();
            ArrayList idArray = new ArrayList();
            while (itr.hasNext()) {
                String id = (String)itr.next();
                idArray.add(id);
            }
            idArray = AlphabeticalSort.sortString(idArray);
            int i = 0;
            while (i < idArray.size()) {
                String id = (String)idArray.get(i);
                item = new TableItem(table, 0);
                item.setText(0, id);
                item.setText(1, (String)idValuePairs.get(id));
                ++i;
            }
        }
    }

    private void sortGridByVal(Table table) {
        this.sortGridByVal(table, null);
    }

    private void sortGridByVal(Table table, String searchValue) {
        if (this.propsReader == null) {
            this.propsReader = this.createPropertiesFileReader();
        }
        if (this.propsReader.getPropertiesFiles() == null || this.propsReader.getPropertiesFiles().size() < 1) {
            return;
        }
        table.removeAll();
        HashMap idValuePairs = null;
        idValuePairs = searchValue != null && searchValue.length() > 0 ? this.propsReader.searchPropertiesFile(this.currentlySelectedFileName, searchValue) : this.propsReader.readPropertiesFile(this.currentlySelectedFileName);
        TableItem item = null;
        if (idValuePairs != null && idValuePairs.size() > 0) {
            String val;
            Iterator itr = idValuePairs.keySet().iterator();
            ArrayList valArray = new ArrayList();
            HashMap<String, String> valIdPairs = new HashMap<String, String>();
            while (itr.hasNext()) {
                String id = (String)itr.next();
                val = (String)idValuePairs.get(id);
                valIdPairs.put(val, id);
                valArray.add(val);
            }
            valArray = AlphabeticalSort.sortString(valArray);
            int i = 0;
            while (i < valArray.size()) {
                item = new TableItem(table, 0);
                val = (String)valArray.get(i);
                item.setText(0, (String)valIdPairs.get(val));
                item.setText(1, val);
                ++i;
            }
        }
    }

    public String getSelectedId() {
        if (this.selectedId == null) {
            return "";
        }
        return "#{" + this.propsReader.getVar(this.currentlySelectedFileName) + "." + this.selectedId + "}";
    }

    protected Object[] createFileListInput() {
        return new Object[0];
    }

    protected Object[] createPackageListInput() {
        return new Object[0];
    }

    private void createTagAndFile() {
        SelectOrCreatePropsFileDlg propsDlg = new SelectOrCreatePropsFileDlg(this.getComposite().getShell(), false);
        propsDlg.setIgnoreCase(true);
        propsDlg.setTitle(ResourceHandler.StringResourceControl_20);
        propsDlg.setMessage(ResourceHandler.StringResourceControl_21, ResourceHandler.StringResourceControl_22);
        propsDlg.setElements(this.createFileListInput(), this.createPackageListInput());
        propsDlg.setFilter("*.properties");
        if (propsDlg.open() == 0) {
            String fileName = propsDlg.getFBaseName();
            String var = propsDlg.getFVar();
            String mapKey = propsDlg.getFGlobalFileNameValue();
            if (!mapKey.endsWith(".properties")) {
                mapKey = String.valueOf(mapKey) + ".properties";
            }
            this.propsReader.createPropsFileAndTag(fileName, var, null);
            HashMap map = this.propsReader.getPropertiesFiles();
            this.createLanguageDropDown(map);
            this.getComposite().redraw();
            this.getComposite().layout();
            int index = this.findIndexOfLanguageDropDownItem(mapKey, map);
            if (index != -1) {
                this.languageDropDown.select(index);
                this.changePropertiesFile(this.createLanguageDropDownItem(mapKey, map));
            }
        }
    }

    private int findIndexOfLanguageDropDownItem(String mapKey, Map map) {
        int index = -1;
        String dropDownItemText = this.createLanguageDropDownItem(mapKey, map);
        String[] items = this.languageDropDown.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].equals(dropDownItemText)) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    private void setSelectedId() {
        this.selectedId = this.table.getSelection() == null || this.table.getSelection().length == 0 ? null : this.table.getSelection()[0].getText();
        if (this.selectedId == null || this.selectedId.length() < 1) {
            if (this.edit != null) {
                this.edit.setEnabled(false);
            }
            if (this.remove != null) {
                this.remove.setEnabled(false);
            }
            if (this.okButton != null) {
                this.okButton.setEnabled(false);
            }
        } else {
            if (this.edit != null) {
                this.edit.setEnabled(true);
            }
            if (this.remove != null) {
                this.remove.setEnabled(true);
            }
            if (this.okButton != null) {
                this.okButton.setEnabled(true);
            }
        }
    }

    public void setOkButton(Button okButton) {
        this.okButton = okButton;
    }

    public void dispose() {
        this.dispose((Widget)this.composite);
        this.dispose((Widget)this.buttonBarComposite);
        this.dispose((Widget)this.idColumn);
        this.dispose((Widget)this.valueColumn);
        this.dispose((Widget)this.table);
        this.dispose((Widget)this.search);
        this.dispose((Widget)this.edit);
        this.dispose((Widget)this.remove);
        this.dispose((Widget)this.searchField);
        if (this.propsReader != null) {
            this.propsReader.dispose();
            this.propsReader = null;
        }
        this.dispose((Widget)this.languageDropDown);
        this.dispose((Widget)this.okButton);
        if (this.fullNameFileNamePairs != null) {
            this.fullNameFileNamePairs.clear();
            this.fullNameFileNamePairs = null;
        }
    }

    private void dispose(Widget w) {
        if (w != null) {
            if (!w.isDisposed()) {
                w.dispose();
            }
            w = null;
        }
    }

    public PropertiesFileReader getPropsReader() {
        return this.propsReader;
    }

    protected PropertiesFileReader createPropertiesFileReader() {
        return new PropertiesFileReader();
    }

    private int findTableItem(String id, String value) {
        int index = -1;
        if (this.table != null) {
            TableItem[] items = this.table.getItems();
            int i = 0;
            while (i < items.length) {
                TableItem item = items[i];
                String itemID = item.getText(0);
                String itemValue = item.getText(1);
                if (itemID.equals(id) && itemValue.equals(value)) {
                    index = i;
                    break;
                }
                ++i;
            }
        }
        return index;
    }

    private int findTableItemById(String id) {
        int index = -1;
        if (this.table != null) {
            TableItem[] items = this.table.getItems();
            int i = 0;
            while (i < items.length) {
                TableItem item = items[i];
                String itemID = item.getText(0);
                if (itemID.equals(id)) {
                    index = i;
                    break;
                }
                ++i;
            }
        }
        return index;
    }

    public void setSelection(String fileVarName, String propId) {
        int propertiesFileNameIndex = this.findIndexOfLanguageDropDownItem(fileVarName, this.propsReader.getPropertiesFiles());
        this.languageDropDown.select(propertiesFileNameIndex);
        String dropDownItemText = this.createLanguageDropDownItem(fileVarName, this.propsReader.getPropertiesFiles());
        this.changePropertiesFile(dropDownItemText);
        int tableItemIndex = this.findTableItemById(propId);
        this.table.select(tableItemIndex);
        this.setSelectedId();
    }
}

