/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.ui;

import com.ibm.etools.webtools.pagedataview.ui.nls.ResourceHandler;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.AbstractElementListSelectionDialog;
import org.eclipse.ui.dialogs.FilteredList;

public class SelectOrCreatePropsFileDlg
extends AbstractElementListSelectionDialog {
    private Object[] fExistingFiles;
    private Object[] fPackages;
    private String fPropsString;
    private String fPackagesString;
    private String fVar;
    private String fBaseName;
    private String fID;
    private String fValue;
    private String fFilter;
    private Text fFileLocation;
    private Text fGlobalFileName = null;
    private String fGlobalFileNameValue = null;
    private Text fIdentifier = null;
    private Text fIDField = null;
    private Text fValueField = null;
    private TabFolder fFolder;
    private Label error = null;
    private FilteredList fPropsFileList;
    private FilteredList fPackagesList;
    private boolean fAddResource = true;

    public SelectOrCreatePropsFileDlg(Shell parent) {
        super(parent, (ILabelProvider)new JavaElementLabelProvider());
    }

    public SelectOrCreatePropsFileDlg(Shell parent, boolean addResource) {
        super(parent, (ILabelProvider)new JavaElementLabelProvider());
        this.fAddResource = addResource;
    }

    public void setElements(Object[] files, Object[] packages) {
        this.fExistingFiles = files;
        this.fPackages = packages;
    }

    protected void computeResult() {
        this.setResult(Arrays.asList(this.getSelectedElements()));
    }

    protected Control createDialogArea(Composite parent) {
        this.fFolder = new TabFolder(parent, 128);
        this.fFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SelectOrCreatePropsFileDlg.this.changeTab();
            }
        });
        TabItem selectExistingPropertiesFile = new TabItem(this.fFolder, 0, 0);
        selectExistingPropertiesFile.setText(ResourceHandler.SelectOrCreatePropsFileDlg_0);
        TabItem createNewPropertiesFile = new TabItem(this.fFolder, 0, 1);
        createNewPropertiesFile.setText(ResourceHandler.SelectOrCreatePropsFileDlg_1);
        createNewPropertiesFile.setControl((Control)this.createPackagesArea((Composite)this.fFolder));
        selectExistingPropertiesFile.setControl((Control)this.createPropsFileArea((Composite)this.fFolder));
        return this.fFolder;
    }

    private Composite createPropsFileArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        this.setMessage(this.fPropsString);
        this.createMessageArea(contents);
        this.createFilterText(contents);
        this.fPropsFileList = this.createFilteredList(contents);
        this.fPropsFileList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (SelectOrCreatePropsFileDlg.this.fPropsFileList != null && SelectOrCreatePropsFileDlg.this.fPropsFileList.getSelection() != null && SelectOrCreatePropsFileDlg.this.fPropsFileList.getSelection().length > 0 && SelectOrCreatePropsFileDlg.this.fFolder != null) {
                    if (SelectOrCreatePropsFileDlg.this.fFolder.getSelectionIndex() == 0) {
                        SelectOrCreatePropsFileDlg.this.changeLocationInfo(SelectOrCreatePropsFileDlg.this.fPropsFileList.getSelection()[0], true);
                    } else {
                        SelectOrCreatePropsFileDlg.this.fGlobalFileName.setText("");
                    }
                }
            }
        });
        this.setListElements(this.fExistingFiles);
        this.setSelection(this.getInitialElementSelections().toArray());
        return contents;
    }

    private Composite createPackagesArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        this.setMessage(this.fPackagesString);
        this.createMessageArea(contents);
        this.fPackagesList = this.createFilteredList(contents);
        this.fPackagesList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (SelectOrCreatePropsFileDlg.this.fPackagesList != null && SelectOrCreatePropsFileDlg.this.fPackagesList.getSelection() != null && SelectOrCreatePropsFileDlg.this.fPackagesList.getSelection().length > 0) {
                    SelectOrCreatePropsFileDlg.this.changeLocationInfo(SelectOrCreatePropsFileDlg.this.fPackagesList.getSelection()[0], false);
                }
            }
        });
        this.setListElements(this.fPackages);
        this.setSelection(this.getInitialElementSelections().toArray());
        return contents;
    }

    public void setMessage(String propsString, String packagesString) {
        this.fPropsString = propsString;
        this.fPackagesString = packagesString;
    }

    protected void okPressed() {
        this.fBaseName = this.fFileLocation.getText().equals(ResourceHandler.SelectOrCreatePropsFileDlg_2) ? this.fGlobalFileName.getText() : String.valueOf(this.fFileLocation.getText()) + "." + this.fGlobalFileName.getText();
        this.fVar = this.fIdentifier.getText();
        this.fGlobalFileNameValue = this.fGlobalFileName.getText();
        if (this.fAddResource) {
            this.fID = this.fIDField.getText() != null ? this.fIDField.getText().trim() : "";
            String string = this.fValue = this.fValueField.getText() != null ? this.fValueField.getText() : "";
        }
        if (this.fVar == null || this.fVar.length() < 1 || this.fGlobalFileName.getText() == null || this.fGlobalFileName.getText().length() < 1) {
            this.error.setText(ResourceHandler.SelectOrCreatePropsFileDlg_17);
            this.error.getParent().redraw();
            this.error.getParent().layout();
            this.error.setVisible(true);
            this.error.setForeground(ColorConstants.red);
            return;
        }
        super.okPressed();
    }

    private void changeTab() {
        if (this.error != null) {
            this.error.setText("");
        }
        if (this.fPackagesList != null && this.fPropsFileList != null) {
            if (this.fFolder.getSelectionIndex() != 0) {
                this.fGlobalFileName.setEnabled(true);
                this.fFilter = this.getFilter();
                this.fPackagesList.setFilter("");
                super.setFilter("");
            } else {
                this.fGlobalFileName.setEnabled(false);
                this.fPropsFileList.setFilter(this.fFilter);
                this.setFilter(this.fFilter);
            }
        }
    }

    private void changeLocationInfo(Object selection, boolean isFile) {
        Button okButton;
        if (isFile) {
            IFile file = (IFile)selection;
            String path = file.getProjectRelativePath().removeLastSegments(1).toString();
            IProject project = file.getProject();
            IPackageFragmentRoot[] srcFolders = J2EEProjectUtilities.getSourceContainers((IProject)project);
            if (srcFolders != null && srcFolders.length > 0) {
                int i = 0;
                while (i < srcFolders.length) {
                    String folderName = srcFolders[i].getElementName();
                    if (path.indexOf(folderName) > -1) {
                        path = path.length() > folderName.length() ? path.substring(path.indexOf(folderName) + folderName.length() + 1) : ResourceHandler.SelectOrCreatePropsFileDlg_2;
                        path = path.replaceAll(new String(new char[]{'/'}), ".");
                        break;
                    }
                    ++i;
                }
            }
            this.fFileLocation.setText(path);
            this.fGlobalFileName.setText(file.getName());
        } else {
            IPackageFragment packageFrag = (IPackageFragment)selection;
            this.fFileLocation.setText(packageFrag.getElementName());
        }
        if (selection != null && (okButton = this.getOkButton()) != null) {
            okButton.setEnabled(true);
        }
    }

    public void setFilter(String filter) {
        super.setFilter(filter);
        this.fFilter = filter;
    }

    public String getFBaseName() {
        return this.fBaseName;
    }

    public String getFID() {
        return this.fID;
    }

    public String getFValue() {
        return this.fValue;
    }

    public String getFGlobalFileNameValue() {
        return this.fGlobalFileNameValue;
    }

    public String getFVar() {
        return this.fVar;
    }

    protected Control createButtonBar(Composite parent) {
        Composite twoCols = (Composite)super.createDialogArea(parent);
        ((GridLayout)twoCols.getLayout()).numColumns = 2;
        twoCols.setLayoutData((Object)new GridData(768));
        Label locationDesc = new Label(twoCols, 0);
        locationDesc.setText(ResourceHandler.SelectOrCreatePropsFileDlg_10);
        GridData labelData = new GridData();
        labelData.horizontalSpan = 2;
        locationDesc.setLayoutData((Object)labelData);
        new Label(twoCols, 0).setText(ResourceHandler.SelectOrCreatePropsFileDlg_11);
        this.fFileLocation = new Text(twoCols, 2056);
        this.fFileLocation.setLayoutData((Object)new GridData(768));
        this.fFileLocation.setEnabled(false);
        new Label(twoCols, 0).setText(ResourceHandler.SelectOrCreatePropsFileDlg_12);
        this.fGlobalFileName = new Text(twoCols, 2048);
        this.fGlobalFileName.setLayoutData((Object)new GridData(768));
        this.fGlobalFileName.setEnabled(false);
        new Label(twoCols, 0).setText(ResourceHandler.SelectOrCreatePropsFileDlg_13);
        this.fIdentifier = new Text(twoCols, 2048);
        this.fIdentifier.setLayoutData((Object)new GridData(768));
        if (this.fAddResource) {
            new Label(parent, 258).setLayoutData((Object)new GridData(768));
            Composite twoCols2 = (Composite)super.createDialogArea(parent);
            ((GridLayout)twoCols2.getLayout()).numColumns = 2;
            twoCols2.setLayoutData((Object)new GridData(768));
            Label res = new Label(twoCols2, 0);
            res.setText(ResourceHandler.SelectOrCreatePropsFileDlg_14);
            GridData span = new GridData();
            span.horizontalSpan = 2;
            res.setLayoutData((Object)span);
            new Label(twoCols2, 0).setText(ResourceHandler.SelectOrCreatePropsFileDlg_15);
            this.fIDField = new Text(twoCols2, 2048);
            this.fIDField.setLayoutData((Object)new GridData(768));
            new Label(twoCols2, 0).setText(ResourceHandler.SelectOrCreatePropsFileDlg_16);
            this.fValueField = new Text(twoCols2, 2048);
            this.fValueField.setLayoutData((Object)new GridData(768));
        }
        this.error = new Label(twoCols, 0);
        GridData span2 = new GridData();
        span2.horizontalSpan = 2;
        this.error.setLayoutData((Object)span2);
        return super.createButtonBar(parent);
    }

    public boolean close() {
        boolean ret = super.close();
        if (ret) {
            this.dispose((Widget)this.fFileLocation);
            this.dispose((Widget)this.fGlobalFileName);
            this.dispose((Widget)this.fIdentifier);
            this.dispose((Widget)this.fIDField);
            this.dispose((Widget)this.fValueField);
            this.dispose((Widget)this.fFolder);
            this.dispose((Widget)this.error);
            this.dispose((Widget)this.fPropsFileList);
            this.dispose((Widget)this.fPackagesList);
        }
        return ret;
    }

    private void dispose(Widget w) {
        if (w != null && !w.isDisposed()) {
            w.dispose();
        }
        w = null;
    }
}

