/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.ui;

import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.common.utils.ActionUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public class PropertiesFileReader {
    protected static final String PROPS_EXT = ".properties";
    protected IFile propertiesFile = null;
    protected HashMap fileNameVarPairs = new HashMap();
    protected String locale = null;
    protected HashMap nameAndFileNamePairs = null;
    protected HTMLEditDomain domain = null;
    protected HashMap namesAndFiles = new HashMap();
    private static final String EQUALS = "=";

    public HTMLEditDomain getEditDomain() {
        if (this.domain == null) {
            this.domain = ActionUtil.getActiveHTMLEditDomain();
        }
        return this.domain;
    }

    public HashMap findAndReadPropertiesFile(String fileName) {
        return this.readPropertiesFile(this.getPropertiesFile(fileName));
    }

    public IFile getPropertiesFile(String fileName) {
        if (this.propertiesFile != null && this.propertiesFile.getName().equals(fileName)) {
            return this.propertiesFile;
        }
        if (this.namesAndFiles.get(fileName) != null) {
            return (IFile)this.namesAndFiles.get(fileName);
        }
        return null;
    }

    public List scanDocForTag(String tagName) {
        this.domain = this.getEditDomain();
        if (this.domain == null) {
            return null;
        }
        IDOMDocument doc = this.domain.getActiveModel().getDocument();
        return this.scanDocForTag((Document)doc, tagName);
    }

    public List scanDocForTag(Document d, String tagName) {
        List nodes = this.findNodes(d);
        ArrayList<Element> ret = new ArrayList<Element>();
        for (Element element : nodes) {
            if (!element.getLocalName().equals(tagName)) continue;
            ret.add(element);
        }
        return ret;
    }

    public List findNodes(Document d) {
        ArrayList<Node> resultnodes = new ArrayList<Node>();
        if (d == null) {
            return resultnodes;
        }
        NodeIterator iter = ((DocumentTraversal)((Object)d)).createNodeIterator(d, 1, null, false);
        Node node = iter.nextNode();
        while (node != null) {
            resultnodes.add(node);
            node = iter.nextNode();
        }
        return resultnodes;
    }

    public HashMap searchPropertiesFile(String fileName, String searchValue) {
        if (this.propertiesFile == null || !this.propertiesFile.getName().equals(fileName)) {
            this.propertiesFile = this.getPropertiesFile(fileName);
            if (this.propertiesFile == null) {
                return null;
            }
        }
        if (searchValue == null || searchValue.length() < 1) {
            return this.readPropertiesFile(this.propertiesFile);
        }
        return this.searchPropertiesFile(this.propertiesFile, searchValue);
    }

    public HashMap searchPropertiesFile(IFile file, String searchValue) {
        if (file == null) {
            return null;
        }
        HashMap map = new HashMap();
        HashMap searchMap = this.readPropertiesFile(file);
        for (Map.Entry entry : searchMap.entrySet()) {
            if (((String)entry.getKey()).toLowerCase().indexOf(searchValue.toLowerCase()) == -1 && ((String)entry.getValue()).toLowerCase().indexOf(searchValue.toLowerCase()) == -1) continue;
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public HashMap readPropertiesFile(String fileName) {
        if (this.propertiesFile == null || !this.propertiesFile.getName().equals(fileName)) {
            this.propertiesFile = this.getPropertiesFile(fileName);
        }
        return this.readPropertiesFile(this.propertiesFile);
    }

    public HashMap readPropertiesFile(IFile file) {
        HashMap<Object, Object> map;
        block29: {
            if (file == null) {
                return null;
            }
            map = new HashMap<Object, Object>();
            InputStream contentStream = null;
            Reader reader = null;
            BufferedReader in = null;
            try {
                if (!file.isSynchronized(0)) {
                    file.refreshLocal(0, null);
                }
                contentStream = file.getContents();
                Properties p = new Properties();
                p.load(contentStream);
                map.putAll(p);
            }
            catch (CoreException coreException) {
                System.out.println("could not open properties file...");
                if (contentStream == null) break block29;
                try {
                    if (contentStream != null) {
                        contentStream.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                    if (reader != null) {
                        reader.close();
                    }
                    break block29;
                }
                catch (IOException iOException) {}
                break block29;
            }
            catch (IOException iOException) {
                try {
                    System.out.println("io exception on properties file");
                    if (contentStream == null) break block29;
                }
                catch (Throwable throwable) {
                    if (contentStream != null) {
                        try {
                            if (contentStream != null) {
                                contentStream.close();
                            }
                            if (in != null) {
                                in.close();
                            }
                            if (reader != null) {
                                reader.close();
                            }
                        }
                        catch (IOException iOException2) {}
                    }
                    throw throwable;
                }
                try {
                    if (contentStream != null) {
                        contentStream.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                    if (reader != null) {
                        reader.close();
                    }
                    break block29;
                }
                catch (IOException iOException3) {}
                break block29;
            }
            if (contentStream == null) break block29;
            try {
                if (contentStream != null) {
                    contentStream.close();
                }
                if (in != null) {
                    in.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return map;
    }

    public void writeToPropertiesFile(String fileName, String newResources) {
        block17: {
            if (fileName == null || fileName.length() < 1 || newResources == null || newResources.length() < 1) {
                return;
            }
            IFile file = this.getPropertiesFile(fileName);
            if (file == null) {
                return;
            }
            ByteArrayInputStream stream = null;
            try {
                try {
                    stream = new ByteArrayInputStream(newResources.getBytes());
                    if (!file.isSynchronized(0)) {
                        file.refreshLocal(0, null);
                    }
                    file.appendContents((InputStream)stream, true, true, null);
                }
                catch (CoreException coreException) {
                    System.out.println("error updating the props file");
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {
                            System.out.println("error closing properties file stream");
                        }
                    }
                    this.namesAndFiles.remove(file.getName());
                    this.namesAndFiles.put(file.getName(), file);
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {
                        System.out.println("error closing properties file stream");
                    }
                }
                this.namesAndFiles.remove(file.getName());
                this.namesAndFiles.put(file.getName(), file);
                throw throwable;
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {
                    System.out.println("error closing properties file stream");
                }
            }
            this.namesAndFiles.remove(file.getName());
            this.namesAndFiles.put(file.getName(), file);
        }
    }

    public void writeToPropertiesFile(String fileName, String key, String value) {
        block18: {
            if (fileName == null || fileName.length() < 1 || key == null || key.length() < 1 || value == null || value.length() < 1) {
                return;
            }
            IFile file = this.getPropertiesFile(fileName);
            if (file == null) {
                return;
            }
            Properties p = new Properties();
            ByteArrayInputStream inStream = null;
            ByteArrayOutputStream outStream = null;
            try {
                try {
                    int sep;
                    p.put(key, value);
                    outStream = new ByteArrayOutputStream();
                    p.store(outStream, null);
                    inStream = new ByteArrayInputStream(outStream.toByteArray());
                    String newText = outStream.toString(file.getCharset());
                    if (newText != null && (sep = newText.indexOf("\n")) > -1) {
                        newText = newText.substring(sep + 1);
                        inStream = new ByteArrayInputStream(newText.getBytes(file.getCharset()));
                    }
                    if (!file.isSynchronized(0)) {
                        file.refreshLocal(0, null);
                    }
                    file.appendContents((InputStream)inStream, true, true, null);
                }
                catch (Exception exception) {
                    System.out.println("error updating the properties file");
                    if (inStream != null) {
                        try {
                            inStream.close();
                        }
                        catch (IOException iOException) {
                            System.out.println("error closing properties file stream");
                        }
                    }
                    this.namesAndFiles.remove(file.getName());
                    this.namesAndFiles.put(file.getName(), file);
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (IOException iOException) {
                        System.out.println("error closing properties file stream");
                    }
                }
                this.namesAndFiles.remove(file.getName());
                this.namesAndFiles.put(file.getName(), file);
                throw throwable;
            }
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException iOException) {
                    System.out.println("error closing properties file stream");
                }
            }
            this.namesAndFiles.remove(file.getName());
            this.namesAndFiles.put(file.getName(), file);
        }
    }

    public void deleteFromPropsFile(String fileName, String oldId) {
        if (this.propertiesFile == null || !this.propertiesFile.getName().equals(fileName)) {
            this.propertiesFile = this.getPropertiesFile(fileName);
        }
        this.deleteFromPropertiesFile(this.propertiesFile, oldId);
    }

    public void deleteFromPropertiesFile(IFile file, String oldId) {
        block33: {
            if (file == null) {
                return;
            }
            InputStream contentStream = null;
            ByteArrayInputStream stream = null;
            InputStreamReader reader = null;
            try {
                if (!file.isSynchronized(0)) {
                    file.refreshLocal(0, null);
                }
                contentStream = file.getContents();
                reader = new InputStreamReader(contentStream);
                BufferedReader in = new BufferedReader(reader);
                String line = in.readLine();
                stream = new ByteArrayInputStream("".getBytes());
                file.setContents((InputStream)stream, true, true, null);
                String newContents = new String();
                while (line != null) {
                    String newLine = System.getProperty("line.separator");
                    int n = line.indexOf(EQUALS);
                    if (n != -1) {
                        String id = line.substring(0, n).trim();
                        if (id != null && !id.equals(oldId)) {
                            newContents = String.valueOf(newContents) + line + newLine;
                        }
                    } else if (line != null && line.length() > 0) {
                        newContents = String.valueOf(newContents) + line + newLine;
                    }
                    line = in.readLine();
                }
                stream = new ByteArrayInputStream(newContents.getBytes());
                file.appendContents((InputStream)stream, true, true, null);
            }
            catch (CoreException coreException) {
                System.out.println("could not open file..");
                this.namesAndFiles.remove(file.getName());
                this.namesAndFiles.put(file.getName(), file);
                try {
                    if (contentStream != null) {
                        contentStream.close();
                    }
                    if (stream != null) {
                        stream.close();
                    }
                    if (reader != null) {
                        ((Reader)reader).close();
                    }
                    break block33;
                }
                catch (IOException iOException) {}
                break block33;
            }
            catch (IOException iOException) {
                try {
                    System.out.println("io exception");
                    this.namesAndFiles.remove(file.getName());
                }
                catch (Throwable throwable) {
                    this.namesAndFiles.remove(file.getName());
                    this.namesAndFiles.put(file.getName(), file);
                    try {
                        if (contentStream != null) {
                            contentStream.close();
                        }
                        if (stream != null) {
                            stream.close();
                        }
                        if (reader != null) {
                            ((Reader)reader).close();
                        }
                    }
                    catch (IOException iOException2) {}
                    throw throwable;
                }
                this.namesAndFiles.put(file.getName(), file);
                try {
                    if (contentStream != null) {
                        contentStream.close();
                    }
                    if (stream != null) {
                        stream.close();
                    }
                    if (reader != null) {
                        ((Reader)reader).close();
                    }
                    break block33;
                }
                catch (IOException iOException3) {}
                break block33;
            }
            this.namesAndFiles.remove(file.getName());
            this.namesAndFiles.put(file.getName(), file);
            try {
                if (contentStream != null) {
                    contentStream.close();
                }
                if (stream != null) {
                    stream.close();
                }
                if (reader != null) {
                    ((Reader)reader).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public String getVar(String fileName) {
        if (this.fileNameVarPairs == null || this.fileNameVarPairs.size() < 1) {
            this.getPropertiesFiles(true);
        }
        return (String)this.fileNameVarPairs.get(fileName);
    }

    public String getLocale() {
        return this.locale;
    }

    public HashMap getPropertiesFiles() {
        return this.getPropertiesFiles(false);
    }

    public HashMap getPropertiesFiles(boolean fullRefresh) {
        if (!fullRefresh && this.nameAndFileNamePairs != null) {
            return this.nameAndFileNamePairs;
        }
        return this.nameAndFileNamePairs;
    }

    public boolean createPropsFileAndTag(String fileName, String var, String newContent) {
        return false;
    }

    public void dispose() {
        this.propertiesFile = null;
        if (this.fileNameVarPairs != null) {
            this.fileNameVarPairs.clear();
            this.fileNameVarPairs = null;
        }
        if (this.nameAndFileNamePairs != null) {
            this.nameAndFileNamePairs.clear();
            this.nameAndFileNamePairs = null;
        }
        this.domain = null;
        if (this.namesAndFiles != null) {
            this.namesAndFiles.clear();
            this.namesAndFiles = null;
        }
    }
}

