/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.ui;

import com.ibm.etools.webtools.pagedatamodel.api.IPageDataChangeListener;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.IBindingAttribute;
import com.ibm.etools.webtools.pagedataview.data.IBindingPreviewer;
import com.ibm.etools.webtools.pagedataview.ui.internal.BeanPropertySelection;
import com.ibm.etools.webtools.pagedataview.ui.nls.ResourceHandler;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;

public class AddVariableDialog
extends Dialog {
    public static final String DEFAULT_EL_VALUE_PREFIX = "#{";
    private String fELValuePrefix = "#{";
    private String fELValueSuffix = "}";
    private IPageDataModel model = null;
    private BeanPropertySelection bps = null;
    private Tree propertiesTree = null;
    private Text referenceStringText = null;
    private IPageDataNode selectedNode;
    private boolean bindToList = false;
    private String propertyName = null;
    private String propertyType = null;
    private String referenceString = null;
    private String runtimeType = null;
    private IBindingPreviewer bindingPreviewer = null;

    public AddVariableDialog(Shell parentShell, IPageDataModel model) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.model = model;
    }

    public AddVariableDialog(Shell parentShell, IPageDataModel model, IBindingPreviewer bindingPreviewer) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.model = model;
        this.bindingPreviewer = bindingPreviewer;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(ResourceHandler.AddVariableDialog_0);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)gridData);
        Label label = new Label(composite, 0);
        label.setText(ResourceHandler.AddVariableDialog_1);
        this.bps = new BeanPropertySelection(composite, this.model, new String[]{"Server Side", "Scripting"});
        this.propertiesTree = this.bps.getTree();
        gridData = (GridData)this.propertiesTree.getLayoutData();
        gridData.horizontalAlignment = 4;
        gridData.heightHint = 100;
        gridData.widthHint = 210;
        this.propertiesTree.setLayoutData((Object)gridData);
        this.bps.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AddVariableDialog.this.treeItemSelected(event);
            }
        });
        this.bps.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                AddVariableDialog.this.treeDoubleClicked(event);
            }
        });
        this.bps.getTree().setFocus();
        this.model.getPageDataNotifier().addPageDataChangedListener((IPageDataChangeListener)this.bps);
        Composite twoCol = new Composite(composite, 0);
        GridData twoColData = new GridData();
        twoColData.grabExcessHorizontalSpace = true;
        twoColData.horizontalAlignment = 4;
        GridLayout twoColLayout = new GridLayout();
        twoColLayout.numColumns = 2;
        twoColLayout.horizontalSpacing = 8;
        twoCol.setLayout((Layout)twoColLayout);
        twoCol.setLayoutData((Object)twoColData);
        Label refText = new Label(twoCol, 0);
        refText.setText(ResourceHandler.AddVariableDialog_2);
        this.referenceStringText = new Text(twoCol, 2048);
        this.referenceStringText.setLayoutData((Object)new GridData(768));
        this.referenceStringText.setEditable(false);
        return composite;
    }

    void treeItemSelected(SelectionChangedEvent e) {
        IStructuredSelection selection = (IStructuredSelection)e.getSelection();
        this.selectedNode = (IPageDataNode)selection.getFirstElement();
        this.treeItemSelected();
    }

    void treeDoubleClicked(DoubleClickEvent e) {
        IStructuredSelection selection = (IStructuredSelection)e.getSelection();
        this.selectedNode = (IPageDataNode)selection.getFirstElement();
        this.treeItemSelected();
        this.okPressed();
    }

    private void treeItemSelected() {
        Object adapter = null;
        if (this.selectedNode != null) {
            adapter = this.selectedNode.getAdapter(IBindingAttribute.ADAPTER_KEY);
        }
        if (adapter != null && adapter instanceof IBindingAttribute) {
            IBindingAttribute binding = (IBindingAttribute)adapter;
            this.propertyName = binding.getName(this.selectedNode);
            this.propertyType = binding.getTypeAsString(this.selectedNode);
            this.runtimeType = binding.getRuntimeType(this.selectedNode);
            if (this.bindingPreviewer != null) {
                this.referenceString = this.bindingPreviewer.getBindingPreview(this.selectedNode);
                if (this.referenceString == null || "".equals(this.referenceString)) {
                    this.referenceString = binding.getReferenceString(this.selectedNode);
                }
            } else {
                this.referenceString = binding.getReferenceString(this.selectedNode);
            }
            if (this.bindToList && this.referenceString != null && this.referenceString.endsWith("[0]")) {
                this.referenceString = this.referenceString.substring(0, this.referenceString.lastIndexOf("[0]"));
            }
            this.referenceString = String.valueOf(this.getELValuePrefix()) + this.referenceString + this.getELValueSuffix();
            this.referenceStringText.setText(this.referenceString);
        } else {
            this.propertyName = null;
            this.propertyType = null;
            this.runtimeType = null;
            this.referenceString = null;
            this.referenceStringText.setText(this.referenceString == null ? "" : this.referenceString);
        }
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getReferenceString() {
        return this.referenceString;
    }

    public String getRuntimeType() {
        return this.runtimeType;
    }

    public String getPropertyType() {
        return this.propertyType;
    }

    private String getELValueSuffix() {
        return this.fELValueSuffix;
    }

    public String getELValuePrefix() {
        return this.fELValuePrefix;
    }

    public void setELValuePrefix(String valuePrefix) {
        this.fELValuePrefix = valuePrefix;
    }

    public String getVariable() {
        String ref = null;
        if (this.bindingPreviewer != null) {
            ref = this.bindingPreviewer.getBindingPreview(this.selectedNode);
            if (ref == null || "".equals(ref)) {
                ref = this.getReferenceString();
            }
        } else {
            ref = this.getReferenceString();
        }
        int prefix = ref.indexOf(this.fELValuePrefix);
        int suffix = ref.indexOf(this.fELValueSuffix);
        if (prefix != -1 && suffix != -1) {
            ref = ref.substring(prefix + this.fELValuePrefix.length(), suffix);
        }
        return " " + ref + " ";
    }

    public boolean close() {
        boolean ret = super.close();
        if (ret) {
            if (this.model != null && this.bps != null) {
                this.model.getPageDataNotifier().removePageDataChangedListener((IPageDataChangeListener)this.bps);
            }
            this.selectedNode = null;
            this.model = null;
            this.bps = null;
            this.dispose((Control)this.propertiesTree);
            this.dispose((Control)this.referenceStringText);
        }
        return ret;
    }

    private void dispose(Control c) {
        if (c != null && !c.isDisposed()) {
            c.dispose();
        }
        c = null;
    }
}

