/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.sdo.util;

import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.impl.PageDataModelAdapter;
import com.ibm.etools.webtools.pagedataview.sdo.ISDOPageDataNode;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class PageDataNodeUtil {
    public static final IFile getFileFor(IDOMModel model) {
        if (model == null) {
            return null;
        }
        String path = model.getBaseLocation();
        if (path == null || path.length() == 0) {
            String id = model.getId();
            if (id == null) {
                return null;
            }
            path = id.toString();
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Path resourcePath = new Path(path);
        IFile file = resourcePath.toFile().exists() ? root.getFileForLocation((IPath)resourcePath) : root.getFile((IPath)resourcePath);
        return file;
    }

    public static final ISDOPageDataNode[] getPageRecordNodes(IDOMDocument xmlDocument) {
        return PageDataNodeUtil.getPageDataNodes(xmlDocument, new short[]{1});
    }

    public static final ISDOPageDataNode[] getPageRecordSetNodes(IDOMDocument xmlDocument) {
        return PageDataNodeUtil.getPageDataNodes(xmlDocument, new short[]{2});
    }

    public static final ISDOPageDataNode[] getPageDataNodes(IDOMDocument xmlDocument, short[] dataTypes) {
        IPageDataModel pageDataModel;
        EList pageDataNodeList;
        ArrayList<ISDOPageDataNode> ret = new ArrayList<ISDOPageDataNode>();
        PageDataModelAdapter adapter = (PageDataModelAdapter)xmlDocument.getAdapterFor((Object)PageDataModelAdapter.ADAPTER_KEY);
        if (adapter != null && (pageDataNodeList = (pageDataModel = adapter.getPageDataModel()).getRoot().getChildren()) != null) {
            for (Object element : pageDataNodeList) {
                int i;
                if (element instanceof ISDOPageDataNode) {
                    ISDOPageDataNode pageDataNode = (ISDOPageDataNode)element;
                    i = 0;
                    while (i < dataTypes.length) {
                        if (pageDataNode.getDataType() == dataTypes[i]) {
                            ret.add(pageDataNode);
                        }
                        ++i;
                    }
                    continue;
                }
                EList children = ((IPageDataNode)element).getChildren();
                if (children == null) continue;
                i = 0;
                while (i < children.size()) {
                    IPageDataNode child = (IPageDataNode)children.get(i);
                    if (child instanceof ISDOPageDataNode) {
                        ISDOPageDataNode pageDataNode = (ISDOPageDataNode)child;
                        int j = 0;
                        while (j < dataTypes.length) {
                            if (pageDataNode.getDataType() == dataTypes[j]) {
                                ret.add((ISDOPageDataNode)child);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
        return ret.toArray(new ISDOPageDataNode[ret.size()]);
    }

    public static final IPath getWebAppRelativePath(IFile file, IProject project) {
        IPath filePath = file.getLocation();
        IVirtualComponent comp = ComponentUtilities.findComponent((IResource)file);
        IPath webModuleRootLocationPath = comp.getRootFolder().getUnderlyingFolder().getLocation();
        int matchCount = filePath.matchingFirstSegments(webModuleRootLocationPath);
        IPath suffixPath = filePath.removeFirstSegments(matchCount);
        IPath basePath = webModuleRootLocationPath.removeFirstSegments(matchCount);
        int numOfDots = basePath.segmentCount();
        Path webModuleRootRelativePath = new Path("/");
        int i = 1;
        while (i <= numOfDots - 1) {
            webModuleRootRelativePath = webModuleRootRelativePath.append("../");
            ++i;
        }
        webModuleRootRelativePath = webModuleRootRelativePath.append(suffixPath);
        return webModuleRootRelativePath;
    }
}

