/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.sdo.ui;

import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.IBindingAttribute;
import com.ibm.etools.webtools.pagedataview.sdo.ISDOPageDataNode;
import com.ibm.etools.webtools.pagedataview.sdo.nls.ResourceHandler;
import com.ibm.etools.webtools.pagedataview.ui.IPageDataNodeUIAttribute;
import com.ibm.etools.webtools.pagedataview.ui.internal.NonUINodeFilter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;

public class SDORecordSelection {
    private Composite base;
    private Tree recordsTree;
    private TreeViewer recordsTreeViewer;
    protected List input;

    public SDORecordSelection(Composite base, List input) {
        this.base = base;
        this.input = input;
        this.createTreeViewer();
        this.recordsTreeViewer.setContentProvider((IContentProvider)this.createContentProvider());
        this.recordsTreeViewer.setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
        this.createInput();
    }

    protected void createTreeViewer() {
        this.recordsTree = new Tree(this.base, 2052);
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.recordsTree.setLayoutData((Object)data);
        this.recordsTreeViewer = new TreeViewer(this.recordsTree);
        this.recordsTreeViewer.setAutoExpandLevel(2);
    }

    protected void createInput() {
        this.recordsTreeViewer.setInput((Object)this.input);
    }

    protected ITreeContentProvider createContentProvider() {
        return new SDORecordPropertyProvider();
    }

    protected ILabelProvider createLabelProvider() {
        return new SDORecordPropertyLabelProvider();
    }

    public Tree getTree() {
        return this.recordsTree;
    }

    public TreeViewer getTreeViewer() {
        return this.recordsTreeViewer;
    }

    public void setInput(List pageDataNodes) {
        this.input = pageDataNodes;
        this.recordsTreeViewer.setInput((Object)pageDataNodes);
    }

    private final class SDORecordPropertyLabelProvider
    implements ILabelProvider {
        private SDORecordPropertyLabelProvider() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public Image getImage(Object element) {
            IPageDataNode node;
            IPageDataNodeUIAttribute uiNode;
            if (element instanceof IPageDataNode && (uiNode = (IPageDataNodeUIAttribute)(node = (IPageDataNode)element).getAdapter(IPageDataNodeUIAttribute.ADAPTER_KEY)) != null) {
                return uiNode.getIcon(node);
            }
            return null;
        }

        public String getText(Object element) {
            IPageDataNode node;
            IPageDataNodeUIAttribute uiNode;
            if (element instanceof IPageDataNode && (uiNode = (IPageDataNodeUIAttribute)(node = (IPageDataNode)element).getAdapter(IPageDataNodeUIAttribute.ADAPTER_KEY)) != null) {
                return uiNode.getLabel(node);
            }
            return ResourceHandler.UI_Null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private final class SDORecordPropertyProvider
    implements ITreeContentProvider {
        private SDORecordPropertyProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            IPageDataNode node;
            List list;
            if (parentElement instanceof IPageDataNode && (list = this.getSDONodeChildren(node = (IPageDataNode)parentElement)) != null) {
                IPageDataNode[] ret = list.toArray(new IPageDataNode[list.size()]);
                return new NonUINodeFilter().filter(ret);
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IPageDataNode) {
                return !this.getSDONodeChildren((IPageDataNode)element).isEmpty();
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                List allNodes = (List)inputElement;
                ArrayList<IPageDataNode> sdoNodes = new ArrayList<IPageDataNode>();
                if (allNodes != null) {
                    int i = 0;
                    while (i < allNodes.size()) {
                        IPageDataNode node = (IPageDataNode)allNodes.get(i);
                        if (this.isSDONode(node)) {
                            sdoNodes.add(node);
                        } else {
                            List sdoNodesForChild = this.getSDONodeChildren(node);
                            if (!sdoNodesForChild.isEmpty()) {
                                sdoNodes.addAll(sdoNodesForChild);
                            }
                        }
                        ++i;
                    }
                    Object[] ret = sdoNodes.toArray(new IPageDataNode[sdoNodes.size()]);
                    return ret;
                }
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public List getSDONodeChildren(IPageDataNode child) {
            ArrayList<IPageDataNode> sdoNodes = new ArrayList<IPageDataNode>();
            EList subChildren = child.getChildren();
            if (subChildren != null) {
                for (IPageDataNode pdNode : subChildren) {
                    if (!this.isSDONode(pdNode)) continue;
                    sdoNodes.add(pdNode);
                }
            }
            return sdoNodes;
        }

        public boolean isSDONode(IPageDataNode pdNode) {
            IBindingAttribute attr = (IBindingAttribute)pdNode.getAdapter(IBindingAttribute.ADAPTER_KEY);
            return attr != null && pdNode instanceof ISDOPageDataNode;
        }
    }
}

