/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.sdo;

import com.ibm.etools.sdo.ui.provisional.datahandlers.SDOToolsFactory;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNodeProvider;
import com.ibm.etools.webtools.pagedatamodel.util.PageDataModelUtil;
import com.ibm.etools.webtools.pagedataview.sdo.DataListPageDataNode;
import com.ibm.etools.webtools.pagedataview.sdo.DataObjectPageDataNode;
import com.ibm.etools.webtools.pagedataview.sdo.SDOPageDataNode;
import com.ibm.etools.webtools.pagedataview.sdo.util.PageDataNodeUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SDOPageDataNodeProvider
implements IPageDataNodeProvider {
    public IPageDataNode createPageDataNode(IDOMNode node) {
        SDOPageDataNode retWDODataNode = null;
        try {
            if (this.isUseDataObjectTag(node)) {
                SDOToolsFactory factory = this.getSDODataFactory(node);
                factory.setDataType("DataObject");
                IPageDataModel pageDataModel = PageDataModelUtil.getPageDataModel((IDOMNode)node);
                if (pageDataModel != null) {
                    retWDODataNode = new DataObjectPageDataNode(factory, pageDataModel.getRoot(), node);
                }
            } else if (this.isUseDataListTag(node)) {
                SDOToolsFactory factory = this.getSDODataFactory(node);
                factory.setDataType("DataList");
                IPageDataModel pageDataModel = PageDataModelUtil.getPageDataModel((IDOMNode)node);
                if (pageDataModel != null) {
                    retWDODataNode = new DataListPageDataNode(factory, pageDataModel.getRoot(), node);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return retWDODataNode;
    }

    protected SDOToolsFactory getSDODataFactory(IDOMNode node) throws DOMException {
        NamedNodeMap attributes = node.getAttributes();
        Node typeNode = attributes.getNamedItem("datatype");
        String dataType = "RDB";
        if (typeNode != null) {
            dataType = typeNode.getNodeValue();
        }
        typeNode = attributes.getNamedItem("input");
        String inputFile = "";
        if (typeNode != null) {
            inputFile = typeNode.getNodeValue();
        }
        SDOToolsFactory factory = this.getFactory(dataType);
        IFile resolveFile = this.resolveFile(inputFile, node);
        factory.setMetadataFileName(resolveFile.getLocation().toString());
        return factory;
    }

    protected IFile resolveFile(String filename, IDOMNode node) {
        Path fileNamePath = new Path(filename);
        IFile nodeFile = PageDataNodeUtil.getFileFor(node.getModel());
        IVirtualComponent comp = ComponentUtilities.findComponent((IResource)nodeFile);
        IResource res = comp.getRootFolder().getUnderlyingFolder().findMember(filename);
        if (res != null && res.exists() && res.getType() == 1) {
            return (IFile)res;
        }
        return comp.getRootFolder().getUnderlyingFolder().getFile((IPath)fileNamePath);
    }

    private boolean isUseDataListTag(IDOMNode node) {
        String nodeName = node.getNodeName();
        nodeName = nodeName.substring(nodeName.indexOf(58) + 1);
        return nodeName.equalsIgnoreCase("useDataList");
    }

    private boolean isUseDataObjectTag(IDOMNode node) {
        String nodeName = node.getNodeName();
        nodeName = nodeName.substring(nodeName.indexOf(58) + 1);
        return nodeName.equalsIgnoreCase("useDataObject");
    }

    public String getTypeID() {
        return "com.ibm.etools.webtools.pagedataview.WDO";
    }

    public boolean isStaticProvider() {
        return false;
    }

    private SDOToolsFactory getFactory(String dataType) {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        SDOToolsFactory obj = null;
        IExtensionPoint extPoint = pluginRegistry.getExtensionPoint(SDOToolsFactory.ID);
        IConfigurationElement[] configElements = extPoint.getConfigurationElements();
        int i = 0;
        while (i < configElements.length) {
            IConfigurationElement configEl = configElements[i];
            String attVal = configEl.getAttribute("typeID");
            if (attVal.equals(dataType)) {
                try {
                    obj = (SDOToolsFactory)configEl.createExecutableExtension("factoryType");
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        return obj;
    }
}

