/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.sdo;

import com.ibm.etools.sdo.ui.provisional.datahandlers.MediatorException;
import com.ibm.etools.sdo.ui.provisional.datahandlers.SDOToolsFactory;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.impl.PageDataModel;
import com.ibm.etools.webtools.pagedataview.sdo.DataListPageDataNode;
import com.ibm.etools.webtools.pagedataview.sdo.DataObjectPageDataNode;
import com.ibm.etools.webtools.pagedataview.sdo.EClassPageDataNode;
import com.ibm.etools.webtools.pagedataview.sdo.ISDOPageDataNode;
import com.ibm.etools.webtools.pagedataview.sdo.ValidateEditException;
import com.ibm.etools.webtools.pagedataview.sdo.adapters.ISDONodeAdapter;
import com.ibm.etools.webtools.pagedataview.sdo.adapters.ISDONodeAdapterFactory;
import com.ibm.etools.webtools.pagedataview.sdo.adapters.SDOActionDelegateAdapter;
import com.ibm.etools.webtools.pagedataview.sdo.nls.ResourceHandler;
import com.ibm.etools.webtools.pagedataview.sdo.plugin.Logger;
import com.ibm.etools.webtools.pagedataview.sdo.util.PageDataNodeUtil;
import com.ibm.etools.webtools.pagedataview.ui.internal.IActionDelegateAdapter;
import com.ibm.etools.webtools.pagedataview.util.ModelUtil;
import com.ibm.icu.util.StringTokenizer;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public abstract class SDOPageDataNode
extends EClassPageDataNode
implements ISDOPageDataNode {
    private String fCategory = "RelationalRecords";
    protected String fParentFeatureName;
    protected SDOToolsFactory fWDODataFactory;
    private boolean fSDO = true;

    protected SDOPageDataNode(SDOToolsFactory dataFactory) {
        super(null, false);
        this.fWDODataFactory = dataFactory;
        this.refreshFromXMLFile();
    }

    public SDOPageDataNode(SDOToolsFactory dataFactory, IPageDataNode parent, IDOMNode domNode, boolean registerListners) {
        super(parent);
        this.fWDODataFactory = dataFactory;
        this.setDOMNode(domNode);
        this.fWDODataFactory.setProject(this.getDOMFile().getProject());
        this.refreshFromXMLFile();
    }

    @Override
    public void changedMetaDataModel() throws MediatorException {
        IDOMNode domNode;
        this.refreshEClassModel();
        EClass rootModel = this.getSDODataFactory().createModel();
        this.setEClass((EClassifier)rootModel);
        this.refresh();
        IPageDataNode originalNode = this.copy();
        if (this.getPageDataModel() != null) {
            this.getPageDataModel().getPageDataNotifier().firePageNodeChanged(originalNode, (IPageDataNode)this);
        }
        if ((domNode = this.getDOMNode()) != null) {
            domNode.getModel().setDirtyState(true);
        }
    }

    @Override
    public EClass getModel() throws MediatorException {
        if (this.getEClass() == null) {
            this.setEClass((EClassifier)this.getSDODataFactory().getModel());
        }
        return (EClass)this.getEClass();
    }

    public SDOPageDataNode(SDOToolsFactory dataFactory, IPageDataNode parent, IDOMNode domNode) {
        this(dataFactory, parent, domNode, true);
    }

    protected SDOPageDataNode(IPageDataNode parent, EReference refrence) {
        super(parent, refrence);
        if (parent instanceof ISDOPageDataNode) {
            this.fWDODataFactory = ((ISDOPageDataNode)parent).getSDODataFactory();
        }
        this.fParentFeatureName = refrence == null ? null : refrence.getName();
    }

    @Override
    public Object getMetaDataModel() {
        return this.getSDODataFactory().getMetaDataModel();
    }

    public void setMetaDataModel(Object model) {
        this.getSDODataFactory().setMetaDataModel(model);
    }

    @Override
    public String getFilename() {
        NamedNodeMap map = this.getDOMNode().getAttributes();
        Attr attr = (Attr)map.getNamedItem("input");
        if (attr != null) {
            return attr.getValue();
        }
        return null;
    }

    public String getDatatype() {
        NamedNodeMap map = this.getDOMNode().getAttributes();
        Attr attr = (Attr)map.getNamedItem("datatype");
        if (attr != null) {
            return attr.getValue();
        }
        return null;
    }

    @Override
    public Object getAdapter(Class key) {
        if (key.equals(ISDONodeAdapter.class)) {
            ISDONodeAdapterFactory factory = (ISDONodeAdapterFactory)super.getAdapter(ISDONodeAdapter.class);
            if (factory != null) {
                if (this.getDOMNode() != null) {
                    return factory.createSDONodeAdapter((Element)this.getDOMNode());
                }
                return null;
            }
            return null;
        }
        if (key.equals(IActionDelegateAdapter.ADAPTER_KEY)) {
            return new SDOActionDelegateAdapter();
        }
        return super.getAdapter(key);
    }

    @Override
    public boolean refresh(IDOMNode associatedNode, Object changedFeature, Object oldValue, Object newValue) {
        if (changedFeature != null && changedFeature instanceof Attr) {
            Attr changedAttr = (Attr)changedFeature;
            if (changedAttr.getName().equals("id")) {
                this.refreshName();
                return true;
            }
            if (changedAttr.getName().equals("input") && this.getFilename() != null && this.resolveFile(this.getFilename()) != null && this.resolveFile(this.getFilename()).exists()) {
                this.refreshFromXMLFile();
                return true;
            }
        }
        return false;
    }

    @Override
    protected void refresh() {
        try {
            try {
                super.refresh();
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.refreshName();
            }
        }
        finally {
            this.refreshName();
        }
    }

    protected void refreshName() {
        NamedNodeMap map;
        Attr attr;
        if (this.getDOMNode() != null && (attr = (Attr)(map = this.getDOMNode().getAttributes()).getNamedItem("id")) != null) {
            this.setName(attr.getValue());
        }
    }

    public void refreshEClassModel() {
        this.getSDODataFactory().clearModel();
        this.refreshFromXMLFile();
    }

    protected void refreshFromXMLFile() {
        try {
            try {
                EClass rootModel = this.getModel();
                this.setEClass((EClassifier)rootModel);
            }
            catch (MediatorException mediatorException) {
                this.refresh();
            }
        }
        finally {
            this.refresh();
        }
    }

    protected DataListPageDataNode createDataListPageDataNode(IPageDataNode node, EReference reference) {
        return new DataListPageDataNode(node, reference);
    }

    protected DataObjectPageDataNode createDataObjectPageDataNode(IPageDataNode node, EReference reference) {
        return new DataObjectPageDataNode(node, reference);
    }

    protected IFile getDOMFile() {
        try {
            if (this.domNode == null) {
                IDOMDocument document = this.getIDOMDocument(this.getPageDataModel());
                return PageDataNodeUtil.getFileFor(document.getModel());
            }
            return PageDataNodeUtil.getFileFor(this.getDOMNode().getModel());
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected IDOMDocument getIDOMDocument(IPageDataModel pdModel) {
        IDOMDocument doc = null;
        try {
            return ((PageDataModel)pdModel).getIDOMModel().getDocument();
        }
        catch (NullPointerException nullPointerException) {
            return doc;
        }
    }

    protected IFile resolveFile(String filename) {
        IProject currentProject = this.getDOMFile().getProject();
        IVirtualComponent comp = ModelUtil.getComponent((IProject)currentProject, (IDOMNode)this.getDOMNode());
        IResource res = comp.getRootFolder().getFile(filename).getUnderlyingResource();
        IFile ret = null;
        if (res != null && res.getType() == 1) {
            ret = (IFile)res;
        }
        return ret;
    }

    @Override
    public SDOToolsFactory getSDODataFactory() {
        return this.fWDODataFactory;
    }

    protected void refreshFileInWorkspace(IFile file) {
        try {
            IContainer container = file.getParent();
            if (container != null) {
                container.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected void setSDODataFactory(SDOToolsFactory factory) {
        this.fWDODataFactory = factory;
    }

    public String getParentFeatureName() {
        if (this.fParentFeatureName == null) {
            this.fParentFeatureName = this.getSDODataFactory() == null ? null : this.getSDODataFactory().getFeatureName();
        }
        return this.fParentFeatureName;
    }

    @Override
    protected void populateChildren(EClass myClass) {
        if (myClass != null) {
            EList attributes = myClass.getEAllAttributes();
            this.addAttributes((List)attributes);
            EList references = myClass.getEReferences();
            int i = 0;
            while (i < references.size()) {
                EReference refrence;
                if (references.get(i) instanceof EReference && !this.areOpposites(refrence = (EReference)references.get(i), this.getParentFeatureName()) && !this.isInSubPath(refrence)) {
                    if (refrence.isMany()) {
                        this.addChildWithoutNotification((IPageDataNode)this.createDataListPageDataNode((IPageDataNode)this, refrence));
                    } else {
                        this.addChildWithoutNotification((IPageDataNode)this.createDataObjectPageDataNode((IPageDataNode)this, refrence));
                    }
                }
                ++i;
            }
        }
    }

    protected boolean areOpposites(EReference ref, String parentRef) {
        boolean ret = false;
        if (ref != null && parentRef != null && ref.getEOpposite() != null) {
            ret = parentRef.equals(ref.getEOpposite().getName());
        }
        return ret;
    }

    @Override
    public void saveMetaDataModel() throws IOException {
        IStatus status;
        IFile file = this.resolveFile(this.getFilename());
        Shell shell = null;
        Display d = Display.getCurrent();
        if (d != null && (shell = d.getActiveShell()) != null) {
            shell = new Shell();
        }
        if (!(status = file.getWorkspace().validateEdit(new IFile[]{file}, (Object)shell)).isOK()) {
            Logger.logException(String.valueOf(ResourceHandler.Failed_Validate_Edit) + " - " + file.getFullPath() + ": " + status.getMessage(), status.getException());
            throw new ValidateEditException(status);
        }
        this.getSDODataFactory().saveMetaData(this.getMetaDataModel(), URI.createPlatformResourceURI((String)file.getFullPath().toString()));
        this.refreshFileInWorkspace(file);
    }

    @Override
    public boolean isSDO() {
        return this.fSDO;
    }

    public void setSDO(boolean sdo) {
        this.fSDO = sdo;
    }

    public String getSubPath() {
        return this.getSDODataFactory() == null ? null : this.getSDODataFactory().getSubPath();
    }

    protected boolean isInSubPath(EReference ref) {
        boolean ret = false;
        if (this.getSubPath() != null && ref != null && ref.getEOpposite() != null) {
            EReference oppRef = ref.getEOpposite();
            StringTokenizer toker = new StringTokenizer(this.getSubPath(), "/");
            String last_ref = null;
            while (toker.hasMoreTokens()) {
                last_ref = toker.nextToken();
            }
            if (last_ref != null && last_ref.equals(oppRef.getName())) {
                ret = true;
            }
        }
        return ret;
    }

    public String getCategory() {
        return this.fCategory;
    }

    public void setCategory(String pageDataViewCategory) {
        this.fCategory = pageDataViewCategory;
    }
}

