/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.sdo;

import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.ICodeGenModelFactory;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.IBindingAttribute;
import com.ibm.etools.webtools.pagedatamodel.impl.PageDataNode;
import com.ibm.etools.webtools.pagedatamodel.sse.api.ISSEPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.util.PageDataModelUtil;
import com.ibm.etools.webtools.pagedataview.data.IEClassPageDataNode;
import com.ibm.etools.webtools.pagedataview.sdo.ISDOPageDataNode;
import com.ibm.etools.webtools.pagedataview.sdo.SDOCodeGenModelFactory;
import com.ibm.etools.webtools.pagedataview.sdo.nls.ResourceHandler;
import com.ibm.etools.webtools.pagedataview.sdo.ui.EClassPageDataViewAdapter;
import com.ibm.etools.webtools.pagedataview.ui.IPageDataNodeUIAttribute;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class EClassPageDataNode
extends PageDataNode
implements ISSEPageDataNode,
IEClassPageDataNode {
    private EClassifier fEClass;
    private String fName;
    private int fType = 0;
    protected IDOMNode domNode;
    protected IBindingAttribute binding = new IBindingAttribute(){

        public String getName(IPageDataNode object) {
            String ret = null;
            ret = ((EClassPageDataNode)object).getName();
            return ret;
        }

        public String getReferenceString(IPageDataNode object) {
            String ret = null;
            if (object instanceof EClassPageDataNode) {
                ret = EClassPageDataNode.getModelReferenceString((EClassPageDataNode)object);
                String type = this.internalGetRuntimeType(object);
                if (type != null && type.equals("java.util.Calendar")) {
                    ret = String.valueOf(ret) + ".time";
                }
            }
            return ret;
        }

        public String getRuntimeType(IPageDataNode object) {
            String type = this.internalGetRuntimeType(object);
            if (type != null && type.equals("java.util.Calendar")) {
                type = "java.util.Date";
            }
            return type;
        }

        private String internalGetRuntimeType(IPageDataNode object) {
            String type = null;
            if (object instanceof ISDOPageDataNode) {
                ISDOPageDataNode wdo = (ISDOPageDataNode)object;
                if (wdo.getDataType() == 1) {
                    type = "commonj.sdo.DataObject";
                } else if (wdo.getDataType() == 2) {
                    type = List.class.getName();
                }
            } else {
                EClassifier eClass = ((EClassPageDataNode)object).getEClass();
                type = eClass.getInstanceClassName();
                if (eClass != null && eClass.getInstanceClass() != null && eClass.getInstanceClass().isPrimitive()) {
                    type = EcoreUtil.wrapperClassFor((Class)eClass.getInstanceClass()).getName();
                }
            }
            return type;
        }

        public String getTypeAsString(IPageDataNode object) {
            EClassPageDataNode node = (EClassPageDataNode)object;
            if (node instanceof ISDOPageDataNode) {
                ISDOPageDataNode wdoNode = (ISDOPageDataNode)((Object)node);
                if (wdoNode.getDataType() == 2) {
                    return ResourceHandler.UI_DataObject_List;
                }
                if (wdoNode.getDataType() == 1) {
                    return ResourceHandler.UI_DataObject;
                }
            } else {
                ISDOPageDataNode parent = (ISDOPageDataNode)node.getParent();
                if (parent.getDataType() == 2) {
                    return ResourceHandler.UI_DataObject_List_fld;
                }
                if (parent.getDataType() == 1) {
                    return ResourceHandler.UI_DataObject_fld;
                }
            }
            return "";
        }

        public int getCollectionType(IPageDataNode object) {
            if (object instanceof ISDOPageDataNode) {
                ISDOPageDataNode wdo = (ISDOPageDataNode)object;
                if (wdo.getDataType() == 1) {
                    return 3;
                }
                if (wdo.getDataType() == 2) {
                    return 1;
                }
            }
            return 0;
        }

        public String getRelativeReferenceString(IPageDataNode refNode, IPageDataNode object) {
            String fullRef = this.getReferenceString(object);
            if (refNode == null) {
                return fullRef;
            }
            String startRef = this.getReferenceString(refNode);
            if (fullRef.startsWith(String.valueOf(startRef) + ".")) {
                return fullRef.substring(startRef.length() + 1);
            }
            return fullRef;
        }

        public boolean isArrayType(IPageDataNode object) {
            return false;
        }
    };
    protected IPageDataNodeUIAttribute viewAdapter = new EClassPageDataViewAdapter();

    protected EClassPageDataNode(IPageDataNode parent, boolean isModel) {
        super(isModel ? parent.getPageDataModel() : null, parent);
    }

    public EClassPageDataNode(IPageDataNode parent) {
        super(parent.getPageDataModel(), parent);
    }

    public EClassPageDataNode(IPageDataNode parent, EClassifier eClass, String name) {
        this(parent);
        this.setUp(eClass, name, 1);
    }

    public EClassPageDataNode(IPageDataNode parent, EAttribute attribute) {
        this(parent);
        String name = ExtendedMetaData.INSTANCE.getName((EStructuralFeature)attribute);
        this.setUp(attribute.getEType(), name, 3);
    }

    public EClassPageDataNode(IPageDataNode parent, EReference refrence) {
        this(parent);
        String name = ExtendedMetaData.INSTANCE.getName((EStructuralFeature)refrence);
        this.setUp((EClassifier)refrence.getEReferenceType(), name, 2);
    }

    protected void setUp(EClassifier eClass, String name, int type) {
        this.setEClass(eClass);
        this.setName(name);
        this.setType(type);
    }

    public EClassifier getEClass() {
        return this.fEClass;
    }

    public void setEClass(EClassifier eClass) {
        this.fEClass = eClass;
    }

    protected void refresh() {
        this.removeAllChildrenWithoutNotification();
        EClassifier classifier = this.getEClass();
        if (classifier instanceof EClass) {
            EClass myClass = (EClass)classifier;
            this.populateChildren(myClass);
        }
    }

    protected void populateChildren(EClass myClass) {
        if (myClass != null) {
            EList attributes = myClass.getEAllAttributes();
            this.addAttributes((List)attributes);
            EList refrences = myClass.getEReferences();
            int i = 0;
            while (i < refrences.size()) {
                if (refrences.get(i) instanceof EReference) {
                    EReference refrence = (EReference)refrences.get(i);
                    this.addChildWithoutNotification((IPageDataNode)this.createChildNode((IPageDataNode)this, refrence));
                }
                ++i;
            }
        }
    }

    protected void addAttributes(List attributes) {
        int i = 0;
        while (i < attributes.size()) {
            this.addChildWithoutNotification((IPageDataNode)this.createChildNode((IPageDataNode)this, (EAttribute)attributes.get(i)));
            ++i;
        }
    }

    public boolean refresh(IDOMNode associatedNode, Object changedFeature, Object oldValue, Object newValue) {
        return false;
    }

    private void removeAllChildrenWithoutNotification() {
        EList children = this.getChildren();
        if (children != null) {
            children.clear();
        }
    }

    public Object getAdapter(Class key) {
        if (key.equals(IPageDataNodeUIAttribute.ADAPTER_KEY)) {
            return this.viewAdapter;
        }
        if (key.equals(IBindingAttribute.ADAPTER_KEY)) {
            return this.binding;
        }
        return super.getAdapter(key);
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public int getType() {
        return this.fType;
    }

    public boolean hasChildren() {
        boolean children = false;
        if (this.getEClass() instanceof EClass) {
            EClass myClass = (EClass)this.getEClass();
            children = myClass.getEAllAttributes().size() > 0;
            children = children || myClass.getEReferences().size() > 0;
        }
        return children;
    }

    public void setType(int i) {
        this.fType = i;
    }

    public EList getChildren() {
        if (this.hasChildren() && !this.childrenPopulated && this.getEClass() instanceof EClass) {
            this.populateChildren((EClass)this.getEClass());
        }
        return super.getChildren();
    }

    public static String getModelReferenceString(EClassPageDataNode node) {
        StringBuffer ret = new StringBuffer("");
        IBindingAttribute binding = (IBindingAttribute)node.getAdapter(IBindingAttribute.ADAPTER_KEY);
        if (binding.getCollectionType((IPageDataNode)node) == 1 || binding.isArrayType((IPageDataNode)node)) {
            ret.insert(0, String.valueOf(node.getName()) + "[0]");
        } else {
            ret.insert(0, node.getName());
        }
        IPageDataNode parent = node.getParent();
        while (parent != null && parent instanceof EClassPageDataNode) {
            ret.insert(0, ".");
            binding = (IBindingAttribute)parent.getAdapter(IBindingAttribute.ADAPTER_KEY);
            if (binding.getCollectionType(parent) == 1 || binding.isArrayType(parent)) {
                ret.insert(0, String.valueOf(((EClassPageDataNode)parent).getName()) + "[0]");
            } else {
                ret.insert(0, ((EClassPageDataNode)parent).getName());
            }
            parent = parent.getParent();
        }
        return ret.toString();
    }

    public IPageDataNode copy() {
        EClassPageDataNode ret = this.createChildNode(this.getParent());
        if (this.getCategory() != null) {
            ret.setCategory(this.getCategory());
        }
        if (this.getDOMNode() != null) {
            ret.setDOMNode(this.getDOMNode());
        }
        if (this.getEClass() != null) {
            ret.setEClass(this.getEClass());
        }
        if (this.getName() != null) {
            ret.setName(this.getName());
        }
        ret.setType(this.getType());
        return ret;
    }

    public void setAttributeBinding(IBindingAttribute newBinding) {
        this.binding = newBinding;
    }

    public void setViewAdapter(IPageDataNodeUIAttribute newAdapter) {
        this.viewAdapter = newAdapter;
    }

    protected EClassPageDataNode createChildNode(IPageDataNode parent) {
        EClassPageDataNode node = new EClassPageDataNode(parent);
        return node;
    }

    protected EClassPageDataNode createChildNode(IPageDataNode parent, EReference ref) {
        EClassPageDataNode node = new EClassPageDataNode(parent, ref);
        return node;
    }

    protected EClassPageDataNode createChildNode(IPageDataNode parent, EAttribute att) {
        EClassPageDataNode node = new EClassPageDataNode(parent, att);
        return node;
    }

    public ICodeGenModelFactory getCodeGenModelFactory() {
        return new SDOCodeGenModelFactory();
    }

    public void setDOMNode(IDOMNode domNode) {
        this.domNode = domNode;
    }

    public IDOMNode getDOMNode() {
        if (this.domNode == null) {
            EClassPageDataNode parent = this;
            while (parent != null && !PageDataModelUtil.isComponentNode((IPageDataNode)parent)) {
                parent = parent.getParent();
            }
            if (parent != null && parent != this && parent instanceof ISSEPageDataNode) {
                this.domNode = ((ISSEPageDataNode)parent).getDOMNode();
            }
        }
        return this.domNode;
    }
}

