/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.jspscripting.internal;

import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.IBindingAttribute;
import com.ibm.etools.webtools.pagedataview.jspscripting.JSPScriptingPageDataNode;
import com.ibm.etools.webtools.pagedataview.jspscripting.nls.ResourceHandler;
import com.ibm.etools.webtools.pagedataview.ui.ConfigureDialog;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ScriptingNodesConfigureDialog
extends ConfigureDialog
implements SelectionListener {
    private Table table;
    private Button addButton;
    private Button deleteButton;
    private Button editButton;

    public ScriptingNodesConfigureDialog(Shell shell, IPageDataNode nodeToConfigure) {
        super(shell, nodeToConfigure);
    }

    protected Control createDialogArea(Composite parent) {
        Composite clientArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        clientArea.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        clientArea.setLayoutData((Object)gridData);
        new Label(clientArea, 0);
        Label text = new Label(clientArea, 0);
        text.setText(ResourceHandler.UI_CfgDlg_Desc);
        this.table = new Table(clientArea, 67586);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 2;
        gridData.heightHint = 150;
        gridData.widthHint = 350;
        this.table.setLayoutData((Object)gridData);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableColumn[] tableColumns = new TableColumn[2];
        tableColumns[0] = new TableColumn(this.table, 0);
        tableColumns[0].setText(ResourceHandler.UI_CfgDlg_Col1);
        tableColumns[0].setWidth(100);
        tableColumns[1] = new TableColumn(this.table, 0);
        tableColumns[1].setText(ResourceHandler.UI_CfgDlg_Col2);
        tableColumns[1].setWidth(250);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScriptingNodesConfigureDialog.this.handleTableSelected(e);
            }
        });
        this.fillTable();
        Composite buttonBar = new Composite(clientArea, 0);
        layout = new GridLayout(3, false);
        buttonBar.setLayout((Layout)layout);
        gridData = new GridData(128);
        buttonBar.setLayoutData((Object)gridData);
        this.addButton = new Button(buttonBar, 8);
        this.addButton.setText(ResourceHandler.UI_Add);
        this.addButton.addSelectionListener((SelectionListener)this);
        this.editButton = new Button(buttonBar, 8);
        this.editButton.setText(ResourceHandler.UI_Edit);
        this.editButton.addSelectionListener((SelectionListener)this);
        this.editButton.setEnabled(false);
        this.deleteButton = new Button(buttonBar, 8);
        this.deleteButton.setText(ResourceHandler.UI_Delete);
        this.deleteButton.addSelectionListener((SelectionListener)this);
        this.deleteButton.setEnabled(false);
        return clientArea;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
    }

    private void fillTable() {
        EList children = this.nodeToConfigure.getChildren();
        if (children != null && children.size() > 0) {
            int i = 0;
            while (i < children.size()) {
                JSPScriptingPageDataNode child = (JSPScriptingPageDataNode)((Object)children.get(i));
                TableItem item = new TableItem(this.table, 0);
                IBindingAttribute binding = this.getBindingAttr(child);
                item.setText(0, binding.getName((IPageDataNode)child));
                if (child.getRuntimeType() != null) {
                    item.setText(1, child.getRuntimeType());
                }
                ++i;
            }
        }
    }

    private IBindingAttribute getBindingAttr(JSPScriptingPageDataNode child) {
        IBindingAttribute binding = (IBindingAttribute)child.getAdapter(IBindingAttribute.ADAPTER_KEY);
        return binding;
    }

    protected void handleTableSelected(SelectionEvent e) {
        int count = this.table.getSelectionCount();
        if (count > 1) {
            this.deleteButton.setEnabled(false);
            this.editButton.setEnabled(false);
        } else {
            this.deleteButton.setEnabled(true);
            this.editButton.setEnabled(true);
        }
    }

    protected void handleAddButton() {
        JSPScriptingPageDataNode parent = (JSPScriptingPageDataNode)this.nodeToConfigure;
        JSPScriptingPageDataNode child = parent.createChildByPrompt(true);
        if (child != null) {
            TableItem newTi = new TableItem(this.table, 0);
            newTi.setText(0, this.getBindingAttr(child).getName((IPageDataNode)child));
            if (child.getRuntimeType() != null) {
                newTi.setText(1, child.getRuntimeType());
            }
            this.table.deselectAll();
            this.table.select(this.table.getItemCount() - 1);
        }
    }

    protected void handleEditButton() {
        JSPScriptingPageDataNode parent = (JSPScriptingPageDataNode)this.nodeToConfigure;
        JSPScriptingPageDataNode child = null;
        int idx = this.table.getSelectionIndex();
        String selectedName = this.table.getItem(idx).getText(0);
        String selectedRuntimeType = this.table.getItem(idx).getText(1);
        EList childList = parent.getChildren();
        int i = 0;
        while (i < childList.size()) {
            JSPScriptingPageDataNode currentChild = (JSPScriptingPageDataNode)((Object)childList.get(i));
            if (this.getBindingAttr(currentChild).getName((IPageDataNode)currentChild).equals(selectedName) && this.getBindingAttr(currentChild).getRuntimeType((IPageDataNode)currentChild).equals(selectedRuntimeType)) {
                child = currentChild.updateByPrompt(true);
            }
            ++i;
        }
        if (child != null) {
            this.table.getItem(idx).setText(0, this.getBindingAttr(child).getName(child));
            if (child.getRuntimeType() != null) {
                this.table.getItem(idx).setText(1, this.getBindingAttr(child).getRuntimeType((IPageDataNode)child));
            }
        }
        this.table.deselectAll();
        this.table.select(idx);
    }

    protected void handleDeleteButton() {
        int idx = this.table.getSelectionIndex();
        if (idx >= 0 && this.table.getItem(idx) != null) {
            this.table.remove(idx);
            this.table.deselectAll();
            if (this.table.getItemCount() > 0) {
                if (idx <= this.table.getItemCount() - 1) {
                    this.table.select(idx);
                } else {
                    this.table.select(this.table.getItemCount() - 1);
                }
            }
        }
        this.rebuildFromTable();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        String title = NLS.bind((String)ResourceHandler.UI_CfgDlg_Title, (Object[])new String[]{this.getNodeName()});
        newShell.setText(title);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.addButton) {
            this.handleAddButton();
        } else if (e.widget == this.deleteButton) {
            this.handleDeleteButton();
        } else if (e.widget == this.editButton) {
            this.handleEditButton();
        }
    }

    private void rebuildFromTable() {
        EList children = this.nodeToConfigure.getChildren();
        if (children != null && children.size() > 0) {
            int i = children.size() - 1;
            while (i >= 0) {
                IPageDataNode child = (IPageDataNode)children.get(i);
                child.getParent().removeChild(child);
                ((JSPScriptingPageDataNode)child).persist(false);
                --i;
            }
        }
        JSPScriptingPageDataNode parent = (JSPScriptingPageDataNode)this.nodeToConfigure;
        TableItem[] entries = this.table.getItems();
        int i = 0;
        while (i < entries.length) {
            String value = entries[i].getText(0);
            String type = entries[i].getText(1);
            parent.createChild(value, type, true);
            ++i;
        }
    }

    protected void okPressed() {
        super.okPressed();
    }
}

