/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.jspscripting.internal;

import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.util.PageDataModelUtil;
import com.ibm.etools.webtools.pagedataview.javabean.ContainedTypePageDataNode;
import com.ibm.etools.webtools.pagedataview.javabean.JavaBeanPageDataNode;
import com.ibm.etools.webtools.pagedataview.jspscripting.JSPScriptingPageDataNode;
import com.ibm.etools.webtools.pagedataview.util.PersistenceManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JSPPersistenceManager
extends PersistenceManager {
    public JSPPersistenceManager() {
    }

    public JSPPersistenceManager(List toNotify) {
        super(toNotify);
    }

    public static JSPPersistenceManager getJSPInstance() {
        fPersistenceManager = fPersistenceManager != null ? new JSPPersistenceManager(fPersistenceManager.getToNotify()) : new JSPPersistenceManager();
        return (JSPPersistenceManager)fPersistenceManager;
    }

    protected static Element getParamElement(Document doc, String id) {
        Element jspScriptingRoot;
        Element element = null;
        if (doc != null && (jspScriptingRoot = JSPPersistenceManager.getElement((Document)doc, null, (String)"jsp-scripting")) != null) {
            NodeList nodes = jspScriptingRoot.getElementsByTagName("param");
            int i = 0;
            while (i < nodes.getLength()) {
                if (((Element)nodes.item(i)).getAttribute("id").equalsIgnoreCase(id)) {
                    element = (Element)nodes.item(i);
                    break;
                }
                ++i;
            }
            if (element == null) {
                element = doc.createElement("param");
                element.setAttribute("id", id);
                jspScriptingRoot.appendChild(element);
            }
        }
        return element;
    }

    protected static Element getRequestElement(Document doc, String id) {
        Element jspScriptingRoot;
        Element element = null;
        if (doc != null && (jspScriptingRoot = JSPPersistenceManager.getElement((Document)doc, null, (String)"jsp-scripting")) != null) {
            NodeList nodes = jspScriptingRoot.getElementsByTagName("request");
            int i = 0;
            while (i < nodes.getLength()) {
                if (((Element)nodes.item(i)).getAttribute("id").equalsIgnoreCase(id)) {
                    element = (Element)nodes.item(i);
                    break;
                }
                ++i;
            }
            if (element == null) {
                element = doc.createElement("request");
                element.setAttribute("id", id);
                jspScriptingRoot.appendChild(element);
            }
        }
        return element;
    }

    protected static boolean addProjectWideVariable(IProject project, String elementName, String variableName, String variableType) {
        Element var;
        Document doc = JSPPersistenceManager.getPersistenceDocument((IProject)project, (boolean)true);
        Element element = JSPPersistenceManager.getElement((Document)doc, (String)"jsp-scripting", (String)elementName);
        if (element != null && (var = JSPPersistenceManager.findChildElement((Element)element, (String)"variable", (String)"name", (String)variableName)) == null) {
            Element newVariableElement = doc.createElement("variable");
            newVariableElement.setAttribute("name", variableName);
            if (variableType != null && !variableType.equals("")) {
                newVariableElement.setAttribute("type", variableType);
            }
            element.appendChild(newVariableElement);
            JSPPersistenceManager.writePersistenceDocument((IProject)project, (Document)doc);
            return true;
        }
        return false;
    }

    protected static boolean renameProjectWideVariable(IProject project, String elementName, String oldVariableName, String newVariableName) {
        Element var;
        Document doc = JSPPersistenceManager.getPersistenceDocument((IProject)project, (boolean)false);
        Element element = JSPPersistenceManager.getElement((Document)doc, (String)"jsp-scripting", (String)elementName);
        if (element != null && (var = JSPPersistenceManager.findChildElement((Element)element, (String)"variable", (String)"name", (String)oldVariableName)) != null) {
            var.setAttribute("name", newVariableName);
            Element colProp = JSPPersistenceManager.findChildElement((Element)var, (String)"collectionProperty", (String)"name", (String)oldVariableName);
            if (colProp != null) {
                colProp.setAttribute("name", newVariableName);
            }
            JSPPersistenceManager.writePersistenceDocument((IProject)project, (Document)doc);
            return true;
        }
        return false;
    }

    protected static boolean removeProjectWideVariable(IProject project, String elementName, String variableName) {
        Element var;
        Document doc = JSPPersistenceManager.getPersistenceDocument((IProject)project, (boolean)false);
        Element element = JSPPersistenceManager.getElement((Document)doc, (String)"jsp-scripting", (String)elementName);
        if (element != null && (var = JSPPersistenceManager.findChildElement((Element)element, (String)"variable", (String)"name", (String)variableName)) != null) {
            var.getParentNode().removeChild(var);
            JSPPersistenceManager.writePersistenceDocument((IProject)project, (Document)doc);
            return true;
        }
        return false;
    }

    protected static List getProjectWideVariables(IProject project, String elementName) {
        Document doc = JSPPersistenceManager.getPersistenceDocument((IProject)project, (boolean)false);
        Element element = JSPPersistenceManager.getElement((Document)doc, (String)"jsp-scripting", (String)elementName);
        if (element != null) {
            return JSPPersistenceManager.getVariables((Element)element, (String)"variable");
        }
        return null;
    }

    public static void addApplicationVariable(IProject project, String variableName, String type) {
        if (JSPPersistenceManager.addProjectWideVariable(project, "application", variableName, type)) {
            JSPPersistenceManager.sendNotifications();
        }
    }

    public static void renameApplicationVariable(IProject project, String oldVariableName, String newVariableName) {
        if (JSPPersistenceManager.renameProjectWideVariable(project, "application", oldVariableName, newVariableName)) {
            JSPPersistenceManager.sendNotifications();
        }
    }

    public static void removeApplicationVariable(IProject project, String variableName) {
        if (JSPPersistenceManager.removeProjectWideVariable(project, "application", variableName)) {
            JSPPersistenceManager.sendNotifications();
        }
    }

    public static List getApplicationVariables(IProject project) {
        return JSPPersistenceManager.getProjectWideVariables(project, "application");
    }

    public static void addSessionVariable(IProject project, String variableName, String type) {
        if (JSPPersistenceManager.addProjectWideVariable(project, "session", variableName, type)) {
            JSPPersistenceManager.sendNotifications();
        }
    }

    public static void renameSessionVariable(IProject project, String oldVariableName, String newVariableName) {
        if (JSPPersistenceManager.renameProjectWideVariable(project, "session", oldVariableName, newVariableName)) {
            JSPPersistenceManager.sendNotifications();
        }
    }

    public static void removeSessionVariable(IProject project, String variableName) {
        if (JSPPersistenceManager.removeProjectWideVariable(project, "session", variableName)) {
            JSPPersistenceManager.sendNotifications();
        }
    }

    public static List getSessionVariables(IProject project) {
        return JSPPersistenceManager.getProjectWideVariables(project, "session");
    }

    public static void addParamVariable(IFile file, String variableName, String type) {
        Element var;
        Document doc = JSPPersistenceManager.getPersistenceDocument((IProject)file.getProject(), (boolean)true);
        Element requestElement = JSPPersistenceManager.getParamElement(doc, file.getFullPath().toString());
        if (requestElement != null && (var = JSPPersistenceManager.findChildElement((Element)requestElement, (String)"variable", (String)"name", (String)variableName)) == null) {
            Element newVariableElement = doc.createElement("variable");
            newVariableElement.setAttribute("name", variableName);
            if (type != null && !type.equals("")) {
                newVariableElement.setAttribute("type", type);
            }
            requestElement.appendChild(newVariableElement);
            JSPPersistenceManager.writePersistenceDocument((IProject)file.getProject(), (Document)doc);
        }
    }

    public static void removeParamVariable(IFile file, String variableName) {
        Element var;
        Document doc = JSPPersistenceManager.getPersistenceDocument((IProject)file.getProject(), (boolean)false);
        Element requestElement = JSPPersistenceManager.getParamElement(doc, file.getFullPath().toString());
        if (requestElement != null && (var = JSPPersistenceManager.findChildElement((Element)requestElement, (String)"variable", (String)"name", (String)variableName)) != null) {
            var.getParentNode().removeChild(var);
            JSPPersistenceManager.writePersistenceDocument((IProject)file.getProject(), (Document)doc);
        }
    }

    public static List getParamVariables(IFile file) {
        Document doc = JSPPersistenceManager.getPersistenceDocument((IProject)file.getProject(), (boolean)false);
        Element requestElement = JSPPersistenceManager.getParamElement(doc, file.getFullPath().toString());
        if (requestElement != null) {
            return JSPPersistenceManager.getVariables((Element)requestElement, (String)"variable");
        }
        return null;
    }

    public static void addRequestVariable(IFile file, String variableName, String type) {
        Element var;
        Document doc = JSPPersistenceManager.getPersistenceDocument((IProject)file.getProject(), (boolean)true);
        Element requestElement = JSPPersistenceManager.getRequestElement(doc, file.getFullPath().toString());
        if (requestElement != null && (var = JSPPersistenceManager.findChildElement((Element)requestElement, (String)"variable", (String)"name", (String)variableName)) == null) {
            Element newVariableElement = doc.createElement("variable");
            newVariableElement.setAttribute("name", variableName);
            if (type != null && !type.equals("")) {
                newVariableElement.setAttribute("type", type);
            }
            requestElement.appendChild(newVariableElement);
            JSPPersistenceManager.writePersistenceDocument((IProject)file.getProject(), (Document)doc);
        }
    }

    public static void renameRequestVariable(IFile file, String oldVariableName, String newVariableName) {
        Element var;
        Document doc = JSPPersistenceManager.getPersistenceDocument((IProject)file.getProject(), (boolean)false);
        Element requestElement = JSPPersistenceManager.getRequestElement(doc, file.getFullPath().toString());
        if (requestElement != null && (var = JSPPersistenceManager.findChildElement((Element)requestElement, (String)"variable", (String)"name", (String)oldVariableName)) != null) {
            var.setAttribute("name", newVariableName);
            Element colProp = JSPPersistenceManager.findChildElement((Element)var, (String)"collectionProperty", (String)"name", (String)oldVariableName);
            if (colProp != null) {
                colProp.setAttribute("name", newVariableName);
            }
            JSPPersistenceManager.writePersistenceDocument((IProject)file.getProject(), (Document)doc);
        }
    }

    public static void removeRequestVariable(IFile file, String variableName) {
        Element var;
        Document doc = JSPPersistenceManager.getPersistenceDocument((IProject)file.getProject(), (boolean)false);
        Element requestElement = JSPPersistenceManager.getRequestElement(doc, file.getFullPath().toString());
        if (requestElement != null && (var = JSPPersistenceManager.findChildElement((Element)requestElement, (String)"variable", (String)"name", (String)variableName)) != null) {
            var.getParentNode().removeChild(var);
            JSPPersistenceManager.writePersistenceDocument((IProject)file.getProject(), (Document)doc);
        }
    }

    public static List getRequestVariables(IFile file) {
        Document doc = JSPPersistenceManager.getPersistenceDocument((IProject)file.getProject(), (boolean)false);
        Element requestElement = JSPPersistenceManager.getRequestElement(doc, file.getFullPath().toString());
        if (requestElement != null) {
            return JSPPersistenceManager.getVariables((Element)requestElement, (String)"variable");
        }
        return null;
    }

    public static void registerForNotification(JSPScriptingPageDataNode variable) {
        List list = JSPPersistenceManager.getInstance().getToNotify();
        if (!list.contains((Object)variable)) {
            list.add(variable);
        }
    }

    public static void deregisterFromNotification(JSPScriptingPageDataNode variable) {
        JSPPersistenceManager.getInstance().getToNotify().remove((Object)variable);
    }

    protected static void sendNotifications() {
        List list = JSPPersistenceManager.getInstance().getToNotify();
        if (list.size() > 0) {
            int size = list.size();
            int i = 0;
            while (i < size) {
                JSPScriptingPageDataNode one = (JSPScriptingPageDataNode)((Object)list.get(i));
                one.loadChildren(true);
                ++i;
            }
        }
    }

    protected static void sendNotifications(IPageDataNode pdn) {
        List list = JSPPersistenceManager.getInstance().getToNotify();
        if (list.size() > 0) {
            int size = list.size();
            int i = 0;
            while (i < size) {
                JSPScriptingPageDataNode one = (JSPScriptingPageDataNode)((Object)list.get(i));
                if (!((Object)((Object)one)).equals(pdn)) {
                    one.loadChildren(true);
                }
                ++i;
            }
        }
    }

    public String processPersistenceInfo(IPageDataNode cPdn, String param1, int action) {
        List allVars;
        IPageDataNode parent;
        String ret = null;
        IPageDataNode componentNode = parent = cPdn.getParent();
        IPageDataNode variableNode = parent;
        int depth = 1;
        IFile file = parent.getPageDataModel().getResource();
        String filename = file.getFullPath().toString();
        IProject project = file.getProject();
        while (!PageDataModelUtil.isComponentNode((IPageDataNode)componentNode)) {
            componentNode = componentNode.getParent();
        }
        while (!(variableNode instanceof JSPScriptingPageDataNode)) {
            variableNode = variableNode.getParent();
        }
        while (parent instanceof ContainedTypePageDataNode) {
            parent = parent.getParent();
            ++depth;
        }
        String elementName = JSPPersistenceManager.getElementName(((JavaBeanPageDataNode)componentNode).getClassName());
        String variableName = ((JavaBeanPageDataNode)variableNode).getInstanceID();
        String variableType = ((JavaBeanPageDataNode)variableNode).getClassName();
        Element varElem = JSPPersistenceManager.findVariableElement(file, elementName, variableName, variableType);
        String propertyName = ((JavaBeanPageDataNode)parent).getInstanceID();
        IPageDataNode temp = parent;
        while (!(temp instanceof ContainedTypePageDataNode) && !PageDataModelUtil.isComponentNode((IPageDataNode)temp)) {
            temp = temp.getParent();
        }
        if (temp instanceof ContainedTypePageDataNode && (allVars = JSPPersistenceManager.findVariableEntries(file, elementName, variableType = ((JavaBeanPageDataNode)temp).getClassName())) != null && allVars.size() > 0) {
            varElem = (Element)allVars.get(0);
        }
        if (action == 1 && param1 != null) {
            JSPPersistenceManager.addContainsNodesToPropertyElement(project, elementName, varElem, filename, propertyName, param1);
        } else if (action == 2) {
            JSPPersistenceManager.removeNodeContainedType((IProject)project, (Element)varElem, (String)propertyName, (int)depth);
        } else if (action == 3) {
            ret = super.getContainedType(varElem, propertyName, depth);
            if (ret == null) {
                List allVarsFromScope = JSPPersistenceManager.findVariableEntries(file, elementName, variableType);
                Element objToRemove = null;
                int i = 0;
                while (i < allVarsFromScope.size()) {
                    Element currentElem = (Element)allVarsFromScope.get(i);
                    if (currentElem != null && currentElem.getAttribute("name").equals(variableName)) {
                        objToRemove = currentElem;
                        break;
                    }
                    ++i;
                }
                allVarsFromScope.remove(objToRemove);
                if (allVarsFromScope.size() > 0) {
                    varElem = (Element)allVarsFromScope.get(0);
                    ret = super.getContainedType(varElem, propertyName, depth);
                }
            }
        } else if (action == 4) {
            JSPPersistenceManager.removeNodeContainedType((IProject)project, (Element)varElem, (String)propertyName, (int)depth);
            JSPPersistenceManager.addContainsNodesToPropertyElement(project, elementName, varElem, filename, propertyName, param1);
        }
        if ((action == 1 || action == 2 || action == 4) && (elementName.equals("session") || elementName.equals("application"))) {
            JSPPersistenceManager.sendNotifications(componentNode);
        }
        return ret;
    }

    private static List getVariablesList(IFile file, String elementName) {
        List variables = new ArrayList();
        if (elementName != null) {
            if (elementName.equals("session")) {
                variables = JSPPersistenceManager.getSessionVariables(file.getProject());
            } else if (elementName.equals("application")) {
                variables = JSPPersistenceManager.getApplicationVariables(file.getProject());
            } else if (elementName.equals("request")) {
                variables = JSPPersistenceManager.getRequestVariables(file);
            } else if (elementName.equals("param")) {
                variables = JSPPersistenceManager.getParamVariables(file);
            }
        }
        return variables;
    }

    private static Element findVariableElement(IFile file, String elementName, String variableName, String variableType) {
        List variables = JSPPersistenceManager.getVariablesList(file, elementName);
        if (variables != null) {
            int i = 0;
            while (i < variables.size()) {
                Element currentVar = (Element)variables.get(i);
                if (currentVar.getAttribute("name").equals(variableName) && currentVar.getAttribute("type").equals(variableType)) {
                    return currentVar;
                }
                ++i;
            }
        }
        return null;
    }

    private static List findVariableEntries(IFile file, String scope, String variableType) {
        List variables = JSPPersistenceManager.getVariablesList(file, scope);
        ArrayList<Element> ret = new ArrayList<Element>();
        int i = 0;
        while (i < variables.size()) {
            Element currentElem = (Element)variables.get(i);
            if (currentElem.getAttribute("type").equals(variableType)) {
                ret.add(currentElem);
            }
            ++i;
        }
        return ret;
    }

    public static boolean checkVarExistence(String elementName, String variableName, IFile file) {
        List variables = JSPPersistenceManager.getVariablesList(file, JSPPersistenceManager.getElementName(elementName));
        if (variables != null && variables.size() > 0) {
            int i = 0;
            while (i < variables.size()) {
                Element currentVar = (Element)variables.get(i);
                if (currentVar.getAttribute("name").equals(variableName)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private static void addContainsNodesToPropertyElement(IProject project, String elementName, Element variableElement, String filename, String propertyName, String containsType) {
        if (variableElement != null) {
            Element collectionProperty = JSPPersistenceManager.findChildElement((Element)variableElement, (String)"collectionProperty", (String)"name", (String)propertyName);
            if (collectionProperty == null) {
                collectionProperty = variableElement.getOwnerDocument().createElement("collectionProperty");
                collectionProperty.setAttribute("name", propertyName);
                variableElement.appendChild(collectionProperty);
            }
            JSPPersistenceManager.addContainsNodesToPropertyElement((Element)collectionProperty, (String)containsType);
            JSPPersistenceManager.writePersistenceDocument((IProject)project, (Document)collectionProperty.getOwnerDocument());
        }
    }

    private static String getElementName(String className) {
        if (className != null) {
            if (className.equals("sessionScope")) {
                return "session";
            }
            if (className.equals("requestScope")) {
                return "request";
            }
            if (className.equals("applicationScope")) {
                return "application";
            }
            if (className.equals("param")) {
                return "param";
            }
        }
        return null;
    }
}

