/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.jspscripting;

import com.ibm.etools.webtools.pagedataview.jspscripting.internal.JSPPersistenceManager;
import com.ibm.etools.webtools.pagedataview.jspscripting.nls.ResourceHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;

public class SimpleTextDialog
extends Dialog
implements Listener {
    private String value;
    private Text valueText;
    private String runtimeType;
    private Text runtimeTypeText;
    private boolean allowCustomType;
    private String message;
    private String labelText;
    private String titleText;
    private Button browseType;
    private Label errorMsg;
    private IProject project;
    private String scope;
    private IFile file;
    private String originalName;

    public SimpleTextDialog(Shell parentShell, IProject project, String title, String msg, String label, String scope, IFile file) {
        super(parentShell);
        this.scope = scope;
        this.file = file;
        this.initializeDialog(project, title, msg, label);
    }

    public SimpleTextDialog(Shell parentShell, IProject project, String title, String msg, String label) {
        super(parentShell);
        this.initializeDialog(project, title, msg, label);
    }

    private void initializeDialog(IProject project, String title, String msg, String label) {
        this.titleText = title;
        this.message = msg;
        this.labelText = label;
        this.allowCustomType = true;
        this.project = project;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.titleText);
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        composite.setLayout((Layout)layout);
        Label label1 = new Label(composite, 0);
        GridData data = new GridData();
        data.horizontalSpan = 3;
        label1.setLayoutData((Object)data);
        label1.setText(this.message);
        Composite childArea = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        childArea.setLayout((Layout)layout);
        Label label2 = new Label(childArea, 0);
        data = new GridData(32);
        label2.setLayoutData((Object)data);
        label2.setText(this.labelText);
        this.valueText = new Text(childArea, 2048);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.valueText.setLayoutData((Object)data);
        this.valueText.addListener(24, (Listener)this);
        Label label3 = new Label(childArea, 0);
        data = new GridData(32);
        label3.setLayoutData((Object)data);
        label3.setText(ResourceHandler.UI_Type_);
        this.runtimeTypeText = new Text(childArea, 2048);
        data = new GridData(512);
        this.runtimeTypeText.setLayoutData((Object)data);
        GridData gData = new GridData(4);
        gData.widthHint = 300;
        this.runtimeTypeText.setLayoutData((Object)gData);
        if (this.runtimeType != null) {
            this.runtimeTypeText.setText(this.runtimeType);
        }
        if (!this.allowCustomType) {
            this.runtimeTypeText.setEnabled(false);
        }
        this.runtimeTypeText.addListener(24, (Listener)this);
        this.browseType = new Button(childArea, 8);
        data = new GridData(128);
        this.browseType.setLayoutData((Object)data);
        this.browseType.setText(ResourceHandler.UI____);
        this.browseType.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.result = ResourceHandler.UI_AddDlg_Title;
                }
            }
        });
        this.browseType.addListener(13, (Listener)this);
        if (!this.allowCustomType) {
            this.browseType.setEnabled(false);
        }
        this.errorMsg = new Label(childArea, 0);
        data = new GridData(256);
        data.horizontalSpan = 3;
        this.errorMsg.setLayoutData((Object)data);
        this.errorMsg.setForeground(ColorConstants.red);
        this.originalName = this.getValue();
        return composite;
    }

    public String getValue() {
        return this.value;
    }

    public String getRuntimeType() {
        return this.runtimeType;
    }

    public void handleEvent(Event event) {
        if (event.widget == this.browseType) {
            this.handleBrowseButtonPressed();
        } else if (event.widget == this.runtimeTypeText || event.widget == this.valueText) {
            this.validateUserInput();
        }
    }

    private void validateUserInput() {
        this.runtimeType = this.runtimeTypeText.getText();
        this.runtimeType = this.runtimeType.trim();
        this.value = this.valueText.getText();
        this.value = this.value.trim();
        if (this.value == null || this.value.equals("")) {
            this.errorMsg.setText(NLS.bind((String)ResourceHandler.UI_CNT_B_NULL, (Object[])new String[]{this.labelText}));
            this.getButton(0).setEnabled(false);
        } else if (this.runtimeType == null || this.runtimeType.equals("")) {
            this.errorMsg.setText(NLS.bind((String)ResourceHandler.UI_CNT_B_NULL, (Object[])new String[]{ResourceHandler.UI_Type_}));
            this.getButton(0).setEnabled(false);
        } else {
            IStatus val = JavaConventions.validatePackageName((String)this.value);
            if (val.getSeverity() == 4) {
                this.errorMsg.setText(val.getMessage());
                this.getButton(0).setEnabled(false);
                return;
            }
            if (this.scope != null && this.file != null) {
                boolean pmResult = false;
                pmResult = this.originalName != null ? (!this.originalName.equals(this.value) ? this.checkWithPM(this.scope, this.value, this.file) : true) : this.checkWithPM(this.scope, this.value, this.file);
                if (!pmResult) {
                    this.errorMsg.setText(NLS.bind((String)ResourceHandler.UI_VAR_EXISTS, (Object[])new String[]{this.value}));
                    this.getButton(0).setEnabled(false);
                    return;
                }
            }
            IJavaProject jProj = JavaCore.create((IProject)this.project);
            try {
                IType type;
                boolean isArrayType = false;
                if (this.runtimeType.endsWith("[]")) {
                    isArrayType = true;
                    int strLen = this.runtimeType.length();
                    this.runtimeType = this.runtimeType.substring(0, strLen - 2);
                }
                if ((type = jProj.findType(this.runtimeType)) == null) {
                    this.errorMsg.setText(NLS.bind((String)ResourceHandler.UI_TYPE_NOT_FOUND, (Object[])new String[]{this.runtimeType}));
                    this.getButton(0).setEnabled(false);
                } else {
                    this.errorMsg.setText("");
                    this.getButton(0).setEnabled(true);
                }
                if (isArrayType) {
                    this.runtimeType = this.runtimeType.concat("[]");
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean checkWithPM(String scope, String value, IFile file) {
        if (JSPPersistenceManager.checkVarExistence(scope, value, file)) {
            this.errorMsg.setText(NLS.bind((String)ResourceHandler.UI_VAR_EXISTS, (Object[])new String[]{value}));
            this.getButton(0).setEnabled(false);
            return false;
        }
        this.errorMsg.setText("");
        this.getButton(0).setEnabled(true);
        return true;
    }

    protected void handleBrowseButtonPressed() {
        try {
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)new ProgressMonitorDialog(this.getShell()), (IProject)this.project, (int)256, (boolean)false);
            dialog.setTitle(ResourceHandler.UI_AddDlg_Title);
            dialog.setMessage(ResourceHandler.UI_AddDlg_Desc);
            if (dialog.open() == 0) {
                this.runtimeTypeText.setText(((IType)dialog.getResult()[0]).getFullyQualifiedName());
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    protected Control createContents(Composite parent) {
        Control ret = super.createContents(parent);
        if (this.value != null) {
            this.valueText.setText(this.value);
        }
        if (this.runtimeType != null) {
            this.runtimeTypeText.setText(this.runtimeType);
        }
        return ret;
    }

    public void setRuntimeType(String string) {
        this.runtimeType = string;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public boolean isAllowCustomType() {
        return this.allowCustomType;
    }

    public void setAllowCustomType(boolean allowCustomType) {
        this.allowCustomType = allowCustomType;
    }
}

