/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.jsp.dnd;

import com.ibm.etools.webedit.common.commands.CompoundHTMLCommand;
import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webedit.common.commands.InsertHeadObjectCommand;
import com.ibm.etools.webedit.common.commands.utils.HeadElementModifier;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.CodeGenerationOperation;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenModel;
import com.ibm.etools.webtools.pagedataview.commands.InsertSourceTextCommand;
import com.ibm.etools.webtools.pagedataview.jsp.nls.ResourceHandler;
import com.ibm.etools.webtools.webproject.features.taglibs.internal.JSPStandardFeatureFactory;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class JSTLCodeGenOperation
implements IRunnableWithProgress {
    private ICodeGenModel model;
    private CompoundHTMLCommand commandList;

    public JSTLCodeGenOperation(ICodeGenModel model, CompoundHTMLCommand commandList) {
        this.model = model;
        this.commandList = commandList;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        StringWriter out = new StringWriter();
        PrintWriter writer = new PrintWriter(out);
        monitor.beginTask(ResourceHandler.Gen_In_Prog, 5);
        CodeGenerationOperation op = new CodeGenerationOperation(this.model, writer);
        try {
            monitor.subTask(ResourceHandler.Gen_Src);
            op.run(monitor);
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
        writer.flush();
        String source = out.toString();
        if (monitor.isCanceled()) {
            return;
        }
        monitor.worked(2);
        Map newTaglibs = (Map)this.model.getCustomProperty((Object)"new_taglibs");
        if (newTaglibs != null) {
            monitor.subTask(ResourceHandler.Gen_Chk_TL);
            for (String prefix : newTaglibs.keySet()) {
                String uri = (String)newTaglibs.get(prefix);
                InsertHeadObjectCommand cmd = new InsertHeadObjectCommand();
                cmd.setElementFilter((HeadElementModifier.ElementFilter)cmd.getDirectiveTaglibFilter(uri, prefix));
                this.commandList.append((HTMLCommand)cmd);
            }
            if (monitor.isCanceled()) {
                return;
            }
            monitor.worked(1);
            this.checkOnDemandJSTLLoading(monitor);
            monitor.worked(2);
        }
        this.commandList.append((HTMLCommand)new InsertSourceTextCommand("Insert generated code", source));
        monitor.done();
    }

    private void checkOnDemandJSTLLoading(IProgressMonitor monitor) {
        IProject project = this.model.getTarget().getWebModel().getComponent().getProject();
        JSPStandardFeatureFactory.addFeature((IProject)project, null, null, (IProgressMonitor)monitor, null);
    }
}

