/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.jsp.dnd;

import com.ibm.etools.webedit.common.commands.CompoundHTMLCommand;
import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webedit.common.commands.factories.CustomTagFactory;
import com.ibm.etools.webedit.common.commands.factories.NodeFactory;
import com.ibm.etools.webedit.common.commands.utils.EditModelQuery;
import com.ibm.etools.webedit.common.commands.utils.EditQueryUtil;
import com.ibm.etools.webedit.extension.DropTargetObject;
import com.ibm.etools.webtools.model.ModelManager;
import com.ibm.etools.webtools.model.WebModelCreationException;
import com.ibm.etools.webtools.model.api.JSP;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.CodeGenModelFactory;
import com.ibm.etools.webtools.pagedatamodel.databinding.CodeGenUtil;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.IBindingAttribute;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenModel;
import com.ibm.etools.webtools.pagedatamodel.databinding.exceptions.UserCancelledException;
import com.ibm.etools.webtools.pagedataview.PageDataViewRegistryReader;
import com.ibm.etools.webtools.pagedataview.commands.InsertJSPScriptAsChildCommand;
import com.ibm.etools.webtools.pagedataview.commands.InsertNodeAsChildCommand;
import com.ibm.etools.webtools.pagedataview.javabean.ContainedTypePageDataNode;
import com.ibm.etools.webtools.pagedataview.javabean.JavaBeanPageDataNode;
import com.ibm.etools.webtools.pagedataview.jsp.JspPageDataPlugin;
import com.ibm.etools.webtools.pagedataview.jsp.dnd.JSTLCodeGenOperation;
import com.ibm.etools.webtools.pagedataview.jsp.nls.ResourceHandler;
import com.ibm.etools.webtools.pagedataview.ui.dnd.DropActionConfig;
import com.ibm.etools.webtools.pagedataview.ui.dnd.DropHint;
import com.ibm.etools.webtools.pagedataview.ui.dnd.DropTargetConfig;
import com.ibm.etools.webtools.pagedataview.ui.dnd.DropTargetDescription;
import com.ibm.etools.webtools.pagedataview.ui.dnd.IDropActionMediator;
import com.ibm.etools.webtools.pagedataview.ui.dnd.IDropColleague;
import com.ibm.etools.webtools.pagedataview.util.TagUtil;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ranges.Range;

public class JSPDropActionMediator
implements IDropActionMediator {
    public DropTargetConfig getDropTargetConfig(IDropColleague colleague, IPageDataNode[] dropObjects, DropTargetDescription target) {
        Node targetNode = target.getTargetNode();
        Document doc = null;
        doc = targetNode.getNodeType() == 9 ? (Document)targetNode : targetNode.getOwnerDocument();
        if (!(doc instanceof IDOMDocument) || !((IDOMDocument)doc).getModel().getContentTypeIdentifier().equals(ContentTypeIdForJSP.ContentTypeID_JSP)) {
            return null;
        }
        int i = 0;
        while (i < dropObjects.length) {
            String className;
            if (dropObjects[i] instanceof JavaBeanPageDataNode && ((className = ((JavaBeanPageDataNode)dropObjects[i]).getClassName()) == null || className.equals(""))) {
                return new DropTargetConfig(3, null);
            }
            ++i;
        }
        Range range = target.getRange();
        DropTargetConfig bind = new DropTargetConfig(2, new DropTargetObject(range));
        if (this.isInputText(targetNode) || this.isInputPassword(targetNode) || this.isTextArea(targetNode) || this.isLabel(targetNode)) {
            if (dropObjects.length > 1) {
                bind.dropOperation = (short)3;
                return bind;
            }
            return bind;
        }
        if (this.isSelect(targetNode)) {
            return bind;
        }
        EditModelQuery query = EditQueryUtil.getEditQuery((Node)doc);
        if (query.isSolidElement(targetNode)) {
            bind.dropOperation = (short)3;
            return bind;
        }
        return new DropTargetConfig(1, null);
    }

    public DropHint getDropHint(IDropColleague colleague, IPageDataNode[] dropObjects, DropTargetDescription target, short type) {
        DropHint ret = new DropHint(DropHint.DEFAULT_INSERT_IMAGE, DropHint.DEFAULT_TEXT);
        if (type == 2) {
            ret.setImage(DropHint.DEFAULT_BIND_IMAGE);
            String nodeName = colleague.getDropObjectTypeAsString(dropObjects[0]);
            StringBuffer msg = new StringBuffer();
            int i = 0;
            int length = dropObjects.length;
            while (i < length) {
                msg.append(" \"").append(colleague.getDropObjectName(dropObjects[i])).append("\" ");
                ++i;
            }
            String targetName = this.getNodeName(target.getTargetNode());
            ret.setText(NLS.bind((String)ResourceHandler.UI_DropHint_Bnd, (Object[])new String[]{nodeName, msg.toString(), targetName}));
        } else {
            String nodeName = colleague.getDropObjectTypeAsString(dropObjects[0]);
            StringBuffer msg = new StringBuffer();
            int i = 0;
            int length = dropObjects.length;
            while (i < length) {
                msg.append(" \"").append(colleague.getDropObjectName(dropObjects[i])).append("\" ");
                ++i;
            }
            ret.setText(NLS.bind((String)ResourceHandler.UI_DropHint_Ins, (Object[])new String[]{nodeName, msg.toString()}));
        }
        return ret;
    }

    public DropActionConfig getDropActionConfig(IDropColleague colleague, IPageDataNode[] dropObjects, DropTargetDescription target, short type) {
        DropActionConfig ret = new DropActionConfig();
        if (type == 2) {
            Node targetNode = target.getTargetNode();
            if (!this.isSelect(targetNode)) {
                String accessString = colleague.getDropObjectFullName(dropObjects[0], DropActionConfig.TYPE_UNKNOWN);
                if (this.isInputText(targetNode) || this.isInputPassword(targetNode)) {
                    boolean isJSTL = true;
                    isJSTL = accessString.indexOf("(") == -1;
                    if (isJSTL) {
                        ret.addValueEntry("value", "<c:out value='${" + accessString + "}" + "'/>");
                    } else {
                        ret.addValueEntry("value", "<%=" + accessString + "%>");
                    }
                } else if (this.isLabel(targetNode)) {
                    InsertJSPScriptAsChildCommand insertScriptletCmd = new InsertJSPScriptAsChildCommand(accessString, 2);
                    ret.addCustomProperty(DropActionConfig.COMMAND_BEFORE_ACTION, (Object)insertScriptletCmd);
                } else if (this.isTextArea(targetNode)) {
                    InsertJSPScriptAsChildCommand insertScriptletCmd = new InsertJSPScriptAsChildCommand(accessString, 2);
                    ret.addCustomProperty(DropActionConfig.COMMAND_BEFORE_ACTION, (Object)insertScriptletCmd);
                }
            } else {
                NodeList children = targetNode.getChildNodes();
                if (children != null) {
                    target.getRange().setStart(target.getRange().getStartContainer(), children.getLength());
                    target.getRange().setEnd(target.getRange().getStartContainer(), children.getLength());
                }
                CompoundHTMLCommand command = new CompoundHTMLCommand("Insert OPTION");
                int i = 0;
                int length = dropObjects.length;
                while (i < length) {
                    String accessString = colleague.getDropObjectFullName(dropObjects[i], DropActionConfig.TYPE_UNKNOWN);
                    CustomTagFactory factory = new CustomTagFactory("OPTION");
                    factory.pushAttribute("value", "<%=" + accessString + "%>");
                    InsertNodeAsChildCommand insertOptionCmd = new InsertNodeAsChildCommand((NodeFactory)factory);
                    command.append((HTMLCommand)insertOptionCmd);
                    InsertJSPScriptAsChildCommand insertScriptletCmd = new InsertJSPScriptAsChildCommand(accessString, 2);
                    command.append((HTMLCommand)insertScriptletCmd);
                    ++i;
                }
                ret.addCustomProperty(DropActionConfig.COMMAND_BEFORE_ACTION, (Object)command);
            }
            return ret;
        }
        if (type == 1) {
            IPageDataNode commonParent = dropObjects[0];
            if (dropObjects.length > 1) {
                commonParent = CodeGenUtil.findCommonParent((IPageDataNode[])dropObjects);
            }
            String referenceString = this.getBindingAttribute(commonParent).getReferenceString(commonParent);
            ICodeGenModel codeGenModel = null;
            IDOMDocument d = null;
            d = target.getTargetNode().getNodeType() == 9 ? (IDOMDocument)target.getTargetNode() : (IDOMDocument)target.getTargetNode().getOwnerDocument();
            IFile f = this.getFileForPage(d);
            IVirtualComponent component = ComponentUtilities.findComponent((IResource)f);
            try {
                JSP jsp = ModelManager.getModel((IVirtualComponent)component).getJSP(f);
                if (commonParent instanceof ContainedTypePageDataNode) {
                    while (commonParent instanceof ContainedTypePageDataNode && commonParent.getParent() != null && commonParent.getParent() != commonParent.getPageDataModel().getRoot()) {
                        commonParent = commonParent.getParent();
                    }
                    codeGenModel = CodeGenModelFactory.createCodeGenModel((IPageDataNode[])dropObjects, (IPageDataNode)commonParent, (JSP)jsp, (String)PageDataViewRegistryReader.getPageTypeOfMediator((Object)this), (boolean)false);
                } else {
                    codeGenModel = CodeGenModelFactory.createCodeGenModel((IPageDataNode[])dropObjects, null, (JSP)jsp, (String)PageDataViewRegistryReader.getPageTypeOfMediator((Object)this), (boolean)false);
                }
            }
            catch (CoreException coreException) {
                return ret;
            }
            catch (UserCancelledException userCancelledException) {
                return ret;
            }
            catch (WebModelCreationException webModelCreationException) {
                return ret;
            }
            if (referenceString != null && referenceString.indexOf("(") != -1) {
                codeGenModel.addCustomProperty((Object)"isScriptlet", (Object)"true");
            }
            CompoundHTMLCommand cmdList = new CompoundHTMLCommand("Code generation");
            JSTLCodeGenOperation op = new JSTLCodeGenOperation(codeGenModel, cmdList);
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(JspPageDataPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell());
            try {
                dialog.run(false, true, (IRunnableWithProgress)op);
            }
            catch (InvocationTargetException e1) {
                e1.printStackTrace();
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            ret.addCustomProperty(DropActionConfig.COMMAND_BEFORE_ACTION, (Object)cmdList);
        }
        return ret;
    }

    protected IBindingAttribute getBindingAttribute(IPageDataNode pageDataNode) {
        return (IBindingAttribute)pageDataNode.getAdapter(IBindingAttribute.ADAPTER_KEY);
    }

    private boolean isInput(Node target) {
        return target.getNodeName().equalsIgnoreCase("INPUT");
    }

    private boolean isInputText(Node inputTag) {
        if (this.isInput(inputTag)) {
            return this.isInputOfType(inputTag, "text");
        }
        return false;
    }

    private boolean isInputPassword(Node inputTag) {
        if (this.isInput(inputTag)) {
            return this.isInputOfType(inputTag, "password");
        }
        return false;
    }

    private boolean isInputOfType(Node inputTag, String type) {
        Attr attr = TagUtil.getAttribute((Node)inputTag, (String)"type");
        return attr != null && attr.getValue().equalsIgnoreCase(type);
    }

    private boolean isSelect(Node target) {
        return this.isOfType(target, "SELECT");
    }

    private boolean isTextArea(Node target) {
        return this.isOfType(target, "TEXTAREA");
    }

    private boolean isLabel(Node target) {
        return this.isOfType(target, "LABEL");
    }

    private boolean isOfType(Node target, String type) {
        Node check = target;
        while (check != null && check.getNodeType() != 1) {
            check = check.getParentNode();
        }
        return check != null && check.getNodeName().equalsIgnoreCase(type);
    }

    private String getNodeName(Node node) {
        Node check = node;
        while (check.getNodeType() != 1) {
            check = check.getParentNode();
        }
        if (this.isInput(check)) {
            return TagUtil.getAttribute((Node)check, (String)"type").getValue();
        }
        return check.getNodeName();
    }

    private IFile getFileForPage(IDOMDocument doc) {
        if (doc == null) {
            return null;
        }
        String jspFilename = doc.getModel().getBaseLocation();
        if (jspFilename == null) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(jspFilename));
    }
}

