/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.javabean.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.TypeKind;
import org.eclipse.jst.j2ee.internal.webservice.helper.WebServicesManager;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webservice.wsclient.PortComponentRef;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class WebServicesClientUtil {
    public static void buildEndPointInterfaces(IVirtualComponent vc, List<JavaClass> endPointInterfaces) {
        WebApp app = null;
        Collection serviceRefs = null;
        WebArtifactEdit webEdit = null;
        try {
            try {
                webEdit = WebArtifactEdit.getWebArtifactEditForRead((IVirtualComponent)vc);
                if (webEdit != null) {
                    app = webEdit.getWebApp();
                    serviceRefs = WebServicesManager.getInstance().getServiceRefs(app);
                    if (serviceRefs != null) {
                        for (ServiceRef ref : serviceRefs) {
                            EList list2 = ref.getPortComponentRefs();
                            int j = 0;
                            while (list2 != null && j < list2.size()) {
                                JavaClass epInterface;
                                PortComponentRef pcRef = (PortComponentRef)list2.get(j);
                                if (pcRef != null && (epInterface = pcRef.getServiceEndpointInterface()) != null) {
                                    endPointInterfaces.add(epInterface);
                                }
                                ++j;
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (webEdit != null) {
                    webEdit.dispose();
                }
            }
        }
        finally {
            if (webEdit != null) {
                webEdit.dispose();
            }
        }
    }

    public static JavaClass getImplementedEndPointInterface(JavaHelpers beanClass, List endPointInterfaces, IProject project) {
        JavaClass impl = null;
        if (beanClass != null && endPointInterfaces != null && endPointInterfaces.size() > 0) {
            int i = 0;
            while (i < endPointInterfaces.size()) {
                JavaClass intf = (JavaClass)endPointInterfaces.get(i);
                if (intf.isAssignableFrom((EClassifier)beanClass)) {
                    impl = intf;
                    break;
                }
                ++i;
            }
            if (impl == null && beanClass instanceof JavaClass) {
                impl = WebServicesClientUtil.getImplementedEndPointInterface((JavaClass)beanClass, endPointInterfaces);
            }
        }
        return impl;
    }

    private static JavaClass getImplementedEndPointInterface(JavaClass clazz, List endPointInterfaces) {
        JavaClass impl = null;
        TypeKind classKind = clazz.getKind();
        if (TypeKind.CLASS_LITERAL.equals(classKind)) {
            int i = 0;
            while (i < endPointInterfaces.size()) {
                HashSet checkedInterfaces;
                JavaClass interfase = (JavaClass)endPointInterfaces.get(i);
                TypeKind interfaceKind = interfase.getKind();
                if (TypeKind.INTERFACE_LITERAL.equals(interfaceKind) && WebServicesClientUtil.isAssignable(clazz, interfase, checkedInterfaces = new HashSet())) {
                    impl = interfase;
                    break;
                }
                ++i;
            }
        }
        return impl;
    }

    private static boolean isAssignable(JavaClass clazz, JavaClass interfase, Set checkedInterfaces) {
        String interfaceName;
        if (clazz != null && interfase != null && (interfaceName = interfase.getQualifiedName()) != null) {
            return WebServicesClientUtil.hasInterface(interfaceName, clazz, checkedInterfaces) ? true : WebServicesClientUtil.isAssignable(clazz.getSupertype(), interfase, checkedInterfaces);
        }
        return false;
    }

    private static boolean hasInterface(String name, JavaClass javaClass, Set checkedInterfaces) {
        String anInterfaceName;
        JavaClass anInterface;
        EList interfaces = javaClass.getImplementsInterfaces();
        int i = 0;
        while (i < interfaces.size()) {
            anInterface = (JavaClass)interfaces.get(i);
            anInterfaceName = anInterface.getQualifiedName();
            if (name.equals(anInterfaceName)) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < interfaces.size()) {
            anInterface = (JavaClass)interfaces.get(i);
            anInterfaceName = anInterface.getQualifiedName();
            if (!checkedInterfaces.contains(anInterfaceName)) {
                checkedInterfaces.add(anInterfaceName);
                if (WebServicesClientUtil.hasInterface(name, anInterface, checkedInterfaces)) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }
}

