/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.javabean.ui.internal;

import com.ibm.etools.webtools.pagedataview.javabean.IJavaBeanPageDataNode;
import com.ibm.etools.webtools.pagedataview.javabean.JavaBeanPlugin;
import com.ibm.etools.webtools.pagedataview.javabean.nls.ResourceHandler;
import com.ibm.etools.webtools.pagedataview.javabean.ui.internal.JavaBeanMethodSelection;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jem.java.Method;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;

public class SelectMethodDialog
extends Dialog
implements Listener {
    private String dialogTitle = ResourceHandler.UI_Select_Method;
    private String emptyListMessage = ResourceHandler.UI_No_Methods_Avail;
    private Tree propertiesTree;
    private Label errorMessage;
    private String propertyType = null;
    private JavaBeanMethodSelection methodSelection;
    private IJavaBeanPageDataNode bean;
    private Method selectedMethod;
    private boolean showActions = false;

    public SelectMethodDialog(Shell parentShell, IJavaBeanPageDataNode bean) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.bean = bean;
    }

    public SelectMethodDialog(Shell parentShell, IJavaBeanPageDataNode bean, boolean showActions) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.bean = bean;
    }

    protected Composite createBaseComposite(Composite parent, int numColumns, boolean makeColumnsEqualWidth) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = numColumns;
        layout.makeColumnsEqualWidth = makeColumnsEqualWidth;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        if (((ITreeContentProvider)this.methodSelection.getTreeViewer().getContentProvider()).getElements((Object)this.bean).length == 0) {
            this.errorMessage.setText(this.emptyListMessage);
        }
        this.getButton(0).setEnabled(false);
    }

    protected Control createDialogArea(Composite parent) {
        int numBaseCols = 1;
        Composite composite = this.createBaseComposite(parent, numBaseCols, false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.etools.webedit.editor.ins0360");
        ToolBar toolbar = new ToolBar(composite, 256);
        toolbar.setLayoutData((Object)new GridData(4, 1, true, false));
        ToolBarManager manager = new ToolBarManager(toolbar);
        manager.add((IAction)new ToggleInheritenceAction());
        manager.update(true);
        this.methodSelection = this.createMethodSelection(composite, this.bean, this.showActions);
        this.propertiesTree = this.methodSelection.getTree();
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 200;
        gridData.widthHint = 350;
        this.propertiesTree.setLayoutData((Object)gridData);
        this.methodSelection.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SelectMethodDialog.this.treeItemSelected(event);
            }
        });
        this.methodSelection.getTreeViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SelectMethodDialog.this.treeDoubleClicked(event);
            }
        });
        this.errorMessage = new Label(composite, 0);
        GridData data = new GridData(256);
        this.errorMessage.setLayoutData((Object)data);
        this.errorMessage.setForeground(ColorConstants.red);
        this.getShell().setText(this.dialogTitle);
        return composite;
    }

    protected JavaBeanMethodSelection createMethodSelection(Composite composite, IJavaBeanPageDataNode bean2, boolean showActions2) {
        return new JavaBeanMethodSelection(composite, this.bean, this.showActions);
    }

    public String getPropertyType() {
        return this.propertyType;
    }

    void treeItemSelected(SelectionChangedEvent e) {
        IStructuredSelection selection = (IStructuredSelection)e.getSelection();
        if (selection.getFirstElement() instanceof JavaBeanMethodSelection.MethodNode) {
            this.selectedMethod = ((JavaBeanMethodSelection.MethodNode)selection.getFirstElement()).method;
            if (!this.getButton(0).isEnabled()) {
                this.getButton(0).setEnabled(true);
            }
        } else {
            this.getButton(0).setEnabled(false);
        }
    }

    public String getDialogTitle() {
        return this.dialogTitle;
    }

    public void setDialogTitle(String dialogTitle) {
        this.dialogTitle = dialogTitle;
    }

    public String getEmptyListMessage() {
        return this.emptyListMessage;
    }

    public void setEmptyListMessage(String emptyListMessage) {
        this.emptyListMessage = emptyListMessage;
    }

    public Method getSelectedMethod() {
        return this.selectedMethod;
    }

    public void treeDoubleClicked(DoubleClickEvent e) {
    }

    public void handleEvent(Event event) {
    }

    private class ToggleInheritenceAction
    extends Action {
        private boolean toggle;

        public ToggleInheritenceAction() {
            super("", 2);
            this.toggle = false;
            this.setImageDescriptor(JavaBeanPlugin.getDefault().getImageDescriptor("full/obj16/inher_co"));
            this.setToolTipText(ResourceHandler.UI_Show_All_Inherited_Methods);
        }

        public void run() {
            this.toggle = !this.toggle;
            SelectMethodDialog.this.methodSelection.setShowInheritedMethods(this.toggle);
        }
    }
}

