/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.javabean.jbdata;

import com.ibm.etools.webtools.pagedataview.javabean.nls.ResourceHandler;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jst.j2ee.internal.common.operations.JavaModelUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;

public class ObjectTypeQueryDialog
extends Dialog
implements Listener {
    private Label wtTypeLabel;
    private Text wtTypeText;
    private Button wtBrowseButton;
    private JavaClass javaClass;
    private IType wtType;
    private IProject project;
    private ResourceSet resourceset;
    private String nodeId;
    private Label wtErrorMsg;
    private boolean cancelEnabled = true;

    public ObjectTypeQueryDialog(Shell shell, IProject proj, ResourceSet rset, String nodeId) {
        super(shell);
        this.project = proj;
        this.resourceset = rset;
        this.nodeId = nodeId;
    }

    public ObjectTypeQueryDialog(Shell shell, IProject proj, ResourceSet rset) {
        super(shell);
        this.project = proj;
        this.resourceset = rset;
    }

    protected Control createDialogArea(Composite parent) {
        parent.getShell().setText(ResourceHandler.Object_Type);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(768);
        composite.setLayoutData((Object)data);
        Label desc = new Label(composite, 0);
        if (this.nodeId != null) {
            desc.setText(NLS.bind((String)ResourceHandler.Object_Type_Dialog_Desc_With_ID, (Object[])new Object[]{this.nodeId}));
        } else {
            desc.setText(ResourceHandler.Object_Type_Dialog_Desc);
        }
        data = new GridData(768);
        data.horizontalSpan = 3;
        desc.setLayoutData((Object)data);
        this.wtTypeLabel = new Label(composite, 0);
        this.wtTypeLabel.setText(ResourceHandler.Type__2);
        this.wtTypeText = new Text(composite, 2048);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.wtTypeText.setLayoutData((Object)data);
        if (this.javaClass != null) {
            this.wtTypeText.setText(this.javaClass.getQualifiedName());
        } else {
            this.wtTypeText.setText("java.lang.Object");
        }
        this.wtTypeText.addListener(24, (Listener)this);
        this.wtBrowseButton = new Button(composite, 8);
        this.wtBrowseButton.setText(ResourceHandler.Browse_4);
        this.wtBrowseButton.addListener(13, (Listener)this);
        data = new GridData(128);
        this.wtBrowseButton.setLayoutData((Object)data);
        this.wtErrorMsg = new Label(composite, 0);
        data = new GridData(256);
        data.horizontalSpan = 3;
        this.wtErrorMsg.setLayoutData((Object)data);
        this.wtErrorMsg.setForeground(Display.getCurrent().getSystemColor(3));
        new Label(composite, 0);
        new Label(composite, 0);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        if (!this.cancelEnabled) {
            this.getButton(1).setEnabled(false);
        }
    }

    public void handleEvent(Event ev) {
        block13: {
            if (ev.widget == this.wtBrowseButton) {
                try {
                    SelectionDialog dialog = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)new ProgressMonitorDialog(this.getShell()), (IProject)this.project, (int)256, (boolean)false);
                    dialog.setTitle(ResourceHandler.Choose_Java_bean_5);
                    dialog.setMessage(ResourceHandler.Choose_Java_bean_5);
                    if (dialog.open() != 0) break block13;
                    Object[] selection = dialog.getResult();
                    if (selection != null && selection.length > 0) {
                        this.wtType = (IType)selection[0];
                    }
                    if (this.wtType != null) {
                        URI uri = URI.createURI((String)("java:/" + this.wtType.getPackageFragment().getElementName() + "#" + this.wtType.getElementName()));
                        this.javaClass = (JavaClass)this.resourceset.getEObject(uri, true);
                        this.wtTypeText.setText(this.wtType.getFullyQualifiedName());
                    }
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            } else if (ev.widget == this.wtTypeText) {
                String typeString = this.wtTypeText.getText();
                if ((typeString = typeString.trim()).length() > 2 && typeString.endsWith("[]")) {
                    typeString = typeString.substring(0, typeString.length() - 2);
                }
                if (typeString == null || typeString.equals("")) {
                    this.getButton(0).setEnabled(false);
                    this.wtErrorMsg.setText(NLS.bind((String)ResourceHandler.UI_CNT_B_NULL, (Object[])new String[]{this.wtTypeLabel.getText()}));
                    return;
                }
                try {
                    IType type = JavaModelUtil.findType((IJavaProject)JavaCore.create((IProject)this.project), (String)typeString);
                    if (type == null) {
                        this.wtErrorMsg.setText(NLS.bind((String)ResourceHandler.UI_TYPE_NOT_FOUND, (Object[])new String[]{typeString}));
                        this.getButton(0).setEnabled(false);
                    } else {
                        this.wtErrorMsg.setText("");
                        this.getButton(0).setEnabled(true);
                    }
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public JavaClass getResult() {
        return this.javaClass;
    }

    public void setInitialValue(JavaClass value) {
        if (this.javaClass == null) {
            this.javaClass = value;
        }
    }

    protected void okPressed() {
        if (this.wtType == null || !this.wtType.getFullyQualifiedName().equals(this.wtTypeText.getText())) {
            String typeString = this.wtTypeText.getText();
            int index = typeString.lastIndexOf(".");
            String packagename = "";
            String classname = "";
            if (index < 0) {
                classname = typeString;
            } else {
                packagename = typeString.substring(0, index);
                classname = typeString.substring(index + 1);
            }
            URI uri = URI.createURI((String)("java:/" + packagename + "#" + classname));
            this.javaClass = (JavaClass)this.resourceset.getEObject(uri, true);
        }
        super.okPressed();
    }

    public void setCancelEnabled(boolean cancelEnabled) {
        this.cancelEnabled = cancelEnabled;
    }

    public IProject getProject() {
        return this.project;
    }
}

