/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.javabean.jbdata;

import com.ibm.etools.webtools.pagedataview.javabean.jbdata.IWTJBFormFieldData;
import com.ibm.etools.webtools.pagedataview.javabean.jbdata.IWTJBMethod;
import com.ibm.etools.webtools.pagedataview.javabean.jbdata.IWTJBProperty;
import com.ibm.etools.webtools.pagedataview.javabean.jbdata.WTJBFormFieldData;
import com.ibm.etools.webtools.pagedataview.javabean.jbdata.WTJBMethod;
import com.ibm.etools.webtools.pagedataview.javabean.jbdata.WTJBMethodParameter;
import com.ibm.etools.webtools.pagedataview.javabean.jbdata.WTJBMethodResult;
import com.ibm.etools.webtools.pagedataview.javabean.jbdata.WTJBProperty;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.internal.beaninfo.PropertyDecorator;
import org.eclipse.jem.internal.beaninfo.core.Utilities;
import org.eclipse.jem.java.ArrayType;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.Method;

public class NodeTypeFactory {
    private static URI LIST_URI = URI.createURI((String)"java:/java.util#List");
    private static URI SET_URI = URI.createURI((String)"java:/java.util#Set");
    private static URI MAP_URI = URI.createURI((String)"java:/java.util#Map");
    private static URI ITERATOR_URI = URI.createURI((String)"java:/java.util#Iterator");
    private static URI ENUMERATION_URI = URI.createURI((String)"java:/java.util#Enumeration");
    private static URI RESULT_SET_URI = URI.createURI((String)"java:/java.sql#ResultSet");
    private static URI COLLECTION_URI = URI.createURI((String)"Java:/java.util#Collection");

    public static IWTJBFormFieldData[] getChildren(IWTJBFormFieldData node) {
        Vector children = new Vector();
        if (node instanceof IWTJBMethod) {
            children = NodeTypeFactory.getChildrenFromMethodNode(node);
        } else {
            Vector childrenMethods;
            children = NodeTypeFactory.getPropertiesFromNode(node);
            if (node.isRoot() && children != null && (childrenMethods = NodeTypeFactory.getMethodsFromNode(node)) != null) {
                children.addAll(childrenMethods);
            }
        }
        if (children != null && children.size() > 0) {
            IWTJBFormFieldData[] rt = new WTJBFormFieldData[children.size()];
            int i = 0;
            while (i < children.size()) {
                rt[i] = (WTJBFormFieldData)children.get(i);
                ++i;
            }
            return rt;
        }
        return new IWTJBFormFieldData[0];
    }

    public static Vector getPropertiesFromNode(IWTJBFormFieldData node) {
        Object mofNode = node.getMofNode();
        if (!(mofNode instanceof JavaClass)) {
            return null;
        }
        JavaClass javaClass = (JavaClass)mofNode;
        if (javaClass.isArray()) {
            javaClass = ((ArrayType)javaClass).getFinalComponentType().getWrapper();
        }
        Vector<IWTJBFormFieldData> valid_fields = new Vector<IWTJBFormFieldData>();
        Iterator itr = Utilities.getPropertiesIterator((EList)javaClass.getAllProperties());
        while (itr.hasNext()) {
            Method writeMethod;
            PropertyDecorator pd = (PropertyDecorator)itr.next();
            IWTJBFormFieldData property = null;
            EClassifier type = pd.getPropertyType();
            if (type instanceof JavaHelpers) {
                if (type instanceof JavaClass) {
                    JavaClass jClass = (JavaClass)type;
                    property = new WTJBProperty(pd.getName(), jClass);
                    property.setTypeSignature(jClass.getQualifiedName());
                } else if (((JavaHelpers)type).isPrimitive()) {
                    JavaHelpers jType = (JavaHelpers)type;
                    property = new WTJBProperty(pd.getDisplayName(), jType);
                    property.setTypeSignature(jType.getQualifiedName());
                }
            }
            if (property == null) continue;
            property.setSelected(false);
            property.setParent(node);
            property.setInputType(node.getInputType());
            property.setGroupingType(NodeTypeFactory.getNodeGroupingType(property));
            NodeTypeFactory.setupNodeLayoutStyle(property);
            valid_fields.add(property);
            Method readMethod = pd.getReadMethod();
            if (readMethod != null) {
                WTJBMethod method = new WTJBMethod(readMethod.getName(), readMethod);
                method.setSelected(false);
                method.setDisplayId(readMethod.getMethodElementSignature());
                method.setMethodName(readMethod.getName());
                method.setLabel(method.getDisplayId());
                method.setParent(property);
                method.setInputType(property.getInputType());
                NodeTypeFactory.setupNodeLayoutStyle(method);
                NodeTypeFactory.setupMethodExceptions(readMethod, method);
                NodeTypeFactory.setupMethodParameters(readMethod, method);
                property.setGetterMethod(method);
            }
            if ((writeMethod = pd.getWriteMethod()) == null) continue;
            WTJBMethod method = new WTJBMethod(writeMethod.getName(), writeMethod);
            method.setSelected(false);
            method.setDisplayId(writeMethod.getMethodElementSignature());
            method.setMethodName(writeMethod.getName());
            method.setLabel(method.getDisplayId());
            method.setParent(property);
            method.setInputType(property.getInputType());
            NodeTypeFactory.setupNodeLayoutStyle(method);
            NodeTypeFactory.setupMethodExceptions(writeMethod, method);
            NodeTypeFactory.setupMethodParameters(writeMethod, method);
            property.setSetterMethod(method);
        }
        Vector<IWTJBProperty> properties = new Vector<IWTJBProperty>();
        if (valid_fields.size() > 0) {
            properties = new Vector(valid_fields.size());
            int cnt = valid_fields.size() - 1;
            while (cnt >= 0) {
                properties.add((IWTJBProperty)valid_fields.get(cnt));
                --cnt;
            }
        }
        return properties;
    }

    public static Vector getMethodsFromNode(IWTJBFormFieldData node) {
        Object mofNode = node.getMofNode();
        if (!(mofNode instanceof JavaClass)) {
            return null;
        }
        JavaClass javaClass = (JavaClass)mofNode;
        if (javaClass.isArray()) {
            javaClass = ((ArrayType)javaClass).getFinalComponentType().getWrapper();
        }
        List publicExtendedMethods = javaClass.getPublicMethodsExtended();
        Vector<WTJBMethod> method_vector = new Vector<WTJBMethod>();
        for (Method method : publicExtendedMethods) {
            if (method.isConstructor()) continue;
            WTJBMethod jbMethod = new WTJBMethod(method.getMethodElementSignature(), method);
            jbMethod.setSelected(false);
            jbMethod.setDisplayId(method.getMethodElementSignature());
            jbMethod.setMethodName(method.getName());
            jbMethod.setLabel(jbMethod.getDisplayId());
            jbMethod.setParent(node);
            jbMethod.setInputType(node.getInputType());
            NodeTypeFactory.setupNodeLayoutStyle(jbMethod);
            NodeTypeFactory.setupMethodExceptions(method, jbMethod);
            NodeTypeFactory.setupMethodParameters(method, jbMethod);
            method_vector.add(jbMethod);
        }
        return method_vector;
    }

    public static Vector getChildrenFromMethodNode(IWTJBFormFieldData node) {
        if (!(node.getMofNode() instanceof Method)) {
            return null;
        }
        Method method = (Method)node.getMofNode();
        EList parms = method.getParameters();
        Vector<WTJBFormFieldData> children = new Vector<WTJBFormFieldData>();
        JavaHelpers return_type = method.getReturnType();
        IWTJBMethod jbMethod = (IWTJBMethod)node;
        if (return_type != null) {
            WTJBMethodResult result = new WTJBMethodResult("result", return_type);
            result.setParent(node);
            result.setSelected(false);
            result.setTypeSignature(return_type.getQualifiedName());
            result.setInputType(jbMethod.getInputType());
            result.setGroupingType(NodeTypeFactory.getNodeGroupingType(result));
            NodeTypeFactory.setupNodeLayoutStyle(result);
            children.add(result);
        }
        int i = 0;
        while (i < parms.size()) {
            JavaParameter parm = (JavaParameter)parms.get(i);
            JavaHelpers _mofNode = parm.getJavaType();
            WTJBMethodParameter child = new WTJBMethodParameter(parm.getQualifiedName(), _mofNode);
            child.setParent(node);
            child.setSelected(false);
            child.setTypeSignature(parm.getJavaType().getQualifiedName());
            child.setGroupingType(NodeTypeFactory.getNodeGroupingType(child));
            NodeTypeFactory.setupNodeLayoutStyle(child);
            children.add(child);
            ++i;
        }
        return children;
    }

    protected static void setupMethodParameters(Method method, IWTJBMethod jbMethod) {
        JavaHelpers return_type;
        EList parms = method.getParameters();
        if (parms != null) {
            int j = 0;
            while (j < parms.size()) {
                JavaParameter param = (JavaParameter)parms.get(j);
                String param_name = param.getName();
                WTJBMethodParameter pd = new WTJBMethodParameter(param_name, param.getJavaType());
                pd.setDisplayId(String.valueOf(param.getJavaType().getJavaName()) + " " + param_name);
                pd.setTypeSignature(param.getJavaType().getQualifiedName());
                pd.setParent(jbMethod);
                pd.setInputType(jbMethod.getInputType());
                pd.setGroupingType(NodeTypeFactory.getNodeGroupingType(pd));
                jbMethod.addMethodParameter(pd);
                ++j;
            }
        }
        if ((return_type = method.getReturnType()) != null) {
            WTJBMethodResult result = new WTJBMethodResult(jbMethod.getMethodName(), return_type);
            result.setParent(jbMethod);
            result.setInputType(jbMethod.getInputType());
            result.setGroupingType(NodeTypeFactory.getNodeGroupingType(result));
            jbMethod.setReturnResult(result);
            jbMethod.getReturnResult().setDisplayId(String.valueOf(return_type.getQualifiedName()) + " " + jbMethod.getDisplayId());
            jbMethod.getReturnResult().setTypeSignature(return_type.getQualifiedName());
            jbMethod.setTypeSignature(return_type.getQualifiedName());
        }
    }

    protected static void setupMethodExceptions(Method method, IWTJBMethod jbMethod) {
        EList exceptions = method.getJavaExceptions();
        int j = 0;
        while (j < exceptions.size()) {
            JavaClass jci = (JavaClass)exceptions.get(j);
            jbMethod.addException(jci.getJavaName());
            ++j;
        }
    }

    public static int getNodeGroupingType(IWTJBFormFieldData node) {
        int type = -1;
        Object mofNode = node.getMofNode();
        if (!node.isPrimitive() && mofNode instanceof JavaClass) {
            JavaClass javaClass = (JavaClass)mofNode;
            if (javaClass.eResource() == null) {
                return -1;
            }
            ResourceSet rset = javaClass.eResource().getResourceSet();
            JavaClass list = (JavaClass)rset.getEObject(LIST_URI, true);
            JavaClass set = (JavaClass)rset.getEObject(SET_URI, true);
            JavaClass map = (JavaClass)rset.getEObject(MAP_URI, true);
            JavaClass iterator = (JavaClass)rset.getEObject(ITERATOR_URI, true);
            JavaClass enumeration = (JavaClass)rset.getEObject(ENUMERATION_URI, true);
            JavaClass resultset = (JavaClass)rset.getEObject(RESULT_SET_URI, true);
            JavaClass collection = (JavaClass)rset.getEObject(COLLECTION_URI, true);
            if (javaClass.implementsInterface(list)) {
                type = 6;
            } else if (javaClass.implementsInterface(set)) {
                type = 7;
            } else if (javaClass.implementsInterface(collection)) {
                type = 8;
            } else if (javaClass.implementsInterface(map)) {
                type = 1;
            } else if (javaClass.implementsInterface(iterator)) {
                type = 2;
            } else if (javaClass.implementsInterface(enumeration)) {
                type = 3;
            } else if (javaClass.implementsInterface(resultset)) {
                type = 4;
            } else if (javaClass.getJavaPackage() != null && javaClass.getJavaPackage().getPackageName().equals("com.ibm.db.beans")) {
                if (javaClass.getQualifiedName().equals("com.ibm.db.beans.DBSelect")) {
                    type = 5;
                } else {
                    JavaClass superclass = javaClass.getSupertype();
                    while (superclass != null) {
                        if (superclass.getQualifiedName().equals("com.ibm.db.beans.DBSelect")) {
                            type = 5;
                            superclass = null;
                            continue;
                        }
                        superclass = superclass.getSupertype();
                    }
                }
            }
        }
        return type;
    }

    protected static void setupNodeLayoutStyle(IWTJBFormFieldData node) {
        if (node.isArrayType() || node.getGroupingType() != -1) {
            node.setLayoutStyle(1);
        } else {
            IWTJBFormFieldData parent = node.getParent();
            int style = 0;
            while (parent != null) {
                if (parent.getLayoutStyle() == 1) {
                    style = 1;
                    parent = null;
                    continue;
                }
                parent = parent.getParent();
            }
            node.setLayoutStyle(style);
        }
    }
}

