/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.javabean.internal.introspection;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public class IntrospectionHelper {
    public static final boolean isPrimitive(String typeName) {
        if (typeName == null || typeName.length() == 0) {
            return false;
        }
        boolean isPrimitive = false;
        if (typeName.equals("float")) {
            isPrimitive = true;
        } else if (typeName.equals("double")) {
            isPrimitive = true;
        } else if (typeName.equals("long")) {
            isPrimitive = true;
        } else if (typeName.equals("int")) {
            isPrimitive = true;
        } else if (typeName.equals("boolean")) {
            isPrimitive = true;
        } else if (typeName.equals("short")) {
            isPrimitive = true;
        } else if (typeName.equals("byte")) {
            isPrimitive = true;
        } else if (typeName.equals("char")) {
            isPrimitive = true;
        }
        return isPrimitive;
    }

    public static final boolean isCollectionType(IType type) {
        boolean isCollection = false;
        try {
            IType[] interfaces;
            ITypeHierarchy typeHierarchy = type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
            IType[] iTypeArray = interfaces = typeHierarchy.getAllInterfaces();
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                IType element = iTypeArray[n2];
                String interfaceName = element.getFullyQualifiedName();
                if (interfaceName != null && interfaceName.startsWith("java.util.Collection")) {
                    isCollection = true;
                    break;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return isCollection;
    }

    public static final int getGroupingType(IType type) {
        int groupingType = 0;
        try {
            if (type != null) {
                ITypeHierarchy typeHierarchy = type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                IType[] interfaces = typeHierarchy.getAllInterfaces();
                if (IntrospectionHelper.implementsInterface(interfaces, "java.util.List")) {
                    groupingType = 1;
                } else if (IntrospectionHelper.implementsInterface(interfaces, "java.util.Set")) {
                    groupingType = 2;
                } else if (IntrospectionHelper.implementsInterface(interfaces, "java.util.Collection")) {
                    groupingType = 8;
                } else if (IntrospectionHelper.implementsInterface(interfaces, "java.util.Map")) {
                    groupingType = 3;
                } else if (IntrospectionHelper.implementsInterface(interfaces, "java.util.Iterator")) {
                    groupingType = 4;
                } else if (IntrospectionHelper.implementsInterface(interfaces, "java.util.Enumeration")) {
                    groupingType = 5;
                } else if (IntrospectionHelper.implementsInterface(interfaces, "java.sql.ResultSet")) {
                    groupingType = 6;
                }
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return groupingType;
    }

    private static boolean implementsInterface(IType[] interfaces, String fullyQualifiedInterfaceName) {
        IType[] iTypeArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            IType element = iTypeArray[n2];
            String interfaceName = element.getFullyQualifiedName();
            if (interfaceName != null && interfaceName.startsWith(fullyQualifiedInterfaceName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static final String getContainedType(String fullyQualifiedCollectionType) {
        String containedType = null;
        int startIndex = fullyQualifiedCollectionType.indexOf(60);
        int endIndex = fullyQualifiedCollectionType.lastIndexOf(62);
        if (startIndex != -1 && endIndex != -1) {
            containedType = fullyQualifiedCollectionType.substring(startIndex + 1, endIndex);
        }
        return containedType;
    }

    public static final String getFullyQualifiedType(IMethod method) {
        String typeSignature;
        String signatureAsString;
        String fullyQualifiedType;
        block15: {
            fullyQualifiedType = null;
            signatureAsString = null;
            typeSignature = null;
            if (IntrospectionHelper.isPropertyGetter(method)) {
                typeSignature = method.getReturnType();
                break block15;
            }
            if (IntrospectionHelper.isPropertySetter(method)) {
                typeSignature = method.getParameterTypes()[0];
                break block15;
            }
            return null;
        }
        try {
            int arrayCount = Signature.getArrayCount((String)typeSignature);
            signatureAsString = arrayCount > 0 ? Signature.toString((String)Signature.getElementType((String)typeSignature)) : Signature.toString((String)typeSignature);
            if (IntrospectionHelper.isPrimitive(signatureAsString)) {
                fullyQualifiedType = signatureAsString;
            } else {
                boolean isSource;
                boolean bl = isSource = !((IType)method.getParent()).isBinary();
                if (isSource) {
                    List<String> generics;
                    fullyQualifiedType = IntrospectionHelper.constructFullyQualifiedType(method, signatureAsString);
                    String[] genericTypes = Signature.getTypeArguments((String)typeSignature);
                    if (genericTypes.length > 0 && (generics = IntrospectionHelper.constructGenericString(genericTypes, method)).size() > 0) {
                        StringBuilder sb = new StringBuilder();
                        for (String gen : generics) {
                            sb.append("<");
                            sb.append(gen);
                        }
                        int i = 0;
                        while (i < generics.size()) {
                            sb.append(">");
                            ++i;
                        }
                        fullyQualifiedType = String.valueOf(fullyQualifiedType) + sb.toString();
                    }
                } else {
                    fullyQualifiedType = signatureAsString;
                }
            }
            if (arrayCount > 0) {
                int i = 0;
                while (i < arrayCount) {
                    fullyQualifiedType = String.valueOf(fullyQualifiedType) + "[]";
                    ++i;
                }
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return fullyQualifiedType;
    }

    private static List<String> constructGenericString(String[] genericTypes, IMethod method) {
        ArrayList<String> genericStrings = new ArrayList<String>();
        int i = 0;
        while (i < genericTypes.length) {
            String genericType;
            int genericArrayCount;
            String simpleGenericType;
            String fullyQualifiedGenericType;
            String[] nestedTypes = Signature.getTypeArguments((String)genericTypes[i]);
            if (nestedTypes.length > 0) {
                genericStrings.addAll(IntrospectionHelper.constructGenericString(nestedTypes, method));
            }
            if ((fullyQualifiedGenericType = IntrospectionHelper.constructFullyQualifiedType(method, simpleGenericType = (genericArrayCount = Signature.getArrayCount((String)(genericType = genericTypes[i]))) > 0 ? Signature.toString((String)Signature.getElementType((String)genericType)) : Signature.toString((String)genericType))) == null) break;
            if (genericArrayCount > 0) {
                int j = 0;
                while (j < genericArrayCount) {
                    fullyQualifiedGenericType = String.valueOf(fullyQualifiedGenericType) + "[]";
                    ++j;
                }
            }
            StringBuffer genericBuffer = new StringBuffer();
            genericBuffer.append(fullyQualifiedGenericType);
            if (i < genericTypes.length - 1) {
                genericBuffer.append(',');
            }
            genericStrings.add(0, genericBuffer.toString());
            ++i;
        }
        return genericStrings;
    }

    private static String constructFullyQualifiedType(IMethod method, String simpleType) {
        String[][] fullyQualifiedType = null;
        try {
            fullyQualifiedType = method.getDeclaringType().resolveType(simpleType);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        if (fullyQualifiedType != null) {
            String p = fullyQualifiedType[0][0];
            String pkgName = p.equals("") ? "" : String.valueOf(p) + '.';
            return String.valueOf(pkgName) + fullyQualifiedType[0][1];
        }
        return null;
    }

    public static final boolean isPropertyGetter(IMethod method) {
        try {
            boolean isInterfaceMethod = method.getDeclaringType().isInterface();
            int flags = method.getFlags();
            if (Flags.isPublic((int)flags) && !Flags.isStatic((int)flags) || isInterfaceMethod) {
                String methodName = method.getElementName();
                String returnType = Signature.toString((String)Signature.getReturnType((String)method.getSignature()));
                if (!Signature.toString((String)method.getReturnType()).equals("void") && Signature.getParameterCount((String)method.getSignature()) == 0 && (methodName.startsWith("get") || methodName.startsWith("is") && returnType.equals("boolean"))) {
                    return true;
                }
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static final boolean isPropertySetter(IMethod method) {
        try {
            String methodName = method.getElementName();
            boolean isInterfaceMethod = method.getDeclaringType().isInterface();
            int flags = method.getFlags();
            if ((Flags.isPublic((int)flags) && !Flags.isStatic((int)flags) || isInterfaceMethod) && methodName.startsWith("set") && Signature.toString((String)method.getReturnType()).equals("void") && Signature.getParameterCount((String)method.getSignature()) == 1 && !methodName.equals("set")) {
                return true;
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static final String decapitalizePropertyMethod(String methodName) {
        if (methodName.startsWith("get") || methodName.startsWith("set")) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        if (methodName.startsWith("is")) {
            return Introspector.decapitalize(methodName.substring(2));
        }
        return null;
    }
}

