/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedatamodel.wizards.internal;

import com.ibm.etools.webtools.pagedatamodel.databinding.CodeGenModelFactory;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenModel;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.exceptions.UserCancelledException;
import com.ibm.etools.webtools.pagedatamodel.nls.ResourceHandler;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class SnappyCombo
extends Composite {
    protected boolean fCanHaveEmbeddedForm = false;
    static final int ITEMS_SHOWING = 5;
    static final boolean IS_GTK = SWT.getPlatform().equalsIgnoreCase("gtk");
    Text fText;
    List fList;
    Shell fPopup;
    Button fArrow;
    Button fButton;
    boolean fHasFocus;

    public SnappyCombo(Composite parent, int style) {
        super(parent, SnappyCombo.validateStyle(style));
        style = this.getStyle();
        int textStyle = 4;
        if ((style & 8) != 0) {
            textStyle |= 8;
        }
        if ((style & 0x800000) != 0) {
            textStyle |= 0x800000;
        }
        this.fText = new Text((Composite)this, textStyle);
        this.fPopup = new Shell(this.getShell(), 8);
        this.fList = new List((Composite)this.fPopup, 8389124);
        int arrowStyle = 1028;
        if ((style & 0x800000) != 0) {
            arrowStyle |= 0x800000;
        }
        this.fArrow = new Button((Composite)this, arrowStyle);
        int buttonStyle = 8;
        if ((style & 0x800000) != 0) {
            buttonStyle |= 0x800000;
        }
        this.fButton = new Button((Composite)this, buttonStyle);
        this.fButton.setText("...");
        this.fButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.result = ResourceHandler.configure;
                }
            }
        });
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (SnappyCombo.this.fPopup == event.widget) {
                    SnappyCombo.this.popupEvent(event);
                    return;
                }
                if (SnappyCombo.this.fText == event.widget) {
                    SnappyCombo.this.textEvent(event);
                    return;
                }
                if (SnappyCombo.this.fList == event.widget) {
                    SnappyCombo.this.listEvent(event);
                    return;
                }
                if (SnappyCombo.this.fArrow == event.widget) {
                    SnappyCombo.this.arrowEvent(event);
                    return;
                }
                if (SnappyCombo.this.fButton == event.widget) {
                    SnappyCombo.this.buttonEvent(event);
                    return;
                }
                if (SnappyCombo.this == event.widget) {
                    SnappyCombo.this.comboEvent(event);
                    return;
                }
            }
        };
        int[] comboEvents = new int[]{12, 10, 11};
        int i = 0;
        while (i < comboEvents.length) {
            this.addListener(comboEvents[i], listener);
            ++i;
        }
        int[] popupEvents = new int[]{21, 9, 27};
        int i2 = 0;
        while (i2 < popupEvents.length) {
            this.fPopup.addListener(popupEvents[i2], listener);
            ++i2;
        }
        int[] textEvents = new int[]{1, 2, 24, 3, 4, 31, 15, 16};
        int i3 = 0;
        while (i3 < textEvents.length) {
            this.fText.addListener(textEvents[i3], listener);
            ++i3;
        }
        int[] listEvents = new int[]{4, 13, 31, 1, 2, 15, 16};
        int i4 = 0;
        while (i4 < listEvents.length) {
            this.fList.addListener(listEvents[i4], listener);
            ++i4;
        }
        int[] arrowEvents = new int[]{3, 15, 16};
        int i5 = 0;
        while (i5 < arrowEvents.length) {
            this.fArrow.addListener(arrowEvents[i5], listener);
            ++i5;
        }
        int[] buttonEvents = new int[]{13};
        int i6 = 0;
        while (i6 < buttonEvents.length) {
            this.fButton.addListener(buttonEvents[i6], listener);
            ++i6;
        }
        this.initAccessible();
    }

    private static int validateStyle(int style) {
        int mask = 0x6800808;
        return style & mask;
    }

    public void updateButtonState() {
        if (this.fButton != null && !this.fButton.isDisposed() && this.fCanHaveEmbeddedForm) {
            this.fButton.setEnabled("".equals(this.getText()));
        }
    }

    public void add(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        this.fList.add(string);
    }

    public void add(String string, int index) {
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        this.fList.add(string, index);
        this.fArrow.setVisible(index > 0);
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        ModifyTypedListener typedListener = new ModifyTypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        SelectionTypedListener typedListener = new SelectionTypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void arrowEvent(Event event) {
        switch (event.type) {
            case 15: {
                if (this.fHasFocus) {
                    return;
                }
                this.fHasFocus = true;
                if (this.getEditable()) {
                    this.fText.selectAll();
                }
                Event e = new Event();
                e.time = event.time;
                this.notifyListeners(15, e);
                break;
            }
            case 16: {
                event.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (SnappyCombo.this.isDisposed()) {
                            return;
                        }
                        Control focusControl = SnappyCombo.this.getDisplay().getFocusControl();
                        if (SnappyCombo.this.fList != null && focusControl == SnappyCombo.this.fList || focusControl == SnappyCombo.this.fText) {
                            return;
                        }
                        SnappyCombo.this.fHasFocus = false;
                        Event e = new Event();
                        SnappyCombo.this.notifyListeners(16, e);
                    }
                });
                break;
            }
            case 3: {
                if (event.button != 1 || this.fText.getEditable()) {
                    return;
                }
                boolean dropped = this.isDropped();
                this.fText.setSelection(0, 0);
                if (!dropped) {
                    this.setFocus();
                }
                if (this.fArrow == null || !this.fArrow.isVisible()) break;
                this.dropDown(!dropped);
            }
        }
    }

    void buttonEvent(Event event) {
        switch (event.type) {
            case 13: {
                ICodeGenNode cgNode = IS_GTK ? (ICodeGenNode)this.getData("node") : (ICodeGenNode)((TableEditor)this.getData()).getItem().getData();
                ICodeGenModel cgModel = cgNode.getChildCodeGenModel();
                if (cgModel != null) {
                    try {
                        CodeGenModelFactory.configureInWizard(cgModel, this.getShell().getLocation().x + 40);
                    }
                    catch (UserCancelledException userCancelledException) {}
                }
                Event e = new Event();
                e.time = event.time;
                this.notifyListeners(15, e);
            }
        }
    }

    public void clearSelection() {
        this.checkWidget();
        this.fText.clearSelection();
        if (this.fList != null) {
            this.fList.deselectAll();
        }
    }

    void comboEvent(Event event) {
        switch (event.type) {
            case 12: {
                if (this.fPopup != null && !this.fPopup.isDisposed()) {
                    this.fPopup.dispose();
                }
                this.fPopup = null;
                this.fText = null;
                this.fList = null;
                this.fArrow = null;
                this.fButton = null;
                break;
            }
            case 10: {
                this.dropDown(false);
                break;
            }
            case 11: {
                this.internalLayout();
            }
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        Point textSize = this.fText.computeSize(wHint, -1, changed);
        Point arrowSize = this.fArrow != null ? this.fArrow.computeSize(-1, -1, changed) : new Point(0, 0);
        Point buttonSize = this.fButton != null ? this.fButton.computeSize(-1, -1, changed) : new Point(0, 0);
        Point listSize = this.fList != null ? this.fList.computeSize(wHint, -1, changed) : new Point(0, 0);
        int borderWidth = this.getBorderWidth();
        height = Math.max(hHint, Math.max(buttonSize.y, Math.max(textSize.y, arrowSize.y)) + 2 * borderWidth);
        width = Math.max(wHint, Math.max(buttonSize.x + textSize.x + arrowSize.x + 2 * borderWidth, listSize.x + 2));
        return new Point(width, height);
    }

    public void deselect(int index) {
        this.checkWidget();
        if (this.fList != null) {
            this.fList.deselect(index);
        }
    }

    public void deselectAll() {
        this.checkWidget();
        if (this.fList != null) {
            this.fList.deselectAll();
        }
    }

    void dropDown(boolean drop) {
        if (drop == this.isDropped()) {
            return;
        }
        if (!drop) {
            if (this.fPopup != null) {
                this.fPopup.setVisible(false);
            }
            this.fText.setFocus();
            return;
        }
        if (this.fList != null) {
            int index = this.fList.getSelectionIndex();
            if (index != -1) {
                this.fList.setTopIndex(index);
            }
            Rectangle listRect = this.fList.getBounds();
            Display display = this.getDisplay();
            Rectangle rect = display.map((Control)this.getParent(), null, this.getBounds());
            Point comboSize = this.getSize();
            int width = Math.max(comboSize.x, listRect.width + 2);
            this.fPopup.setBounds(rect.x, rect.y + comboSize.y, width, listRect.height + 2);
            this.fPopup.setVisible(true);
            this.fList.setFocus();
        }
    }

    public Control[] getChildren() {
        this.checkWidget();
        return new Control[0];
    }

    boolean getEditable() {
        return this.fText.getEditable();
    }

    public String getItem(int index) {
        this.checkWidget();
        return this.fList != null ? this.fList.getItem(index) : null;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.fList != null ? this.fList.getItemCount() : 0;
    }

    public int getItemHeight() {
        this.checkWidget();
        return this.fList != null ? this.fList.getItemHeight() : 0;
    }

    public String[] getItems() {
        this.checkWidget();
        return this.fList != null ? this.fList.getItems() : null;
    }

    public Point getSelection() {
        this.checkWidget();
        return this.fText.getSelection();
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return this.fList != null ? this.fList.getSelectionIndex() : -1;
    }

    public String getText() {
        this.checkWidget();
        return this.fText.getText();
    }

    public int getTextHeight() {
        this.checkWidget();
        return this.fText.getLineHeight();
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.fText.getTextLimit();
    }

    public int indexOf(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        return this.fList != null ? this.fList.indexOf(string) : -1;
    }

    public int indexOf(String string, int start) {
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        return this.fList != null ? this.fList.indexOf(string, start) : -1;
    }

    void initAccessible() {
        this.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getHelp(AccessibleEvent e) {
                e.result = SnappyCombo.this.getToolTipText();
            }
        });
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point testPoint = SnappyCombo.this.toControl(new Point(e.x, e.y));
                if (SnappyCombo.this.getBounds().contains(testPoint)) {
                    e.childID = -1;
                }
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = SnappyCombo.this.getBounds();
                Point pt = SnappyCombo.this.toDisplay(new Point(location.x, location.y));
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 46;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getValue(AccessibleControlEvent e) {
                e.result = SnappyCombo.this.getText();
            }
        });
    }

    boolean isDropped() {
        return this.fPopup != null && this.fPopup.getVisible() && this.fArrow != null && this.fArrow.isVisible();
    }

    public boolean isFocusControl() {
        this.checkWidget();
        if (this.fText.isFocusControl() || this.fArrow != null && this.fArrow.isFocusControl() || this.fButton != null && this.fButton.isFocusControl() || this.fList != null && this.fList.isFocusControl() || this.fPopup != null && this.fPopup.isFocusControl()) {
            return true;
        }
        return super.isFocusControl();
    }

    void internalLayout() {
        if (this.isDropped()) {
            this.dropDown(false);
        }
        Rectangle rect = this.getClientArea();
        int width = rect.width;
        int height = rect.height;
        Point arrowSize = this.fArrow != null ? this.fArrow.computeSize(-1, height) : new Point(0, 0);
        arrowSize.x = arrowSize.y = arrowSize.y != 0 ? arrowSize.y - 1 : 0;
        Point buttonSize = null;
        if (IS_GTK) {
            buttonSize = this.fButton != null && this.fCanHaveEmbeddedForm ? this.fButton.computeSize(-1, height) : new Point(0, 0);
        } else {
            Point point = this.fButton != null && this.fButton.isVisible() ? (this.fArrow != null ? arrowSize : this.fButton.computeSize(-1, height)) : (buttonSize = new Point(0, 0));
        }
        if (this.fArrow == null) {
            buttonSize.x = buttonSize.y = buttonSize.y != 0 ? buttonSize.y - 1 : 0;
        }
        int padding = this.fArrow != null && this.fArrow.isVisible() && this.fButton != null && this.fButton.isVisible() ? 1 : 0;
        this.fText.setBounds(0, 0, width - arrowSize.x - buttonSize.x - padding, height);
        if (this.fArrow != null) {
            this.fArrow.setBounds(width - arrowSize.x - buttonSize.x - padding, 0, arrowSize.x, arrowSize.y);
        }
        if (this.fButton != null) {
            this.fButton.setBounds(width - buttonSize.x, 0, buttonSize.x, buttonSize.y);
        }
        if (this.fList != null) {
            Point size = this.getSize();
            int itemHeight = this.fList.getItemHeight() * 5;
            Point listSize = this.fList.computeSize(-1, itemHeight);
            this.fList.setBounds(1, 1, Math.max(size.x - 2, listSize.x), listSize.y);
        }
    }

    void listEvent(Event event) {
        switch (event.type) {
            case 15: {
                if (this.fHasFocus) {
                    return;
                }
                this.fHasFocus = true;
                if (this.getEditable()) {
                    this.fText.selectAll();
                }
                Event e = new Event();
                e.time = event.time;
                this.notifyListeners(15, e);
                break;
            }
            case 16: {
                event.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (SnappyCombo.this.isDisposed()) {
                            return;
                        }
                        Control focusControl = SnappyCombo.this.getDisplay().getFocusControl();
                        if (focusControl == SnappyCombo.this.fText || SnappyCombo.this.fArrow != null && focusControl == SnappyCombo.this.fArrow || SnappyCombo.this.fButton != null && focusControl == SnappyCombo.this.fButton) {
                            return;
                        }
                        SnappyCombo.this.fHasFocus = false;
                        Event e = new Event();
                        SnappyCombo.this.notifyListeners(16, e);
                    }
                });
                break;
            }
            case 4: {
                if (event.button != 1) {
                    return;
                }
                this.dropDown(false);
                Event e = new Event();
                e.time = event.time;
                this.notifyListeners(14, e);
                break;
            }
            case 13: {
                int index;
                int n = index = this.fList != null ? this.fList.getSelectionIndex() : -1;
                if (index == -1) {
                    return;
                }
                this.fText.setText(this.fList.getItem(index));
                this.fText.setSelection(0, 0);
                this.fList.setSelection(index);
                Event e = new Event();
                e.time = event.time;
                e.stateMask = event.stateMask;
                e.doit = event.doit;
                this.notifyListeners(13, e);
                event.doit = e.doit;
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 2: 
                    case 4: 
                    case 16: 
                    case 32: 
                    case 64: {
                        event.doit = false;
                    }
                }
                Event e = new Event();
                e.time = event.time;
                e.detail = event.detail;
                e.doit = event.doit;
                e.keyCode = event.keyCode;
                this.notifyListeners(31, e);
                event.doit = e.doit;
                break;
            }
            case 2: {
                Event e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(2, e);
                break;
            }
            case 1: {
                Event e;
                if (event.character == '\u001b') {
                    this.dropDown(false);
                }
                if (event.character == '\r' || event.character == '\t') {
                    this.dropDown(false);
                    e = new Event();
                    e.time = event.time;
                    e.stateMask = event.stateMask;
                    this.notifyListeners(14, e);
                }
                if (this.isDisposed()) break;
                e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(1, e);
            }
        }
    }

    void popupEvent(Event event) {
        switch (event.type) {
            case 9: {
                if (this.fList == null) break;
                Rectangle listRect = this.fList.getBounds();
                Color black = this.getDisplay().getSystemColor(2);
                event.gc.setForeground(black);
                event.gc.drawRectangle(0, 0, listRect.width + 1, listRect.height + 1);
                break;
            }
            case 21: {
                event.doit = false;
                this.dropDown(false);
                break;
            }
            case 27: {
                this.dropDown(false);
            }
        }
    }

    public void redraw(int x, int y, int width, int height, boolean all) {
        this.checkWidget();
        if (!all) {
            return;
        }
        Point location = this.fText.getLocation();
        this.fText.redraw(x - location.x, y - location.y, width, height, all);
        if (this.fList != null) {
            location = this.fList.getLocation();
            this.fList.redraw(x - location.x, y - location.y, width, height, all);
        }
        if (this.fArrow != null) {
            location = this.fArrow.getLocation();
            this.fArrow.redraw(x - location.x, y - location.y, width, height, all);
        }
        if (this.fButton != null) {
            location = this.fButton.getLocation();
            this.fButton.redraw(x - location.x, y - location.y, width, height, all);
        }
    }

    public void remove(int index) {
        this.checkWidget();
        if (this.fList != null) {
            this.fList.remove(index);
        }
    }

    public void remove(int start, int end) {
        this.checkWidget();
        if (this.fList != null) {
            this.fList.remove(start, end);
        }
    }

    public void remove(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        if (this.fList != null) {
            this.fList.remove(string);
        }
    }

    public void removeAll() {
        this.checkWidget();
        this.fText.setText("");
        if (this.fList != null) {
            this.fList.removeAll();
        }
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(24, (SWTEventListener)listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(13, (SWTEventListener)listener);
        this.removeListener(14, (SWTEventListener)listener);
    }

    public void select(int index) {
        this.checkWidget();
        if (index == -1) {
            if (this.fList != null) {
                this.fList.deselectAll();
            }
            this.fText.setText("");
            return;
        }
        if (this.fList != null && index >= 0 && index < this.fList.getItemCount() && index != this.getSelectionIndex()) {
            this.fText.setText(this.fList.getItem(index));
            this.fText.setSelection(0, 0);
            this.fList.select(index);
            this.fList.showSelection();
            if (this.fButton != null && this.fCanHaveEmbeddedForm && !this.fButton.isDisposed()) {
                this.fButton.setEnabled("".equals(this.fText.getText()));
            }
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.fText != null) {
            this.fText.setBackground(color);
        }
        if (this.fList != null) {
            this.fList.setBackground(color);
        }
        if (this.fArrow != null) {
            this.fArrow.setBackground(color);
        }
        if (this.fButton != null) {
            this.fButton.setBackground(color);
        }
    }

    public boolean setFocus() {
        this.checkWidget();
        return this.fText.setFocus();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fText.setFont(font);
        if (this.fList != null) {
            this.fList.setFont(font);
        }
        this.internalLayout();
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.fText != null) {
            this.fText.setForeground(color);
        }
        if (this.fList != null) {
            this.fList.setForeground(color);
        }
        if (this.fArrow != null) {
            this.fArrow.setForeground(color);
        }
        if (this.fButton != null) {
            this.fButton.setForeground(color);
        }
    }

    public void setItem(int index, String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        if (this.fList != null) {
            this.fList.setItem(index, string);
        }
        if (this.fArrow != null) {
            this.fArrow.setVisible(this.fList.getItemCount() > 1);
        }
    }

    public void setItems(String[] items, boolean showButton, boolean canHaveEmbeddedForm) {
        this.checkWidget();
        this.fCanHaveEmbeddedForm = canHaveEmbeddedForm;
        if (items == null) {
            SWT.error((int)4);
        }
        if (this.fButton != null) {
            this.setButtonVisible(showButton);
        }
        if (this.fList != null) {
            this.fList.setItems(items);
        }
        if (this.fArrow != null) {
            this.fArrow.setVisible(this.fList.getItemCount() > 1);
        }
        this.internalLayout();
    }

    public void setButtonVisible(boolean showButton) {
        this.fButton.setVisible(showButton);
    }

    public void setSelection(Point selection) {
        this.checkWidget();
        if (selection == null) {
            SWT.error((int)4);
        }
        this.fText.setSelection(selection.x, selection.y);
    }

    public void setText(String string) {
        int index;
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        int n = index = this.fList != null ? this.fList.indexOf(string) : -1;
        if (index == -1) {
            if (this.fList != null) {
                this.fList.deselectAll();
            }
            this.fText.setText(string);
            return;
        }
        this.fText.setText(string);
        this.fText.setSelection(0, 0);
        if (this.fList != null) {
            this.fList.setSelection(index);
            this.fList.showSelection();
        }
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        this.fText.setTextLimit(limit);
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        super.setToolTipText(string);
        if (this.fArrow != null) {
            this.fArrow.setToolTipText(string);
        }
        if (this.fButton != null) {
            this.fButton.setToolTipText(string);
        }
        this.fText.setToolTipText(string);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible && this.fPopup != null) {
            this.fPopup.setVisible(false);
        }
    }

    void textEvent(Event event) {
        switch (event.type) {
            case 15: {
                if (this.fHasFocus) {
                    return;
                }
                this.fHasFocus = true;
                if (this.getEditable()) {
                    this.fText.selectAll();
                }
                Event e = new Event();
                e.time = event.time;
                this.notifyListeners(15, e);
                break;
            }
            case 16: {
                event.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (SnappyCombo.this.isDisposed()) {
                            return;
                        }
                        Control focusControl = SnappyCombo.this.getDisplay().getFocusControl();
                        if (SnappyCombo.this.fList != null && focusControl == SnappyCombo.this.fList || SnappyCombo.this.fArrow != null && focusControl == SnappyCombo.this.fArrow || SnappyCombo.this.fButton != null && focusControl == SnappyCombo.this.fButton) {
                            return;
                        }
                        SnappyCombo.this.fHasFocus = false;
                        Event e = new Event();
                        SnappyCombo.this.notifyListeners(16, e);
                    }
                });
                break;
            }
            case 1: {
                if (event.character == '\u001b') {
                    this.dropDown(false);
                }
                if (event.character == '\r') {
                    this.dropDown(false);
                    Event e = new Event();
                    e.time = event.time;
                    e.stateMask = event.stateMask;
                    this.notifyListeners(14, e);
                }
                if (this.isDisposed()) break;
                if (event.keyCode == 0x1000001 || event.keyCode == 0x1000002) {
                    int oldIndex = this.getSelectionIndex();
                    if (event.keyCode == 0x1000001) {
                        this.select(Math.max(oldIndex - 1, 0));
                    } else {
                        this.select(Math.min(oldIndex + 1, this.getItemCount() - 1));
                    }
                    if (oldIndex != this.getSelectionIndex()) {
                        Event e = new Event();
                        e.time = event.time;
                        e.stateMask = event.stateMask;
                        this.notifyListeners(13, e);
                    }
                    if (this.isDisposed()) break;
                }
                Event e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(1, e);
                break;
            }
            case 2: {
                Event e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(2, e);
                break;
            }
            case 24: {
                if (this.fList != null) {
                    this.fList.deselectAll();
                }
                Event e = new Event();
                e.time = event.time;
                this.notifyListeners(24, e);
                break;
            }
            case 3: {
                if (event.button != 1 || this.fText.getEditable()) {
                    return;
                }
                boolean dropped = this.isDropped();
                this.fText.setSelection(0, 0);
                if (!dropped) {
                    this.setFocus();
                }
                if (this.fArrow == null || !this.fArrow.isVisible()) break;
                this.dropDown(!dropped);
                break;
            }
            case 4: {
                if (event.button != 1 || this.fText.getEditable()) {
                    return;
                }
                this.fText.setSelection(0, 0);
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 4: 
                    case 32: 
                    case 64: {
                        event.doit = false;
                    }
                }
                Event e = new Event();
                e.time = event.time;
                e.detail = event.detail;
                e.doit = event.doit;
                e.keyCode = event.keyCode;
                this.notifyListeners(31, e);
                event.doit = e.doit;
            }
        }
    }

    private class ModifyTypedListener
    implements Listener {
        private ModifyListener fListener;

        private ModifyTypedListener(ModifyListener listener) {
            this.fListener = listener;
        }

        public void handleEvent(Event e) {
            switch (e.type) {
                case 24: {
                    this.fListener.modifyText(new ModifyEvent(e));
                }
            }
        }
    }

    private class SelectionTypedListener
    implements Listener {
        private SelectionListener fListener;

        private SelectionTypedListener(SelectionListener listener) {
            this.fListener = listener;
        }

        public void handleEvent(Event e) {
            switch (e.type) {
                case 13: {
                    SelectionEvent event = new SelectionEvent(e);
                    this.fListener.widgetSelected(event);
                    e.x = event.x;
                    e.y = event.y;
                    e.doit = event.doit;
                }
            }
        }
    }
}

