/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedatamodel.wizards;

import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TableResizeListener
extends ControlAdapter {
    private int[] fRatios;
    private Table fTable;
    protected int fX = -1;
    protected int fY = -1;
    protected Runnable fResizer = new Runnable(){

        @Override
        public void run() {
            if (TableResizeListener.this.fTable != null && !TableResizeListener.this.fTable.isDisposed()) {
                Point size = TableResizeListener.this.fTable.getSize();
                if (size.x != TableResizeListener.this.fX && size.x > 6 || size.y != TableResizeListener.this.fY && size.y > 6) {
                    TableResizeListener.this.fX = size.x;
                    TableResizeListener.this.fY = size.y;
                    int i = 0;
                    while (i < TableResizeListener.this.fRatios.length) {
                        TableColumn column = TableResizeListener.this.fTable.getColumn(i);
                        if (column != null && !column.isDisposed()) {
                            column.setWidth(size.x * TableResizeListener.this.fRatios[i] / 100);
                        }
                        if (i == TableResizeListener.this.fRatios.length - 1) {
                            column.setWidth(column.getWidth() - 4);
                        }
                        ++i;
                    }
                }
            }
        }
    };

    public TableResizeListener(Table table, int[] columnRatios) {
        this.fTable = table;
        this.fRatios = columnRatios != null ? columnRatios : new int[]{};
    }

    public void controlResized(ControlEvent e) {
        Display.getDefault().asyncExec(this.fResizer);
    }
}

