/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedatamodel.wizards;

import com.ibm.etools.webtools.pagedatamodel.PageDataModelPlugin;
import com.ibm.etools.webtools.pagedatamodel.databinding.CodeGenModelFactory;
import com.ibm.etools.webtools.pagedatamodel.databinding.CodeGenUtil;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenModel;
import com.ibm.etools.webtools.pagedatamodel.nls.ResourceHandler;
import com.ibm.etools.webtools.pagedatamodel.wizards.List_WizardPage;
import com.ibm.etools.webtools.pagedatamodel.wizards.Object_WizardPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class InsertData_Wizard
extends Wizard {
    protected ICodeGenModel fModel;
    IWizardPage[] fPages;
    boolean fCreateResultForm = true;

    public InsertData_Wizard(ICodeGenModel model) {
        this.setWindowTitle(this.getTitle(model));
        this.fModel = model;
    }

    public InsertData_Wizard(ICodeGenModel model, String title) {
        this.setWindowTitle(title);
        this.fModel = model;
    }

    public InsertData_Wizard(ICodeGenModel model, String title, IWizardPage page) {
        this(model, title, new IWizardPage[]{page});
    }

    public InsertData_Wizard(ICodeGenModel model, String title, IWizardPage[] pages) {
        this.setWindowTitle(title != null ? title : this.getTitle(model));
        this.fModel = model;
        this.fPages = pages;
    }

    protected String getTitle(ICodeGenModel model) {
        if (model != null) {
            return model.isList() ? ResourceHandler.Wiz_DL_Title : ResourceHandler.Wiz_DO_Title;
        }
        return "";
    }

    public boolean performFinish() {
        if (!this.fCreateResultForm) {
            this.fModel.setNextModel(null);
        }
        this.saveDialogSettings(this.fModel);
        if (CodeGenUtil.isTopModel(this.fModel)) {
            CodeGenModelFactory.finalizeModel(this.fModel);
        }
        return true;
    }

    protected void saveDialogSettings(ICodeGenModel model) {
        IDialogSettings settings = PageDataModelPlugin.getDefault().getDialogSettings();
        if (!model.isList()) {
            int controlType = model.getControlType();
            model.setCreateDeleteButton(model.isCreateDeleteButton() && controlType == 1);
            model.setCreateSubmitButton(model.isCreateSubmitButton() && controlType != 0);
            model.setGenValidation(model.isGenValidation() && controlType != 0);
            settings.put("CONTROL_TYPE", controlType);
            settings.put("COLON", model.isUseColon());
            if (controlType != 0) {
                settings.put("SUBMIT_BUTTON_CREATE", model.isCreateSubmitButton());
                if (model.getSubmitButtonLabel() != null) {
                    settings.put("SUBMIT_BUTTON_LABEL", model.getSubmitButtonLabel());
                }
            }
            if (controlType == 1 && this.isValidSetting("DELETE_BUTTON_CREATE")) {
                settings.put("DELETE_BUTTON_CREATE", model.isCreateDeleteButton());
                if (model.getDeleteButtonLabel() != null) {
                    settings.put("DELETE_BUTTON_LABEL", model.getDeleteButtonLabel());
                }
            }
            if (model.getControlId() != null) {
                settings.put("CONTROL_ID", model.getControlId());
            }
        }
        settings.put("add_label_component", Boolean.TRUE == model.getCustomProperty("add_label_component"));
        settings.put("CAPITALIZE", model.isCapitalizeLabel());
        settings.put("ALIGNMENT", model.getAlignment());
    }

    protected boolean isValidSetting(String setting) {
        return true;
    }

    public void addPages() {
        if (this.fPages == null) {
            if (this.fModel.isList()) {
                this.addPage((IWizardPage)new List_WizardPage(this.fModel));
            } else {
                this.addPage((IWizardPage)new Object_WizardPage(this.fModel));
            }
        } else {
            int i = 0;
            while (i < this.fPages.length) {
                this.addPage(this.fPages[i]);
                ++i;
            }
        }
    }

    public final ICodeGenModel getModel() {
        return this.fModel;
    }

    public void setResultModel(ICodeGenModel model) {
    }

    public void setCreateResultForm(boolean create) {
        this.fCreateResultForm = create;
    }
}

