/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedatamodel.wizards;

import com.ibm.etools.webtools.pagedatamodel.PageDataModelPlugin;
import com.ibm.etools.webtools.pagedatamodel.databinding.CodeGenModelFactory;
import com.ibm.etools.webtools.pagedatamodel.databinding.CodeGenUtil;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenModel;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.exceptions.UserCancelledException;
import com.ibm.etools.webtools.pagedatamodel.nls.ResourceHandler;
import com.ibm.etools.webtools.pagedatamodel.wizards.OptionsDialog;
import com.ibm.etools.webtools.pagedatamodel.wizards.Util;
import com.ibm.etools.webtools.pagedatamodel.wizards.internal.MultiEditorTableViewer;
import com.ibm.etools.webtools.pagedatamodel.wizards.internal.SnappyCombo;
import com.ibm.etools.webtools.pagedatamodel.wizards.internal.SnappyComboCellEditor;
import java.util.List;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class InsertData_TableComposite
implements Listener,
ICheckStateListener,
ISelectionChangedListener {
    private Button fUpButton;
    private Button fDownButton;
    private Button fOptionsButton;
    private Button fCheckAll;
    private Button fCheckNone;
    private Button fLinuxConfigureButton;
    protected Table fTable;
    protected MultiEditorTableViewer fTableViewer;
    protected ICodeGenModel fModel;
    protected ColumnResizer fColumnResizer;
    protected Hyperlink fLinkToTemplates;

    public InsertData_TableComposite(Composite parent, String compositeLabel, String column1Label, ICodeGenModel model) {
        this.fModel = model;
        this.createControl(parent, compositeLabel, column1Label);
    }

    private void createControl(Composite parent, String compositeLabel, String column1Label) {
        Composite a = Util.cc(parent, 1808);
        new Label(a, 0).setText(compositeLabel);
        this.createTableComposite(Util.cc(a, 1808, -1, -1, 2), column1Label);
        this.updateLinuxVisibility();
        this.updateRightSideButtons();
    }

    private void updateLinuxVisibility() {
        boolean needsToBeVisible = false;
        if (this.fLinuxConfigureButton != null && MultiEditorTableViewer.IS_GTK && this.fModel != null) {
            List nodes = this.fModel.getCodeGenNodes();
            for (ICodeGenNode node : nodes) {
                if (!node.isListNode()) continue;
                needsToBeVisible = true;
                break;
            }
            this.fLinuxConfigureButton.setVisible(needsToBeVisible);
        }
    }

    protected void createTableComposite(Composite tableComp, String column1Label) {
        this.fTable = new Table(tableComp, 67618);
        this.fTable.setHeaderVisible(true);
        this.fTable.setLinesVisible(false);
        GridData gd = new GridData(1808);
        this.fTable.setLayoutData((Object)gd);
        Util.cTC(this.fTable, column1Label);
        Util.cTC(this.fTable, ResourceHandler.Label_5);
        Util.cTC(this.fTable, ResourceHandler.Control_Type_6);
        this.fColumnResizer = new ColumnResizer();
        this.fTable.addControlListener((ControlListener)this.fColumnResizer);
        this.fTableViewer = new MultiEditorTableViewer(this.fTable);
        this.fTableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        if (this.fModel != null) {
            this.fTableViewer.setInput(this.fModel);
        }
        this.updateCheckedState();
        this.fTableViewer.addCheckStateListener(this);
        this.fTableViewer.addSelectionChangedListener(this);
        this.fTableViewer.setColumnProperties(new String[]{"0", "1", "2"});
        this.fTableViewer.setCellModifier(new TableCellModifier());
        this.fTableViewer.setMultiCellEditors(new int[]{3, 1, 2});
        if (MultiEditorTableViewer.IS_GTK) {
            int itemCount = this.fTable.getItemCount();
            int i = 0;
            while (i < itemCount) {
                TableItem item = this.fTable.getItem(i);
                String property = (String)this.fTableViewer.fTableViewerImpl.getColumnProperties()[2];
                ICellModifier modifier = this.fTableViewer.fTableViewerImpl.getCellModifier();
                modifier.getValue((Object)item, property);
                ++i;
            }
        }
        Composite upDownComp = Util.cc(tableComp, 4);
        this.fUpButton = Util.cb(upDownComp, 8, "", this, 772);
        this.fUpButton.setImage(PageDataModelPlugin.getDefault().getImage("full/up"));
        this.fUpButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.result = ResourceHandler.up;
                }
            }
        });
        this.fDownButton = Util.cb(upDownComp, 8, "", this, 772);
        this.fDownButton.setImage(PageDataModelPlugin.getDefault().getImage("full/down"));
        if (MultiEditorTableViewer.IS_GTK) {
            this.fLinuxConfigureButton = Util.cb(upDownComp, 8, "...", this, 772);
        }
        this.fDownButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.result = ResourceHandler.down;
                }
            }
        });
        Composite checkComp = Util.cc(tableComp, -1, -1, 0, 4);
        this.fCheckAll = Util.cb(checkComp, 8, ResourceHandler.Insert_Data_All, this, -1);
        this.fCheckAll.setToolTipText(ResourceHandler.Insert_Data_Select_All);
        this.fCheckNone = Util.cb(checkComp, 8, ResourceHandler.Insert_Data_None, this, -1);
        this.fCheckNone.setToolTipText(ResourceHandler.Insert_Data_Deselect_All);
        this.fOptionsButton = Util.cb(checkComp, 8, ResourceHandler.Options____9, this, -1);
        this.fLinkToTemplates = this.createHyperLink(checkComp, ResourceHandler.linkToTemplatePref);
        this.fLinkToTemplates.setVisible(false);
        this.updateTemplateLinkVisibility();
        new Label(tableComp, 0).setText("");
    }

    public void setModel(ICodeGenModel model) {
        this.fModel = model;
        if (this.fTableViewer != null) {
            this.fTableViewer.setInput(model);
            this.updateCheckedState();
            this.fTableViewer.setMultiCellEditors(new int[]{3, 1, 2});
            this.updateLinuxVisibility();
            this.updateAll();
            this.refresh();
        }
    }

    private void updateCheckedState() {
        List cgNodes;
        if (this.fTableViewer != null && this.fModel != null && (cgNodes = this.fModel.getCodeGenNodes()) != null && cgNodes.size() > 0) {
            for (ICodeGenNode node : cgNodes) {
                if (!node.isSelected()) continue;
                this.fTableViewer.setChecked(node, true);
            }
        }
    }

    private void selectAll(boolean select) {
        List cgNodes;
        if (this.fTableViewer != null && this.fModel != null && (cgNodes = this.fModel.getCodeGenNodes()) != null && cgNodes.size() > 0) {
            for (ICodeGenNode node : cgNodes) {
                node.setSelected(select);
                this.fTableViewer.setChecked(node, select);
            }
        }
    }

    public final void refresh() {
        this.fTableViewer.refresh();
        this.updateRightSideButtons();
        this.updateTemplateLinkVisibility();
    }

    public final void updateAll() {
        this.fTableViewer.updateAll();
    }

    public void handleEvent(Event event) {
        if (this.fModel != null) {
            ICodeGenModel cgModel;
            ICodeGenNode node;
            Widget w = event.widget;
            if (w == this.fOptionsButton) {
                OptionsDialog dialog = this.fModel.getRoot().getEnclosedNode().getCodeGenModelFactory().getOptionsDialog(this.fOptionsButton.getShell(), this.fModel);
                if (dialog.open() == 0) {
                    this.setModel(this.fModel);
                }
            } else if (w == this.fDownButton) {
                this.fModel.moveDown(this.getSelectedNode());
                this.refresh();
                int index = this.fTable.getSelectionIndex();
                this.fTableViewer.update(index);
                this.fTableViewer.update(index - 1);
                this.fDownButton.setFocus();
            } else if (w == this.fUpButton) {
                this.fModel.moveUp(this.getSelectedNode());
                this.refresh();
                int index = this.fTable.getSelectionIndex();
                this.fTableViewer.update(index);
                this.fTableViewer.update(index + 1);
                this.fUpButton.setFocus();
            } else if (w == this.fCheckAll) {
                this.selectAll(true);
            } else if (w == this.fCheckNone) {
                this.selectAll(false);
            } else if (this.fLinuxConfigureButton != null && w == this.fLinuxConfigureButton && (node = this.getSelectedNode()).isListNode() && (cgModel = node.getChildCodeGenModel()) != null) {
                try {
                    CodeGenModelFactory.configureInWizard(cgModel, this.fLinuxConfigureButton.getShell().getLocation().x + 40);
                }
                catch (UserCancelledException userCancelledException) {}
            }
            this.fTableViewer.reflowTableEditors();
        }
    }

    ICodeGenNode getSelectedNode() {
        ICodeGenNode node = null;
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        if (selection != null) {
            node = (ICodeGenNode)selection.getFirstElement();
        }
        return node;
    }

    public void resizeColumns() {
        this.fColumnResizer.resizeColumns();
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        ((ICodeGenNode)event.getElement()).setSelected(event.getChecked());
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateRightSideButtons();
    }

    private void updateRightSideButtons() {
        int index = this.fTable.getSelectionIndex();
        int itemCount = this.fTable.getItemCount();
        boolean oneSelected = this.fTable.getSelectionCount() == 1;
        this.fUpButton.setEnabled(index > 0 && index <= itemCount - 1 && oneSelected);
        this.fDownButton.setEnabled(index >= 0 && index < itemCount - 1 && oneSelected);
        if (this.fLinuxConfigureButton != null) {
            ICodeGenNode node = this.getSelectedNode();
            this.fLinuxConfigureButton.setEnabled(node != null && node.isListNode());
        }
    }

    public final Table getTable() {
        return this.fTable;
    }

    protected void updateTemplateLinkVisibility() {
        if (this.fLinkToTemplates != null) {
            if (this.fModel != null && "JSF".equals(this.fModel.getPageType())) {
                this.fLinkToTemplates.setVisible(true);
            } else {
                this.fLinkToTemplates.setVisible(false);
            }
        }
    }

    private Hyperlink createHyperLink(Composite parent, String linkText) {
        Hyperlink link = new Hyperlink(parent, 0);
        GridData layout = new GridData(40);
        layout.horizontalSpan = 1;
        link.setLayoutData((Object)layout);
        link.setUnderlined(true);
        Color color = new Color((Device)parent.getDisplay(), new RGB(0, 0, 255));
        link.setForeground(color);
        link.setText(linkText);
        link.addHyperlinkListener(new IHyperlinkListener(){

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent event) {
                try {
                    PreferencesUtil.createPreferenceDialogOn((Shell)PageDataModelPlugin.getShell(), (String)"com.ibm.etools.jsf.datatemplates.propertytemplates.preferences", null, null).open();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return link;
    }

    class ColumnResizer
    extends ControlAdapter {
        protected int fX = -1;
        protected int fY = -1;
        protected Runnable fResizer = new Runnable(){

            @Override
            public void run() {
                if (((ColumnResizer)ColumnResizer.this).InsertData_TableComposite.this.fTable != null && !((ColumnResizer)ColumnResizer.this).InsertData_TableComposite.this.fTable.isDisposed()) {
                    Point size = ((ColumnResizer)ColumnResizer.this).InsertData_TableComposite.this.fTable.getSize();
                    if (size.x > 6 && size.y > 6 && (size.x != ColumnResizer.this.fX || size.y != ColumnResizer.this.fY)) {
                        ColumnResizer.this.fX = size.x;
                        ColumnResizer.this.fY = size.y;
                        TableColumn column = ((ColumnResizer)ColumnResizer.this).InsertData_TableComposite.this.fTable.getColumn(0);
                        if (column != null && !column.isDisposed()) {
                            column.setWidth(size.x * 45 / 100);
                        }
                        if ((column = ((ColumnResizer)ColumnResizer.this).InsertData_TableComposite.this.fTable.getColumn(1)) != null && !column.isDisposed()) {
                            column.setWidth(size.x * 27 / 100);
                        }
                        if ((column = ((ColumnResizer)ColumnResizer.this).InsertData_TableComposite.this.fTable.getColumn(2)) != null && !column.isDisposed()) {
                            ScrollBar vBar = ((ColumnResizer)ColumnResizer.this).InsertData_TableComposite.this.fTable.getVerticalBar();
                            int scrollWidth = vBar.getMaximum() == vBar.getThumb() ? 0 : vBar.getSize().x + 2;
                            column.setWidth(size.x * 28 / 100 - scrollWidth - 4);
                        }
                    }
                }
            }
        };

        ColumnResizer() {
        }

        public void controlResized(ControlEvent e) {
            this.resizeColumns();
        }

        public void resizeColumns() {
            Display.getDefault().asyncExec(this.fResizer);
        }
    }

    class TableCellModifier
    implements ICellModifier {
        TableCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return property == "1" || property == "2";
        }

        public Object getValue(Object element, String property) {
            ICodeGenNode cgNode = null;
            TableItem item = null;
            if (element != null && element instanceof TableItem) {
                item = (TableItem)element;
                Object data = item.getData();
                if (data != null && data instanceof ICodeGenNode) {
                    cgNode = (ICodeGenNode)data;
                }
            } else if (element != null && element instanceof ICodeGenNode) {
                cgNode = (ICodeGenNode)element;
            }
            if (cgNode == null) {
                return null;
            }
            Object result = "";
            if (property.equals("0")) {
                result = cgNode.getFieldNameLabel();
                if (result == null) {
                    result = "";
                }
            } else if (property.equals("1")) {
                result = cgNode.getLabel();
                if (result == null) {
                    result = "";
                }
            } else if (property.equals("2")) {
                boolean isComplexObject;
                String controlLabel = CodeGenUtil.getLabelForControl(cgNode.getControlId(), InsertData_TableComposite.this.fModel);
                List controls = CodeGenModelFactory.getControls(cgNode);
                String[] items = null;
                if (controls != null) {
                    items = new String[controls.size()];
                    int i = 0;
                    while (i < items.length) {
                        items[i] = CodeGenUtil.getLabelForControl((String)controls.get(i), InsertData_TableComposite.this.fModel);
                        ++i;
                    }
                }
                if (items == null || items.length == 0) {
                    items = new String[]{controlLabel == null ? "" : controlLabel};
                }
                boolean showChildModelButton = cgNode.getChildCodeGenModel() != null;
                boolean bl = isComplexObject = cgNode.getChildCodeGenModel() != null && !cgNode.isListNode();
                if (!MultiEditorTableViewer.IS_GTK) {
                    ((SnappyComboCellEditor)((Object)item.getData("cellEditor"))).setItems(items, showChildModelButton, isComplexObject);
                } else {
                    ((SnappyComboCellEditor)InsertData_TableComposite.this.fTableViewer.getCellEditors()[2]).setItems(items, showChildModelButton, isComplexObject);
                }
                int index = -1;
                int i = 0;
                while (i < items.length) {
                    if (items[i].equals(controlLabel)) {
                        index = i;
                        break;
                    }
                    ++i;
                }
                if (index == -1 && controls.size() > 0) {
                    cgNode.setControlId((String)controls.get(0));
                    item.setText(2, items[0]);
                    index = 0;
                }
                result = new Integer(index);
            }
            return result;
        }

        public void modify(Object element, String property, Object value) {
            TableItem item = (TableItem)element;
            ICodeGenNode node = (ICodeGenNode)item.getData();
            if (property.equals("1")) {
                String input = value != null ? (String)value : "";
                node.setLabel(input);
                item.setText(0, input);
            } else if (property.equals("2")) {
                int index;
                List controls = CodeGenModelFactory.getControls(node);
                int n = index = MultiEditorTableViewer.IS_GTK ? ((SnappyCombo)((SnappyComboCellEditor)InsertData_TableComposite.this.fTableViewer.getCellEditors()[2]).getControl()).getSelectionIndex() : ((SnappyCombo)((SnappyComboCellEditor)((Object)item.getData("cellEditor"))).getControl()).getSelectionIndex();
                if (controls != null && controls.size() > index && index > -1) {
                    node.setControlId((String)controls.get(index));
                }
            }
            InsertData_TableComposite.this.fTableViewer.refresh();
        }
    }

    class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return InsertData_TableComposite.this.fModel != null ? InsertData_TableComposite.this.fModel.getCodeGenNodes().toArray() : null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ICodeGenNode node = (ICodeGenNode)element;
            String text = "";
            if (columnIndex == 0) {
                text = node.getFieldNameLabel();
            } else if (columnIndex == 1) {
                text = node.getLabel();
            } else if (columnIndex == 2) {
                text = CodeGenUtil.getLabelForControl(node.getControlId(), InsertData_TableComposite.this.fModel);
            }
            return text != null ? text : "";
        }
    }
}

