/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedatamodel.util;

import com.ibm.etools.webtools.pagedatamodel.PageDataModelPlugin;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNodeProvider;
import com.ibm.etools.webtools.pagedatamodel.api.IPageTypeInspector;
import com.ibm.etools.webtools.pagedatamodel.impl.PageDataModel;
import com.ibm.etools.webtools.pagedatamodel.impl.PageDataModelAdapter;
import com.ibm.etools.webtools.pagedatamodel.impl.PageDataNodeAdapter;
import com.ibm.etools.webtools.pagedatamodel.impl.PageDataNodeProvidersRegistryReader;
import com.ibm.etools.webtools.pagedatamodel.impl.internal.PageTypeInspectorsRegistryReader;
import com.ibm.etools.webtools.pagedatamodel.impl.internal.RootPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.sse.api.ISSEPageDataNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.xml.core.internal.document.NodeImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class PageDataModelUtil {
    public static IPageDataModel getPageDataModel(IDOMNode node) {
        IDOMDocument document = null;
        document = node.getNodeType() == 9 ? (IDOMDocument)node : (IDOMDocument)node.getOwnerDocument();
        INodeAdapter adptr = document.getAdapterFor((Object)PageDataModelAdapter.ADAPTER_KEY);
        if (adptr != null) {
            return ((PageDataModelAdapter)adptr).getPageDataModel();
        }
        return null;
    }

    public static boolean containsPageDataNodeAdapters(IDOMNode node) {
        Collection adapters = node.getAdapters();
        if (adapters == null || adapters.isEmpty()) {
            return false;
        }
        Iterator itr = adapters.iterator();
        while (itr.hasNext()) {
            if (!(itr.next() instanceof PageDataNodeAdapter)) continue;
            return true;
        }
        return false;
    }

    public static List getAllPageTypesForDocument(Document document) {
        ArrayList<String> pageTypes = new ArrayList<String>();
        IPageTypeInspector[] inspectors = PageTypeInspectorsRegistryReader.getPageTypeInspectors(PageDataModelUtil.getOwningResource((IDOMNode)((IDOMDocument)document)).getProject());
        if (inspectors != null && inspectors.length > 0) {
            int i = 0;
            while (i < inspectors.length) {
                try {
                    String type = inspectors[i].getPageType(document);
                    if (type != null) {
                        pageTypes.add(type);
                    }
                }
                catch (RuntimeException e) {
                    PageDataModelPlugin.getDefault().write("RuntimeException while processing inspector: " + inspectors[i]);
                    PageDataModelPlugin.getDefault().write(e);
                }
                ++i;
            }
        }
        return pageTypes;
    }

    public static String createUniqueAdapterKey(IPageDataNodeProvider provider) {
        return "PageDataNodeAdapterFactory" + provider.getTypeID();
    }

    public static void addChildWithOrdering(IPageDataModel model, ISSEPageDataNode child) {
        IPageDataNode root = model.getRoot();
        EList childrenList = root.getChildren();
        if (childrenList == null || childrenList.size() == 0) {
            root.addChild(child);
        } else {
            Iterator itr = childrenList.iterator();
            int index = 0;
            while (itr.hasNext()) {
                IPageDataNode current = (IPageDataNode)itr.next();
                if (!(current instanceof ISSEPageDataNode)) continue;
                IDOMNode currentDOMNode = ((ISSEPageDataNode)current).getDOMNode();
                IDOMNode childDOMNode = child.getDOMNode();
                if (currentDOMNode != null && childDOMNode != null && currentDOMNode.getStartOffset() > childDOMNode.getStartOffset()) break;
                ++index;
            }
            root.addChild(child, index);
        }
    }

    public static void handleRemove(IDOMNode removedChild) {
        int i;
        EList nodes;
        int pointer = 0;
        if (PageDataModelUtil.containsPageDataNodeAdapters(removedChild)) {
            pointer = PageDataModelUtil.internalRemove(removedChild);
        } else {
            nodes = PageDataModelUtil.getPageDataModel(removedChild).getRoot().getChildren();
            if (nodes == null || nodes.size() <= 0) {
                return;
            }
            int referencePos = removedChild.getStartOffset();
            pointer = 0;
            i = 0;
            int size = nodes.size();
            while (i < size) {
                IDOMNode xmlNode;
                IPageDataNode node = (IPageDataNode)nodes.get(i);
                if (node instanceof ISSEPageDataNode && PageDataModelUtil.isValidDOMNode(xmlNode = ((ISSEPageDataNode)node).getDOMNode()) && xmlNode.getStartOffset() >= referencePos) {
                    pointer = i;
                    break;
                }
                ++i;
            }
        }
        if (removedChild.getNodeType() != 1) {
            return;
        }
        nodes = PageDataModelUtil.getPageDataModel(removedChild).getRoot().getChildren();
        if (nodes == null) {
            return;
        }
        int size = nodes.size();
        i = size - 1;
        while (i >= pointer) {
            ISSEPageDataNode node;
            IDOMNode domNode;
            if (nodes.get(i) instanceof ISSEPageDataNode && (domNode = (node = (ISSEPageDataNode)nodes.get(i)).getDOMNode()) != null && !PageDataModelUtil.isValidDOMNode(domNode)) {
                node.getParent().removeChild(node);
            }
            --i;
        }
    }

    private static int internalRemove(IDOMNode removedChild) {
        List pageTypes = PageDataModelUtil.getAllPageTypesForDocument((Document)removedChild.getModel().getDocument());
        IPageDataNodeProvider[] providers = PageDataNodeProvidersRegistryReader.getPageDataNodeProviders(pageTypes);
        int index = 0;
        int i = 0;
        while (i < providers.length) {
            PageDataNodeAdapter adapter = (PageDataNodeAdapter)removedChild.getExistingAdapter((Object)PageDataModelUtil.createUniqueAdapterKey(providers[i]));
            if (adapter != null) {
                IPageDataNode pageDataNode = adapter.getPageDataNode();
                if (pageDataNode != null) {
                    index = pageDataNode.getParent().getChildren().indexOf((Object)pageDataNode);
                    if (index == -1) {
                        index = 0;
                    }
                    pageDataNode.getParent().removeChild(pageDataNode);
                }
                removedChild.removeAdapter((INodeAdapter)adapter);
            }
            ++i;
        }
        return index;
    }

    public static boolean isValidDOMNode(IDOMNode node) {
        String value;
        boolean valid;
        if (node instanceof NodeImpl) {
            valid = node != null && ((NodeImpl)node).getContainerDocument() != null;
        } else {
            boolean bl = valid = node != null && (node.getStartStructuredDocumentRegion() != null || node.getEndStructuredDocumentRegion() != null);
        }
        if (!valid && node != null && ((value = node.getNodeName()).endsWith("useCBDataObject") || value.endsWith("useCBDataList"))) {
            valid = true;
        }
        return valid;
    }

    public static boolean isComponentNode(IPageDataNode node) {
        IPageDataNode parent = node.getParent();
        return parent != null && parent instanceof RootPageDataNode;
    }

    public static void deletePageData(ISSEPageDataNode toDelete) {
        if (PageDataModelUtil.isStaticPageDataNode(toDelete)) {
            toDelete.getParent().removeChild(toDelete);
        } else {
            IDOMNode domNode = toDelete.getDOMNode();
            if (domNode != null) {
                domNode.getParentNode().removeChild((Node)domNode);
            }
        }
    }

    public static boolean isStaticPageDataNode(IPageDataNode node) {
        boolean isStatic = false;
        while (node != null && !isStatic) {
            isStatic = ((PageDataModel)node.getPageDataModel()).isStaticPageDataNode(node);
            node = node.getParent();
        }
        return isStatic;
    }

    public static IFile getOwningResource(IDOMNode node) {
        Path resourcePath;
        String baseLoc = node.getModel().getBaseLocation();
        IWorkspaceRoot root = PageDataModelPlugin.getWorkspace().getRoot();
        if (baseLoc == null || baseLoc.length() == 0) {
            String id = node.getModel().getId();
            if (id == null) {
                return null;
            }
            baseLoc = id.toString();
        }
        IFile file = (resourcePath = new Path(baseLoc)).toFile().exists() ? root.getFileForLocation((IPath)resourcePath) : root.getFile((IPath)resourcePath);
        return file;
    }
}

