/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedatamodel.impl.internal;

import com.ibm.etools.webtools.pagedatamodel.PageDataModelPlugin;
import com.ibm.etools.webtools.pagedatamodel.api.IPageTypeInspector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.sse.ui.internal.util.RegistryReader;

public class PageTypeInspectorsRegistryReader
extends RegistryReader {
    public static final String INSPECTOR_EXT_PNT_ID = "pageTypeInspectors";
    public static final String INSPECTOR_ELMNT = "inspector";
    public static final String CLASS_ATT = "class";
    public static final String ELEM_FACET = "facet";
    public static final String ATT_FACET_EXISTS = "exists";
    public static final String ATT_FACET_VERSION = "version";
    public static final String ELEM_OR = "or";
    private static PageTypeInspectorsRegistryReader singleton;
    private List pageTypeInspectorConfigElements = new ArrayList(1);
    private Map cachedPageTypeInspectorClasses = new HashMap();
    private boolean pageTypeInspectorsParsed = false;

    protected PageTypeInspectorsRegistryReader() {
    }

    private void parsePageTypeInspectors() {
        this.readRegistry(Platform.getExtensionRegistry(), PageDataModelPlugin.getDefault().getBundle().getSymbolicName(), INSPECTOR_EXT_PNT_ID);
    }

    protected boolean readElement(IConfigurationElement element) {
        if (element.getName().equalsIgnoreCase(INSPECTOR_ELMNT)) {
            return this.parseInspectorElement(element);
        }
        return false;
    }

    private boolean parseInspectorElement(IConfigurationElement element) {
        String listenerClass = element.getAttribute(CLASS_ATT);
        if (listenerClass != null) {
            this.pageTypeInspectorConfigElements.add(element);
            return true;
        }
        return false;
    }

    public static IPageTypeInspector[] getPageTypeInspectors(IProject project) {
        if (singleton == null) {
            singleton = new PageTypeInspectorsRegistryReader();
        }
        return singleton.getInspectors(project);
    }

    private IPageTypeInspector[] getInspectors(IProject project) {
        if (!this.pageTypeInspectorsParsed) {
            this.parsePageTypeInspectors();
            this.pageTypeInspectorsParsed = true;
        }
        ArrayList<Object> classesForThisProject = new ArrayList<Object>();
        int i = 0;
        while (i < this.pageTypeInspectorConfigElements.size()) {
            IConfigurationElement element = (IConfigurationElement)this.pageTypeInspectorConfigElements.get(i);
            IConfigurationElement[] facetElements = element.getChildren(ELEM_FACET);
            IConfigurationElement[] orLists = element.getChildren(ELEM_OR);
            boolean orGroupsSatisfied = true;
            int j = 0;
            while (j < orLists.length) {
                if (!this.processOrList(orLists[j], project)) {
                    orGroupsSatisfied = false;
                    break;
                }
                ++j;
            }
            if (orGroupsSatisfied) {
                boolean facetsSatisfied = true;
                int j2 = 0;
                while (j2 < facetElements.length) {
                    String facetID = facetElements[j2].getAttribute("id");
                    boolean shouldExist = facetElements[j2].getAttribute(ATT_FACET_EXISTS) == null ? true : Boolean.valueOf(facetElements[j2].getAttribute(ATT_FACET_EXISTS));
                    if (this.projectHasFacet(project, facetID, null) != shouldExist) {
                        facetsSatisfied = false;
                        break;
                    }
                    ++j2;
                }
                if (facetsSatisfied) {
                    try {
                        Object inspectorClass;
                        if (this.cachedPageTypeInspectorClasses.get(element) == null) {
                            inspectorClass = element.createExecutableExtension(CLASS_ATT);
                            this.cachedPageTypeInspectorClasses.put(element, inspectorClass);
                        } else {
                            inspectorClass = this.cachedPageTypeInspectorClasses.get(element);
                        }
                        classesForThisProject.add(inspectorClass);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            }
            ++i;
        }
        return classesForThisProject.toArray(new IPageTypeInspector[0]);
    }

    private boolean projectHasFacet(IProject project, String facetID, String facetVersion) {
        boolean hasFacet = false;
        if (ProjectFacetsManager.isProjectFacetDefined((String)facetID)) {
            IProjectFacet requiredFacet;
            IFacetedProject facetedProject = null;
            try {
                facetedProject = ProjectFacetsManager.create((IProject)project);
            }
            catch (CoreException ce) {
                ce.printStackTrace();
            }
            if (facetedProject != null && (requiredFacet = ProjectFacetsManager.getProjectFacet((String)facetID)) != null) {
                if (facetVersion != null) {
                    IProjectFacetVersion requiredFacetVersion = requiredFacet.getVersion(facetVersion);
                    if (requiredFacetVersion != null) {
                        hasFacet = facetedProject.hasProjectFacet(requiredFacetVersion);
                    }
                } else {
                    hasFacet = facetedProject.hasProjectFacet(requiredFacet);
                }
            }
        }
        return hasFacet;
    }

    private boolean processOrList(IConfigurationElement orList, IProject proj) {
        boolean satisfied = false;
        IConfigurationElement[] facets = orList.getChildren(ELEM_FACET);
        int i = 0;
        while (i < facets.length) {
            IConfigurationElement facetElement = facets[i];
            boolean shouldExist = facetElement.getAttribute(ATT_FACET_EXISTS) == null ? true : Boolean.valueOf(facetElement.getAttribute(ATT_FACET_EXISTS));
            String facetID = facetElement.getAttribute("id");
            String facetVersion = facetElement.getAttribute(ATT_FACET_VERSION);
            if (facetVersion == "") {
                facetVersion = null;
            }
            if (this.projectHasFacet(proj, facetID, facetVersion) == shouldExist) {
                satisfied = true;
                break;
            }
            ++i;
        }
        return satisfied;
    }
}

