/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedatamodel.impl.internal;

import com.ibm.etools.webtools.pagedatamodel.PageDataModelPlugin;
import com.ibm.etools.webtools.pagedatamodel.api.IGenControlPanel;
import com.ibm.etools.webtools.pagedatamodel.databinding.exceptions.BeanInfoNatureNotFoundException;
import com.ibm.etools.webtools.pagedatamodel.impl.GenControlPanel;
import com.ibm.etools.webtools.pagedatamodel.impl.internal.GeneratorElement;
import com.ibm.icu.util.StringTokenizer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.sse.ui.internal.extension.RegistryReader;

public class CodeGenRegistryReader
extends RegistryReader {
    public static final String CM_EXTPNT_ID = "controlMaps";
    public static final String CM_CtrlMap_ELMNT = "controlMap";
    public static final String CM_Ctrls_ELMNT = "controls";
    public static final String CM_Ctrl_ELMNT = "control";
    public static final String CM_ATTR_Template = "template";
    public static final String CM_DefCtrl_ELMNT = "defaultControl";
    public static final String CM_Map_ELMNT = "map";
    public static final String CM_Entry_ELMNT = "entry";
    public static final String CM_ATTR_RT_TYPE = "runtimeType";
    public static final String CM_ATTR_Ctrls_In = "controlsForInput";
    public static final String CM_ATTR_Ctrls_Out = "controlsForOutput";
    public static final String CM_ATTR_CGen = "codeGenerator";
    public static final String CM_DefGen_ELMNT = "defaultCodeGenerator";
    public static final String CM_DYNAMIC_COMPILE = "dynamicCompile";
    public static final String CLASS_ATT = "class";
    protected static final String LABEL_ATT = "label";
    protected static final String ID_ATT = "id";
    protected static final String ICON_ATT = "icon";
    protected static final String CAT_ATT = "category";
    protected static final String CAT_ELMNT = "category";
    protected static final String PT_ATT = "pageType";
    protected static final String CONTRL_PANEL_ATT = "controlPanel";
    private Map controlMaps = new HashMap();
    private Map customControlMaps = new HashMap();
    private boolean cmPartiallyParsed = false;
    private boolean cmFullyParsed = false;
    private IVirtualComponent virtualComponent;
    private static CodeGenRegistryReader singleton;

    protected CodeGenRegistryReader() {
    }

    public static IGenControlPanel getControlMapForPageType(String typeId, IVirtualComponent vc) {
        if (singleton == null) {
            singleton = new CodeGenRegistryReader();
        }
        CodeGenRegistryReader.singleton.virtualComponent = vc;
        if (!CodeGenRegistryReader.singleton.cmPartiallyParsed) {
            singleton.parseCMs();
            CodeGenRegistryReader.singleton.cmPartiallyParsed = true;
        }
        if (!CodeGenRegistryReader.singleton.cmFullyParsed) {
            singleton.parseCMs();
            CodeGenRegistryReader.singleton.cmFullyParsed = true;
        }
        GenControlPanel genControlPanel = (GenControlPanel)CodeGenRegistryReader.singleton.controlMaps.get(typeId);
        if (CodeGenRegistryReader.singleton.customControlMaps.get(typeId) == null) {
            return genControlPanel;
        }
        IGenControlPanel customPanel = null;
        IConfigurationElement element = (IConfigurationElement)CodeGenRegistryReader.singleton.customControlMaps.get(typeId);
        try {
            customPanel = (IGenControlPanel)element.createExecutableExtension(CONTRL_PANEL_ATT);
            ((GenControlPanel)customPanel).initialize(genControlPanel);
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
        return customPanel;
    }

    public static IGenControlPanel getControlMapForPageType(String typeId) throws BeanInfoNatureNotFoundException {
        if (singleton == null) {
            singleton = new CodeGenRegistryReader();
        }
        if (!CodeGenRegistryReader.singleton.cmPartiallyParsed) {
            singleton.parseCMs();
            CodeGenRegistryReader.singleton.cmPartiallyParsed = true;
        }
        GenControlPanel genControlPanel = (GenControlPanel)CodeGenRegistryReader.singleton.controlMaps.get(typeId);
        if (CodeGenRegistryReader.singleton.customControlMaps.get(typeId) == null) {
            return genControlPanel;
        }
        IGenControlPanel customPanel = null;
        IConfigurationElement element = (IConfigurationElement)CodeGenRegistryReader.singleton.customControlMaps.get(typeId);
        try {
            customPanel = (IGenControlPanel)element.createExecutableExtension(CONTRL_PANEL_ATT);
            ((GenControlPanel)customPanel).initialize(genControlPanel);
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
        return customPanel;
    }

    public static IGenControlPanel[] getControlMaps() {
        if (singleton == null) {
            return null;
        }
        return CodeGenRegistryReader.singleton.controlMaps.values().toArray(new IGenControlPanel[0]);
    }

    protected boolean readElement(IConfigurationElement element) {
        if (element.getName().equalsIgnoreCase(CM_CtrlMap_ELMNT)) {
            if (!this.cmPartiallyParsed) {
                return this.parseControlMapElement1(element);
            }
            return this.parseControlMapElement2(element);
        }
        return false;
    }

    private boolean parseControlMapElement1(IConfigurationElement element) {
        String pageType = element.getAttribute(PT_ATT);
        if (pageType == null) {
            return false;
        }
        GenControlPanel map = (GenControlPanel)this.controlMaps.get(pageType);
        if (map == null) {
            map = new GenControlPanel();
        }
        if (element.getAttribute(CONTRL_PANEL_ATT) != null) {
            this.customControlMaps.put(pageType, element);
        }
        IConfigurationElement[] children = element.getChildren();
        int i = 0;
        while (children != null && i < children.length) {
            IConfigurationElement child = children[i];
            if (child.getName().equalsIgnoreCase(CM_Ctrls_ELMNT)) {
                IConfigurationElement[] innerChildren = child.getChildren();
                int j = 0;
                while (innerChildren != null && j < innerChildren.length) {
                    IConfigurationElement innerChild = innerChildren[j];
                    if (innerChild.getName().equalsIgnoreCase(CM_Ctrl_ELMNT)) {
                        String dynamicCompile;
                        URL relativeUrl = Platform.getBundle((String)element.getDeclaringExtension().getNamespace()).getEntry("/");
                        String template_full_path = String.valueOf(relativeUrl.toExternalForm()) + innerChild.getAttribute(CM_ATTR_Template);
                        map.addControl(innerChild.getAttribute(ID_ATT), innerChild.getAttribute(LABEL_ATT), template_full_path, innerChild);
                        Platform.getBundle((String)element.getDeclaringExtension().getNamespace()).getEntry("/");
                        String id = Platform.getBundle((String)child.getDeclaringExtension().getNamespace()).getSymbolicName();
                        if (id != null) {
                            map.addPluginIdForTemplate(id, template_full_path);
                        }
                        if ((dynamicCompile = innerChild.getAttribute(CM_DYNAMIC_COMPILE)) != null && dynamicCompile.equals("true")) {
                            map.addDynamicTemplate(innerChild.getAttribute(ID_ATT));
                        }
                    }
                    ++j;
                }
            } else if (child.getName().equalsIgnoreCase(CM_DefCtrl_ELMNT)) {
                map.setDefaultControlId(child.getAttribute(ID_ATT));
            }
            ++i;
        }
        this.controlMaps.put(pageType, map);
        return true;
    }

    private boolean parseControlMapElement2(IConfigurationElement element) {
        String pageType = element.getAttribute(PT_ATT);
        if (pageType == null) {
            return false;
        }
        GenControlPanel map = (GenControlPanel)this.controlMaps.get(pageType);
        if (map == null) {
            map = new GenControlPanel();
        }
        IConfigurationElement[] children = element.getChildren();
        int i = 0;
        while (children != null && i < children.length) {
            IConfigurationElement child = children[i];
            if (child.getName().equalsIgnoreCase(CM_Map_ELMNT)) {
                IConfigurationElement[] innerChildren = child.getChildren();
                int j = 0;
                while (innerChildren != null && j < innerChildren.length) {
                    String clazz;
                    IConfigurationElement innerChild = innerChildren[j];
                    if (innerChild.getName().equalsIgnoreCase(CM_Entry_ELMNT)) {
                        String genClass;
                        String inputIds;
                        String rtType = innerChild.getAttribute(CM_ATTR_RT_TYPE);
                        String outputIds = innerChild.getAttribute(CM_ATTR_Ctrls_Out);
                        if (outputIds != null && outputIds.length() > 0) {
                            List idList = this.getControlList(outputIds);
                            try {
                                map.addControlsForRT(rtType, idList, false, CodeGenRegistryReader.singleton.virtualComponent);
                            }
                            catch (CoreException coreException) {
                                throw new BeanInfoNatureNotFoundException(CodeGenRegistryReader.singleton.virtualComponent);
                            }
                        }
                        if ((inputIds = innerChild.getAttribute(CM_ATTR_Ctrls_In)) != null && inputIds.length() > 0) {
                            List idList = this.getControlList(inputIds);
                            try {
                                map.addControlsForRT(rtType, idList, true, CodeGenRegistryReader.singleton.virtualComponent);
                            }
                            catch (CoreException coreException) {
                                throw new BeanInfoNatureNotFoundException(CodeGenRegistryReader.singleton.virtualComponent);
                            }
                        }
                        if ((genClass = innerChild.getAttribute(CM_ATTR_CGen)) != null) {
                            try {
                                map.addGeneratorForRT(rtType, new GeneratorElement(innerChild, CM_ATTR_CGen), CodeGenRegistryReader.singleton.virtualComponent);
                            }
                            catch (CoreException coreException) {
                                throw new BeanInfoNatureNotFoundException(CodeGenRegistryReader.singleton.virtualComponent);
                            }
                        }
                    } else if (innerChild.getName().equalsIgnoreCase(CM_DefGen_ELMNT) && (clazz = innerChild.getAttribute(CLASS_ATT)) != null) {
                        map.setDefaultGenerator(new GeneratorElement(innerChild, CLASS_ATT));
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.controlMaps.put(pageType, map);
        map.sortRuntimeTypes(CodeGenRegistryReader.singleton.virtualComponent);
        return true;
    }

    private List getControlList(String ids) {
        StringTokenizer tknr = new StringTokenizer(ids, ",");
        ArrayList<String> idList = new ArrayList<String>(1);
        while (tknr.hasMoreTokens()) {
            String id = tknr.nextToken();
            id = id.trim();
            idList.add(id);
        }
        return idList;
    }

    private void parseCMs() {
        this.readRegistry(Platform.getExtensionRegistry(), PageDataModelPlugin.getDefault().getBundle().getSymbolicName(), CM_EXTPNT_ID);
    }
}

