/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedatamodel.impl;

import com.ibm.etools.webtools.pagedatamodel.api.IPageDataChangeListener;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNotifier;
import java.util.ArrayList;
import java.util.List;

public class PageDataNotifier
implements IPageDataNotifier {
    private List listeners = new ArrayList(5);

    @Override
    public void addPageDataChangedListener(IPageDataChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removePageDataChangedListener(IPageDataChangeListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void firePageNodeAdded(IPageDataNode parent, IPageDataNode addedChild) {
        if (this.listeners.size() > 0) {
            int size = this.listeners.size();
            int i = size - 1;
            while (i >= 0) {
                try {
                    ((IPageDataChangeListener)this.listeners.get(i)).nodeAdded(parent, addedChild);
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
                --i;
            }
        }
    }

    @Override
    public void firePageNodeRemoved(IPageDataNode parent, IPageDataNode removedChild) {
        if (this.listeners.size() > 0) {
            int size = this.listeners.size();
            int i = size - 1;
            while (i >= 0) {
                ((IPageDataChangeListener)this.listeners.get(i)).nodeRemoved(parent, removedChild);
                --i;
            }
        }
    }

    @Override
    public void firePageNodeChanged(IPageDataNode originalNode, IPageDataNode changedNode) {
        if (this.listeners.size() > 0) {
            int size = this.listeners.size();
            int i = size - 1;
            while (i >= 0) {
                ((IPageDataChangeListener)this.listeners.get(i)).nodeChanged(originalNode, changedNode);
                --i;
            }
        }
    }
}

