/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedatamodel.impl;

import com.ibm.etools.webtools.pagedatamodel.PageDataModelPlugin;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNodeProvider;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.sse.ui.internal.util.RegistryReader;
import org.osgi.framework.Bundle;

public class PageDataNodeProvidersRegistryReader
extends RegistryReader {
    public static final String PRVDR_EXT_PNT_ID = "pageDataNodeProviders";
    public static final String PRVDR_ELMNT = "provider";
    public static final String PLT_ITEM = "paletteItem";
    public static final String CLASS_ATT = "class";
    public static final String ID_ATT = "id";
    public static final String LABEL_ATT = "label";
    public static final String ICON_ATT = "icon";
    public static final String CAT_ATT = "category";
    public static final String CAT_ELMNT = "category";
    public static final String PAGETYPE_ATT = "pageType";
    public static final String ALLPAGETYPES_VALUE = "ALL";
    public static final String TYPE_ID = "typeID";
    private static PageDataNodeProvidersRegistryReader singleton;
    private boolean providersParsed = false;
    private Set paletteItemIds;
    private Set paletteItemCategories;
    private Map _categories;
    private Map pageTypeToProvidersMap;
    private List pageDataNodeProviderElements = new ArrayList(5);
    private List elementProviderPairs;

    protected PageDataNodeProvidersRegistryReader() {
        this.paletteItemIds = new HashSet(1);
        this.paletteItemCategories = new HashSet(1);
        this.elementProviderPairs = new ArrayList(5);
    }

    private void parseProviders() {
        this.readRegistry(Platform.getPluginRegistry(), PageDataModelPlugin.getDefault().getBundle().getSymbolicName(), PRVDR_EXT_PNT_ID);
    }

    protected boolean readElement(IConfigurationElement element) {
        if (element.getName().equalsIgnoreCase("category")) {
            return this.parseCategoryElement(element);
        }
        if (element.getName().equalsIgnoreCase(PRVDR_ELMNT)) {
            return this.parseProviderElement(element);
        }
        return false;
    }

    private boolean parseProviderElement(IConfigurationElement element) {
        ArrayList<ElementProviderPair> providers;
        String providerClass = element.getAttribute(CLASS_ATT);
        if (providerClass == null) {
            return true;
        }
        this.pageDataNodeProviderElements.add(element);
        ElementProviderPair pair = new ElementProviderPair();
        pair.element = element;
        this.elementProviderPairs.add(pair);
        String pageType = element.getAttribute(PAGETYPE_ATT);
        if (pageType == null) {
            pageType = ALLPAGETYPES_VALUE;
        }
        if (this.pageTypeToProvidersMap == null) {
            this.pageTypeToProvidersMap = new HashMap(3);
        }
        if ((providers = (ArrayList<ElementProviderPair>)this.pageTypeToProvidersMap.get(pageType)) == null) {
            providers = new ArrayList<ElementProviderPair>();
            this.pageTypeToProvidersMap.put(pageType, providers);
        }
        providers.add(pair);
        IConfigurationElement[] paletteItems = element.getChildren(PLT_ITEM);
        int i = 0;
        while (paletteItems != null && i < paletteItems.length) {
            String id;
            String category = paletteItems[i].getAttribute("category");
            if (category != null && !category.equals("")) {
                this.paletteItemCategories.add(category);
            }
            if ((id = paletteItems[i].getAttribute(ID_ATT)) != null && !id.equals("")) {
                this.paletteItemIds.add(id);
            }
            ++i;
        }
        return true;
    }

    private boolean parseCategoryElement(IConfigurationElement element) {
        String id = element.getAttribute(ID_ATT);
        if (id != null && !id.equals("")) {
            String label;
            if (this._categories == null) {
                this._categories = new HashMap(2);
            }
            if ((label = element.getAttribute(LABEL_ATT)) == null || label.equals("")) {
                label = id;
            }
            String subdirectoryAndFilename = element.getAttribute(ICON_ATT);
            Bundle plugin = Platform.getBundle((String)element.getDeclaringExtension().getNamespace());
            URL fullPathString = Platform.find((Bundle)plugin, (IPath)new Path(subdirectoryAndFilename));
            if (fullPathString == null) {
                URL path = plugin.getEntry("/");
                try {
                    fullPathString = new URL(path, subdirectoryAndFilename);
                }
                catch (MalformedURLException e) {
                    PageDataModelPlugin.getDefault().write(e.getMessage());
                }
            }
            Category newCat = new Category();
            newCat.label = label;
            newCat.urlToIcon = fullPathString;
            this._categories.put(id, newCat);
            return true;
        }
        return false;
    }

    private IPageDataNodeProvider[] getProviders() {
        if (!this.providersParsed) {
            this.parseProviders();
            this.providersParsed = true;
        }
        ArrayList<IPageDataNodeProvider> allProviders = new ArrayList<IPageDataNodeProvider>();
        int i = 0;
        while (i < this.elementProviderPairs.size()) {
            ElementProviderPair pair = (ElementProviderPair)this.elementProviderPairs.get(i);
            if (pair.provider == null) {
                pair.provider = (IPageDataNodeProvider)this.createClass(pair.element);
            }
            allProviders.add(pair.provider);
            ++i;
        }
        return allProviders.toArray(new IPageDataNodeProvider[allProviders.size()]);
    }

    private IPageDataNodeProvider[] getProviders(List pageTypes) {
        if (!this.providersParsed) {
            this.parseProviders();
            this.providersParsed = true;
        }
        ArrayList elementProviderPairsForPageType = new ArrayList();
        int i = 0;
        while (i < pageTypes.size()) {
            String pageType = (String)pageTypes.get(i);
            List temp = (List)this.pageTypeToProvidersMap.get(pageType);
            if (temp != null) {
                elementProviderPairsForPageType.addAll(temp);
            }
            ++i;
        }
        List temp = (List)this.pageTypeToProvidersMap.get(ALLPAGETYPES_VALUE);
        if (temp != null) {
            elementProviderPairsForPageType.addAll(temp);
        }
        ArrayList<IPageDataNodeProvider> providers = new ArrayList<IPageDataNodeProvider>();
        if (elementProviderPairsForPageType != null) {
            int i2 = 0;
            while (i2 < elementProviderPairsForPageType.size()) {
                ElementProviderPair pair = (ElementProviderPair)elementProviderPairsForPageType.get(i2);
                if (pair.provider == null) {
                    pair.provider = (IPageDataNodeProvider)this.createClass(pair.element);
                }
                providers.add(pair.provider);
                ++i2;
            }
            return providers.toArray(new IPageDataNodeProvider[providers.size()]);
        }
        return new IPageDataNodeProvider[0];
    }

    public static IPageDataNodeProvider[] getPageDataNodeProviders() {
        if (singleton == null) {
            singleton = new PageDataNodeProvidersRegistryReader();
        }
        return singleton.getProviders();
    }

    public static IPageDataNodeProvider[] getPageDataNodeProviders(List pageTypes) {
        if (singleton == null) {
            singleton = new PageDataNodeProvidersRegistryReader();
        }
        return singleton.getProviders(pageTypes);
    }

    public static Map getProvidersWithCategory() {
        if (singleton == null) {
            singleton = new PageDataNodeProvidersRegistryReader();
        }
        if (!PageDataNodeProvidersRegistryReader.singleton.providersParsed) {
            singleton.parseProviders();
            PageDataNodeProvidersRegistryReader.singleton.providersParsed = true;
        }
        HashMap<IPageDataNodeProvider, String> map = new HashMap<IPageDataNodeProvider, String>();
        int i = 0;
        while (i < PageDataNodeProvidersRegistryReader.singleton.elementProviderPairs.size()) {
            ElementProviderPair pair = (ElementProviderPair)PageDataNodeProvidersRegistryReader.singleton.elementProviderPairs.get(i);
            String category = pair.element.getAttribute("category");
            if (category != null) {
                if (pair.provider == null) {
                    pair.provider = (IPageDataNodeProvider)singleton.createClass(pair.element);
                }
                map.put(pair.provider, category);
            }
            ++i;
        }
        return map;
    }

    public static Map getCategories() {
        if (singleton == null) {
            singleton = new PageDataNodeProvidersRegistryReader();
        }
        if (!PageDataNodeProvidersRegistryReader.singleton.providersParsed) {
            singleton.parseProviders();
            PageDataNodeProvidersRegistryReader.singleton.providersParsed = true;
        }
        return PageDataNodeProvidersRegistryReader.singleton._categories;
    }

    public static IConfigurationElement[] getPageDataNodeProviderElements() {
        if (singleton == null) {
            singleton = new PageDataNodeProvidersRegistryReader();
        }
        if (!PageDataNodeProvidersRegistryReader.singleton.providersParsed) {
            singleton.parseProviders();
            PageDataNodeProvidersRegistryReader.singleton.providersParsed = true;
        }
        return PageDataNodeProvidersRegistryReader.singleton.pageDataNodeProviderElements.toArray(new IConfigurationElement[PageDataNodeProvidersRegistryReader.singleton.pageDataNodeProviderElements.size()]);
    }

    public static boolean isPaletteIdRegistered(String id) {
        if (singleton == null) {
            singleton = new PageDataNodeProvidersRegistryReader();
        }
        return PageDataNodeProvidersRegistryReader.singleton.paletteItemIds.contains(id);
    }

    public static boolean isPaletteCategoryRegistered(String cat) {
        if (singleton == null) {
            singleton = new PageDataNodeProvidersRegistryReader();
        }
        return PageDataNodeProvidersRegistryReader.singleton.paletteItemCategories.contains(cat);
    }

    public static IPageDataNodeProvider getPageDataNodeProvider(IConfigurationElement element) {
        if (singleton == null) {
            singleton = new PageDataNodeProvidersRegistryReader();
        }
        if (!PageDataNodeProvidersRegistryReader.singleton.providersParsed) {
            singleton.parseProviders();
            PageDataNodeProvidersRegistryReader.singleton.providersParsed = true;
        }
        IPageDataNodeProvider provider = null;
        int i = 0;
        while (i < PageDataNodeProvidersRegistryReader.singleton.elementProviderPairs.size()) {
            ElementProviderPair pair = (ElementProviderPair)PageDataNodeProvidersRegistryReader.singleton.elementProviderPairs.get(i);
            if (pair.element.equals((Object)element)) {
                if (pair.provider == null) {
                    pair.provider = (IPageDataNodeProvider)singleton.createClass(element);
                }
                provider = pair.provider;
                break;
            }
            ++i;
        }
        return provider;
    }

    public static String getCategoryForProvider(IPageDataNodeProvider provider) {
        String category = null;
        if (singleton == null) {
            singleton = new PageDataNodeProvidersRegistryReader();
        }
        int i = 0;
        while (i < PageDataNodeProvidersRegistryReader.singleton.elementProviderPairs.size()) {
            ElementProviderPair pair = (ElementProviderPair)PageDataNodeProvidersRegistryReader.singleton.elementProviderPairs.get(i);
            if (pair.provider != null && pair.provider.equals(provider)) {
                category = pair.element.getAttribute("category");
                break;
            }
            ++i;
        }
        return category;
    }

    private Object createClass(IConfigurationElement element) {
        Object classObject = null;
        try {
            classObject = element.createExecutableExtension(CLASS_ATT);
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
        return classObject;
    }

    public class Category {
        public String label;
        public URL urlToIcon;
    }

    private class ElementProviderPair {
        public IConfigurationElement element;
        public IPageDataNodeProvider provider;

        private ElementProviderPair() {
        }
    }
}

